/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.MatchTable;
import org.opennms.core.utils.PropertiesUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.EventTranslatorConfig;
import org.opennms.netmgt.config.translator.Assignment;
import org.opennms.netmgt.config.translator.EventTranslationSpec;
import org.opennms.netmgt.config.translator.EventTranslatorConfiguration;
import org.opennms.netmgt.config.translator.Mapping;
import org.opennms.netmgt.config.translator.Translation;
import org.opennms.netmgt.config.translator.Value;
import org.opennms.netmgt.dao.castor.CastorUtils;
import org.opennms.netmgt.eventd.EventUtil;
import org.opennms.netmgt.utils.SingleResultQuerier;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.FatalBeanException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EventTranslatorConfigFactory
implements EventTranslatorConfig {
    private static EventTranslatorConfig m_singleton = null;
    private EventTranslatorConfiguration m_config;
    private List<TranslationSpec> m_translationSpecs;
    private static boolean m_loaded = false;
    private DataSource m_dbConnFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EventTranslatorConfigFactory(String configFile, DataSource dbConnFactory) throws IOException, MarshalException, ValidationException {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(configFile);
            this.marshall(stream, dbConnFactory);
            Object var5_4 = null;
            if (stream == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (stream == null) throw throwable;
            IOUtils.closeQuietly((InputStream)stream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)stream);
    }

    @Deprecated
    public EventTranslatorConfigFactory(Reader rdr, DataSource dbConnFactory) throws MarshalException, ValidationException {
        this.marshall(rdr, dbConnFactory);
    }

    private synchronized void marshall(InputStream stream, DataSource dbConnFactory) throws MarshalException, ValidationException {
        this.m_config = (EventTranslatorConfiguration)CastorUtils.unmarshal(EventTranslatorConfiguration.class, (InputStream)stream);
        this.m_dbConnFactory = dbConnFactory;
    }

    @Deprecated
    private synchronized void marshall(Reader rdr, DataSource dbConnFactory) throws MarshalException, ValidationException {
        this.m_config = (EventTranslatorConfiguration)CastorUtils.unmarshal(EventTranslatorConfiguration.class, (Reader)rdr);
        this.m_dbConnFactory = dbConnFactory;
    }

    private synchronized void marshall(InputStream stream) throws MarshalException, ValidationException {
        this.m_config = (EventTranslatorConfiguration)CastorUtils.unmarshal(EventTranslatorConfiguration.class, (InputStream)stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void update() throws Exception {
        EventTranslatorConfigFactory eventTranslatorConfigFactory = this;
        synchronized (eventTranslatorConfigFactory) {
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.TRANSLATOR_CONFIG_FILE_NAME);
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(cfgFile);
                this.marshall(stream);
                Object var5_4 = null;
                if (stream == null) return;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (stream == null) throw throwable;
                IOUtils.closeQuietly((InputStream)stream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)stream);
            {
            }
            return;
        }
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException, ClassNotFoundException, SQLException, PropertyVetoException {
        if (m_loaded) {
            return;
        }
        DataSourceFactory.init();
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.TRANSLATOR_CONFIG_FILE_NAME);
        m_singleton = new EventTranslatorConfigFactory(cfgFile.getPath(), DataSourceFactory.getInstance());
        m_loaded = true;
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException, ClassNotFoundException, SQLException, PropertyVetoException {
        m_singleton = null;
        m_loaded = false;
        EventTranslatorConfigFactory.init();
    }

    public static synchronized EventTranslatorConfig getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("getInstance: The factory has not been initialized");
        }
        return m_singleton;
    }

    public static void setInstance(EventTranslatorConfig singleton) {
        m_singleton = singleton;
        m_loaded = true;
    }

    private Category log() {
        return ThreadCategory.getInstance(EventTranslatorConfig.class);
    }

    private synchronized EventTranslatorConfiguration getConfig() {
        return this.m_config;
    }

    @Override
    public List<String> getUEIList() {
        return this.getTranslationUEIs();
    }

    private List<String> getTranslationUEIs() {
        Translation translation = this.getConfig().getTranslation();
        if (translation == null) {
            return Collections.emptyList();
        }
        ArrayList<String> ueis = new ArrayList<String>();
        for (EventTranslationSpec event : translation.getEventTranslationSpecCollection()) {
            ueis.add(event.getUei());
        }
        return ueis;
    }

    @Override
    public boolean isTranslationEvent(Event e) {
        for (TranslationSpec spec : this.getTranslationSpecs()) {
            if (!spec.matches(e)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Event> translateEvent(Event e) {
        ArrayList<Event> events = new ArrayList<Event>();
        for (TranslationSpec spec : this.getTranslationSpecs()) {
            events.addAll(spec.translate(e));
        }
        return events;
    }

    private List<TranslationSpec> getTranslationSpecs() {
        if (this.m_translationSpecs == null) {
            this.m_translationSpecs = this.constructTranslationSpecs();
        }
        return this.m_translationSpecs;
    }

    private List<TranslationSpec> constructTranslationSpecs() {
        ArrayList<TranslationSpec> specs = new ArrayList<TranslationSpec>();
        for (EventTranslationSpec eventTrans : this.m_config.getTranslation().getEventTranslationSpecCollection()) {
            specs.add(new TranslationSpec(eventTrans));
        }
        return specs;
    }

    ValueSpec getValueSpec(Value val) {
        if ("field".equals(val.getType())) {
            return new FieldValueSpec(val);
        }
        if ("parameter".equals(val.getType())) {
            return new ParameterValueSpec(val);
        }
        if ("constant".equals(val.getType())) {
            return new ConstantValueSpec(val);
        }
        if ("sql".equals(val.getType())) {
            return new SqlValueSpec(val);
        }
        return new ValueSpecUnspecified();
    }

    class ParameterValueSpec
    extends AttributeValueSpec {
        ParameterValueSpec(Value val) {
            super(val);
        }

        public String getAttributeValue(Event e) {
            String attrName = this.getAttributeName();
            Parms parms = e.getParms();
            if (parms == null) {
                return null;
            }
            for (Parm parm : parms.getParmCollection()) {
                if (parm.getParmName().equals(attrName)) {
                    if (EventTranslatorConfigFactory.this.log().isDebugEnabled()) {
                        EventTranslatorConfigFactory.this.log().debug((Object)("getAttributeValue: eventParm name: '" + parm.getParmName() + " equals translation parameter name: '" + attrName));
                    }
                    return parm.getValue() == null ? "" : parm.getValue().getContent();
                }
                String trimmedAttrName = StringUtils.removeStart((String)attrName, (String)"~");
                if (!attrName.startsWith("~") || !parm.getParmName().matches(trimmedAttrName)) continue;
                if (EventTranslatorConfigFactory.this.log().isDebugEnabled()) {
                    EventTranslatorConfigFactory.this.log().debug((Object)("getAttributeValue: eventParm name: '" + parm.getParmName() + " matches translation parameter name expression: '" + trimmedAttrName));
                }
                return parm.getValue() == null ? "" : parm.getValue().getContent();
            }
            return null;
        }
    }

    class FieldValueSpec
    extends AttributeValueSpec {
        public FieldValueSpec(Value val) {
            super(val);
        }

        public String getAttributeValue(Event e) {
            try {
                BeanWrapperImpl bean = this.getBeanWrapper(e);
                return (String)bean.convertIfNecessary(bean.getPropertyValue(this.getAttributeName()), String.class);
            }
            catch (FatalBeanException ex) {
                EventTranslatorConfigFactory.this.log().error((Object)("Property " + this.getAttributeName() + " does not exist on Event"), (Throwable)ex);
                throw new TranslationFailedException("Property " + this.getAttributeName() + " does not exist on Event");
            }
        }

        private BeanWrapperImpl getBeanWrapper(Event e) {
            BeanWrapperImpl bean = new BeanWrapperImpl((Object)e);
            bean.registerCustomEditor(String.class, (PropertyEditor)new StringPropertyEditor());
            return bean;
        }
    }

    class StringPropertyEditor
    extends PropertyEditorSupport {
        StringPropertyEditor() {
        }

        public void setValue(Object value) {
            if (value == null || value instanceof String) {
                super.setValue(value);
            } else {
                super.setValue(value.toString());
            }
        }

        public String getAsText() {
            return (String)super.getValue();
        }

        public void setAsText(String text) throws IllegalArgumentException {
            super.setValue(text);
        }
    }

    abstract class AttributeValueSpec
    extends ValueSpec {
        Value m_val;

        AttributeValueSpec(Value val) {
            this.m_val = val;
        }

        public boolean matches(Event e) {
            String attributeValue = this.getAttributeValue(e);
            if (attributeValue == null) {
                EventTranslatorConfigFactory.this.log().debug((Object)"AttributeValueSpec.matches: Event attributeValue doesn't match because attributeValue itself is null");
                return false;
            }
            if (this.m_val.getMatches() == null) {
                if (EventTranslatorConfigFactory.this.log().isDebugEnabled()) {
                    EventTranslatorConfigFactory.this.log().debug((Object)("AttributeValueSpec.matches: Event attributeValue: " + attributeValue + " matches because pattern is null"));
                }
                return true;
            }
            Pattern p = Pattern.compile(this.m_val.getMatches());
            Matcher m = p.matcher(attributeValue);
            if (EventTranslatorConfigFactory.this.log().isDebugEnabled()) {
                EventTranslatorConfigFactory.this.log().debug((Object)("AttributeValueSpec.matches: Event attributeValue: " + attributeValue + " " + (m.matches() ? "matches" : "doesn't match") + " pattern: " + this.m_val.getMatches()));
            }
            return m.matches();
        }

        public String getResult(Event srcEvent) {
            if (this.m_val.getMatches() == null) {
                return this.m_val.getResult();
            }
            String attributeValue = this.getAttributeValue(srcEvent);
            if (attributeValue == null) {
                throw new TranslationFailedException("failed to match null against '" + this.m_val.getMatches() + "' for attribute " + this.getAttributeName());
            }
            Pattern p = Pattern.compile(this.m_val.getMatches());
            Matcher m = p.matcher(attributeValue);
            if (!m.matches()) {
                throw new TranslationFailedException("failed to match " + attributeValue + " against '" + this.m_val.getMatches() + "' for attribute " + this.getAttributeName());
            }
            MatchTable matches = new MatchTable(m);
            return PropertiesUtils.substitute((String)this.m_val.getResult(), (PropertiesUtils.SymbolTable)matches);
        }

        public String getAttributeName() {
            return this.m_val.getName();
        }

        public abstract String getAttributeValue(Event var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SqlValueSpec
    extends ValueSpec {
        Value m_val;
        List<ValueSpec> m_nestedValues;

        public SqlValueSpec(Value val) {
            this.m_val = val;
            this.m_nestedValues = null;
        }

        public List<ValueSpec> getNestedValues() {
            if (this.m_nestedValues == null) {
                this.m_nestedValues = this.constructNestedValues();
            }
            return this.m_nestedValues;
        }

        private List<ValueSpec> constructNestedValues() {
            ArrayList<ValueSpec> nestedValues = new ArrayList<ValueSpec>();
            for (Value val : this.m_val.getValueCollection()) {
                nestedValues.add(EventTranslatorConfigFactory.this.getValueSpec(val));
            }
            return nestedValues;
        }

        @Override
        public boolean matches(Event e) {
            for (ValueSpec nestedVal : this.getNestedValues()) {
                if (nestedVal.matches(e)) continue;
                return false;
            }
            return true;
        }

        @Override
        public String getResult(Event srcEvent) {
            SingleResultQuerier querier = new SingleResultQuerier(EventTranslatorConfigFactory.this.m_dbConnFactory, this.m_val.getResult());
            Object[] args = new Object[this.getNestedValues().size()];
            for (int i = 0; i < args.length; ++i) {
                args[i] = this.getNestedValues().get(i).getResult(srcEvent);
            }
            querier.execute(args);
            if (querier.getCount() < 1) {
                EventTranslatorConfigFactory.this.log().info((Object)("No results found for query " + querier.reproduceStatement(args) + ". Returning null"));
                return null;
            }
            Object result = querier.getResult();
            if (EventTranslatorConfigFactory.this.log().isDebugEnabled()) {
                EventTranslatorConfigFactory.this.log().debug((Object)("getResult: result of single result querier is:" + result));
            }
            if (result != null) {
                return result.toString();
            }
            return null;
        }
    }

    class ValueSpecUnspecified
    extends ValueSpec {
        ValueSpecUnspecified() {
        }

        public boolean matches(Event e) {
            return true;
        }

        public String getResult(Event srcEvent) {
            return "value unspecified";
        }
    }

    class ConstantValueSpec
    extends ValueSpec {
        Value m_constant;

        public ConstantValueSpec(Value constant) {
            this.m_constant = constant;
        }

        public boolean matches(Event e) {
            if (this.m_constant.getMatches() != null) {
                EventTranslatorConfigFactory.this.log().warn((Object)"ConstantValueSpec.matches: matches not allowed for constant value.");
                throw new IllegalStateException("Illegal to use matches with constant type values");
            }
            return true;
        }

        public String getResult(Event srcEvent) {
            return this.m_constant.getResult();
        }
    }

    abstract class ValueSpec {
        ValueSpec() {
        }

        public abstract boolean matches(Event var1);

        public abstract String getResult(Event var1);
    }

    class ParameterAssignmentSpec
    extends AssignmentSpec {
        ParameterAssignmentSpec(Assignment assign) {
            super(assign);
        }

        protected void setValue(Event targetEvent, String value) {
            Parms parms = targetEvent.getParms();
            if (parms == null) {
                parms = new Parms();
                targetEvent.setParms(parms);
            }
            if (value == null) {
                EventTranslatorConfigFactory.this.log().debug((Object)"Value of parameter is null setting to blank");
                value = "";
            }
            for (Parm parm : parms.getParmCollection()) {
                if (!parm.getParmName().equals(this.getAttributeName())) continue;
                org.opennms.netmgt.xml.event.Value val = parm.getValue();
                if (val == null) {
                    val = new org.opennms.netmgt.xml.event.Value();
                    parm.setValue(val);
                }
                if (EventTranslatorConfigFactory.this.log().isDebugEnabled()) {
                    EventTranslatorConfigFactory.this.log().debug((Object)("Overriding value of parameter " + this.getAttributeName() + ". Setting it to " + value));
                }
                val.setContent(value);
                return;
            }
            Parm newParm = new Parm();
            parms.addParm(newParm);
            newParm.setParmName(this.getAttributeName());
            org.opennms.netmgt.xml.event.Value val = new org.opennms.netmgt.xml.event.Value();
            newParm.setValue(val);
            if (EventTranslatorConfigFactory.this.log().isDebugEnabled()) {
                EventTranslatorConfigFactory.this.log().debug((Object)("Setting value of parameter " + this.getAttributeName() + " to " + value));
            }
            val.setContent(value);
        }
    }

    class FieldAssignmentSpec
    extends AssignmentSpec {
        FieldAssignmentSpec(Assignment field) {
            super(field);
        }

        protected void setValue(Event targetEvent, String value) {
            try {
                BeanWrapperImpl bean = new BeanWrapperImpl((Object)targetEvent);
                bean.setPropertyValue(this.getAttributeName(), (Object)value);
            }
            catch (FatalBeanException e) {
                EventTranslatorConfigFactory.this.log().error((Object)("Unable to set value for attribute " + this.getAttributeName() + "to value " + value + " Exception:" + (Object)((Object)e)));
                throw new TranslationFailedException("Unable to set value for attribute " + this.getAttributeName() + " to value " + value);
            }
        }
    }

    abstract class AssignmentSpec {
        private Assignment m_assignment;
        private ValueSpec m_valueSpec;

        AssignmentSpec(Assignment assignment) {
            this.m_assignment = assignment;
            this.m_valueSpec = null;
        }

        public void apply(Event srcEvent, Event targetEvent) {
            this.setValue(targetEvent, this.getValueSpec().getResult(srcEvent));
        }

        private Assignment getAssignment() {
            return this.m_assignment;
        }

        protected String getAttributeName() {
            return this.getAssignment().getName();
        }

        private ValueSpec constructValueSpec() {
            Value val = this.getAssignment().getValue();
            return EventTranslatorConfigFactory.this.getValueSpec(val);
        }

        protected abstract void setValue(Event var1, String var2);

        private ValueSpec getValueSpec() {
            if (this.m_valueSpec == null) {
                this.m_valueSpec = this.constructValueSpec();
            }
            return this.m_valueSpec;
        }

        boolean matches(Event e) {
            return this.getValueSpec().matches(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TranslationMapping {
        Mapping m_mapping;
        List<AssignmentSpec> m_assignments;

        TranslationMapping(Mapping mapping) {
            this.m_mapping = mapping;
            this.m_assignments = null;
        }

        public Event translate(Event srcEvent) {
            if (!this.matches(srcEvent)) {
                return null;
            }
            Event targetEvent = this.cloneEvent(srcEvent);
            for (AssignmentSpec assignSpec : this.getAssignmentSpecs()) {
                assignSpec.apply(srcEvent, targetEvent);
            }
            targetEvent.setSource("OpenNMS.EventTranslator");
            return targetEvent;
        }

        private Event cloneEvent(Event srcEvent) {
            Event clonedEvent = EventUtil.cloneEvent(srcEvent);
            clonedEvent.setAlarmData(null);
            clonedEvent.setSeverity(null);
            return clonedEvent;
        }

        public Mapping getMapping() {
            return this.m_mapping;
        }

        private List<AssignmentSpec> getAssignmentSpecs() {
            if (this.m_assignments == null) {
                this.m_assignments = this.constructAssignmentSpecs();
            }
            return this.m_assignments;
        }

        private List<AssignmentSpec> constructAssignmentSpecs() {
            Mapping mapping = this.getMapping();
            ArrayList<AssignmentSpec> assignments = new ArrayList<AssignmentSpec>();
            for (Assignment assign : mapping.getAssignmentCollection()) {
                AssignmentSpec assignSpec = "parameter".equals(assign.getType()) ? new ParameterAssignmentSpec(assign) : new FieldAssignmentSpec(assign);
                assignments.add(assignSpec);
            }
            return assignments;
        }

        private boolean assignmentsMatch(Event e) {
            AssignmentSpec assignSpec2 = null;
            for (AssignmentSpec assignSpec2 : this.getAssignmentSpecs()) {
                if (assignSpec2.matches(e)) continue;
                if (EventTranslatorConfigFactory.this.log().isDebugEnabled()) {
                    EventTranslatorConfigFactory.this.log().debug((Object)("TranslationMapping.assignmentsMatch: assignmentSpec: " + assignSpec2.getAttributeName() + " doesn't match."));
                }
                return false;
            }
            if (EventTranslatorConfigFactory.this.log().isDebugEnabled()) {
                EventTranslatorConfigFactory.this.log().debug((Object)("TranslationMapping.assignmentsMatch: assignmentSpec: " + assignSpec2.getAttributeName() + " matches!"));
            }
            return true;
        }

        boolean matches(Event e) {
            return this.assignmentsMatch(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TranslationSpec {
        private EventTranslationSpec m_spec;
        private List<TranslationMapping> m_translationMappings;

        TranslationSpec(EventTranslationSpec spec) {
            this.m_spec = spec;
            this.m_translationMappings = null;
        }

        public List<Event> translate(Event e) {
            if (!this.ueiMatches(e)) {
                return Collections.emptyList();
            }
            ArrayList<Event> events = new ArrayList<Event>();
            for (TranslationMapping mapping : this.getTranslationMappings()) {
                Event translatedEvent = mapping.translate(e);
                if (translatedEvent == null) continue;
                events.add(translatedEvent);
            }
            return events;
        }

        String getUei() {
            return this.m_spec.getUei();
        }

        public EventTranslationSpec getEventTranslationSpec() {
            return this.m_spec;
        }

        private List<TranslationMapping> constructTranslationMappings() {
            if (this.m_spec.getMappings() == null) {
                return Collections.emptyList();
            }
            List mappings = this.m_spec.getMappings().getMappingCollection();
            ArrayList<TranslationMapping> transMaps = new ArrayList<TranslationMapping>(mappings.size());
            for (Mapping mapping : mappings) {
                TranslationMapping transMap = new TranslationMapping(mapping);
                transMaps.add(transMap);
            }
            return transMaps;
        }

        List<TranslationMapping> getTranslationMappings() {
            if (this.m_translationMappings == null) {
                this.m_translationMappings = this.constructTranslationMappings();
            }
            return this.m_translationMappings;
        }

        boolean matches(Event e) {
            if (!this.ueiMatches(e)) {
                if (EventTranslatorConfigFactory.this.log().isDebugEnabled()) {
                    EventTranslatorConfigFactory.this.log().debug((Object)("TransSpec.matches: No match comparing spec UEI: " + this.m_spec.getUei() + " with event UEI: " + e.getUei()));
                }
                return false;
            }
            EventTranslatorConfigFactory.this.log().debug((Object)"TransSpec.matches: checking mappings for spec.");
            for (TranslationMapping transMap : this.getTranslationMappings()) {
                if (!transMap.matches(e)) continue;
                return true;
            }
            return false;
        }

        private boolean ueiMatches(Event e) {
            return e.getUei().equals(this.m_spec.getUei()) || this.m_spec.getUei().endsWith("/") && e.getUei().startsWith(this.m_spec.getUei());
        }
    }

    static class TranslationFailedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        TranslationFailedException(String msg) {
            super(msg);
        }
    }
}

