/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.DestinationPathManager;

public class DestinationPathFactory
extends DestinationPathManager {
    private static DestinationPathFactory instance;
    private static File m_notifConfFile;
    private static boolean initialized;
    private static File m_pathsConfFile;
    private static long m_lastModified;

    public static synchronized void init() throws IOException, FileNotFoundException, MarshalException, ValidationException {
        if (!initialized) {
            DestinationPathFactory.getInstance().reload();
            initialized = true;
        }
    }

    public static synchronized DestinationPathFactory getInstance() {
        if (instance == null || !initialized) {
            instance = new DestinationPathFactory();
        }
        return instance;
    }

    public void reload() throws IOException, FileNotFoundException, MarshalException, ValidationException {
        m_pathsConfFile = ConfigFileConstants.getFile((int)ConfigFileConstants.DESTINATION_PATHS_CONF_FILE_NAME);
        FileInputStream configIn = new FileInputStream(m_pathsConfFile);
        m_lastModified = m_pathsConfFile.lastModified();
        this.parseXML(configIn);
        ((InputStream)configIn).close();
    }

    protected void saveXML(String writerString) throws IOException {
        if (writerString != null) {
            FileWriter fileWriter = new FileWriter(m_pathsConfFile);
            fileWriter.write(writerString);
            fileWriter.flush();
            fileWriter.close();
        }
    }

    public void update() throws IOException, MarshalException, ValidationException, FileNotFoundException {
        if (m_lastModified != m_pathsConfFile.lastModified()) {
            this.reload();
        }
    }

    static {
        initialized = false;
    }
}

