/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.CapsdConfigManager;

public class DefaultCapsdConfigManager
extends CapsdConfigManager {
    private long m_currentVersion = -1L;

    public DefaultCapsdConfigManager() {
    }

    @Deprecated
    public DefaultCapsdConfigManager(Reader rdr) throws MarshalException, ValidationException {
        super(rdr);
    }

    public DefaultCapsdConfigManager(InputStream is) throws MarshalException, ValidationException {
        super(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void update() throws IOException, FileNotFoundException, MarshalException, ValidationException {
        File configFile = ConfigFileConstants.getFile((int)ConfigFileConstants.CAPSD_CONFIG_FILE_NAME);
        this.log().debug((Object)("Checking to see if capsd configuration should be reloaded from " + configFile));
        if (this.m_currentVersion < configFile.lastModified()) {
            long lastModified;
            block4: {
                this.log().debug((Object)"Reloading capsd configuration file");
                lastModified = configFile.lastModified();
                FileInputStream is = null;
                try {
                    is = new FileInputStream(configFile);
                    this.loadXml(is);
                    Object var6_4 = null;
                    if (is == null) break block4;
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    if (is != null) {
                        IOUtils.closeQuietly((InputStream)is);
                    }
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)is);
            }
            this.m_currentVersion = lastModified;
            this.log().info((Object)"Reloaded capsd configuration file");
        }
    }

    protected synchronized void saveXml(String xml) throws IOException {
        if (xml != null) {
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.CAPSD_CONFIG_FILE_NAME);
            FileWriter fileWriter = new FileWriter(cfgFile);
            fileWriter.write(xml);
            fileWriter.flush();
            fileWriter.close();
        }
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

