/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import org.opennms.netmgt.model.OnmsSnmpInterface;

public class SnmpIfData {
    private int m_nodeId;
    private boolean m_collectionEnabled;
    private int m_ifIndex;
    private int m_ifType;
    private String m_rrdLabel;
    private String m_ifAlias;

    public SnmpIfData(OnmsSnmpInterface snmpIface) {
        this.m_nodeId = this.nullSafeUnbox(snmpIface.getNode().getId(), -1);
        this.m_collectionEnabled = snmpIface.isCollectionEnabled();
        this.m_ifIndex = this.nullSafeUnbox(snmpIface.getIfIndex(), -1);
        this.m_ifType = this.nullSafeUnbox(snmpIface.getIfType(), -1);
        this.m_rrdLabel = snmpIface.computeLabelForRRD();
        this.m_ifAlias = snmpIface.getIfAlias();
    }

    int nullSafeUnbox(Integer num, int dflt) {
        return num == null ? dflt : num;
    }

    public int getNodeId() {
        return this.m_nodeId;
    }

    public boolean isCollectionEnabled() {
        return this.m_collectionEnabled;
    }

    public int getIfIndex() {
        return this.m_ifIndex;
    }

    public int getIfType() {
        return this.m_ifType;
    }

    public String getLabelForRRD() {
        return this.m_rrdLabel;
    }

    public String getIfAlias() {
        return this.m_ifAlias;
    }
}

