/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.AttributeGroup;
import org.opennms.netmgt.collectd.AttributeGroupType;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.CollectionResource;
import org.opennms.netmgt.collectd.CollectionSetVisitor;
import org.opennms.netmgt.collectd.ResourceType;
import org.opennms.netmgt.collectd.ServiceParameters;
import org.opennms.netmgt.collectd.SnmpAttribute;
import org.opennms.netmgt.collectd.SnmpAttributeType;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.snmp.SnmpValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SnmpCollectionResource
implements CollectionResource {
    private ResourceType m_resourceType;
    private Map<AttributeGroupType, AttributeGroup> m_groups = new HashMap<AttributeGroupType, AttributeGroup>();

    public SnmpCollectionResource(ResourceType def) {
        this.m_resourceType = def;
    }

    public ResourceType getResourceType() {
        return this.m_resourceType;
    }

    public final CollectionAgent getCollectionAgent() {
        return this.m_resourceType.getAgent();
    }

    @Override
    public abstract boolean shouldPersist(ServiceParameters var1);

    @Override
    public String getOwnerName() {
        return this.getCollectionAgent().getHostAddress();
    }

    @Override
    public abstract File getResourceDir(RrdRepository var1);

    @Override
    public abstract int getType();

    public Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    @Override
    public boolean rescanNeeded() {
        return false;
    }

    public void setAttributeValue(SnmpAttributeType type, SnmpValue val) {
        SnmpAttribute attr = new SnmpAttribute(this, type, val);
        this.addAttribute(attr);
    }

    private void addAttribute(SnmpAttribute attr) {
        AttributeGroup group = this.getGroup(attr.getAttributeType().getGroupType());
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("Adding attribute " + attr.getClass().getName() + ": " + attr + " to group " + group));
        }
        group.addAttribute(attr);
    }

    private AttributeGroup getGroup(AttributeGroupType groupType) {
        AttributeGroup group = this.m_groups.get(groupType);
        if (group == null) {
            group = new AttributeGroup(this, groupType);
            this.m_groups.put(groupType, group);
        }
        return group;
    }

    @Override
    public void visit(CollectionSetVisitor visitor) {
        visitor.visitResource(this);
        for (AttributeGroup group : this.getGroups()) {
            group.visit(visitor);
        }
        visitor.completeResource(this);
    }

    protected Collection<AttributeGroup> getGroups() {
        return this.m_groups.values();
    }
}

