/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import org.apache.log4j.Category;
import org.opennms.core.utils.AlphaNumeric;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.OnmsSnmpCollection;
import org.opennms.netmgt.collectd.ResourceType;
import org.opennms.netmgt.collectd.SNMPCollectorEntry;
import org.opennms.netmgt.collectd.ServiceParameters;
import org.opennms.netmgt.collectd.SnmpCollectionResource;
import org.opennms.netmgt.collectd.SnmpIfData;
import org.opennms.netmgt.model.RrdRepository;

public final class IfInfo
extends SnmpCollectionResource {
    private SNMPCollectorEntry m_entry;
    private boolean m_collectionEnabled;
    private int m_nodeId;
    private int m_ifIndex;
    private int m_ifType;
    private String m_label;
    private String m_ifAlias;

    public IfInfo(ResourceType def, CollectionAgent agent, SnmpIfData snmpIfData) {
        super(def);
        this.m_nodeId = snmpIfData.getNodeId();
        this.m_collectionEnabled = snmpIfData.isCollectionEnabled();
        this.m_ifIndex = snmpIfData.getIfIndex();
        this.m_ifType = snmpIfData.getIfType();
        this.m_label = snmpIfData.getLabelForRRD();
        this.m_ifAlias = snmpIfData.getIfAlias();
    }

    private int getNodeId() {
        return this.m_nodeId;
    }

    public int getIndex() {
        return this.m_ifIndex;
    }

    public int getType() {
        return this.m_ifType;
    }

    public String getLabel() {
        return this.m_label;
    }

    public void setIfAlias(String ifAlias) {
        this.m_ifAlias = ifAlias;
    }

    String getCurrentIfAlias() {
        return this.m_ifAlias;
    }

    public boolean isCollectionEnabled() {
        return this.m_collectionEnabled;
    }

    public void setEntry(SNMPCollectorEntry ifEntry) {
        this.m_entry = ifEntry;
    }

    protected SNMPCollectorEntry getEntry() {
        return this.m_entry;
    }

    String getNewIfAlias() {
        if (this.getEntry() == null) {
            return this.getCurrentIfAlias();
        }
        return this.getEntry().getValueForBase(".1.3.6.1.2.1.31.1.1.1.18");
    }

    boolean currentAliasIsOutOfDate(String ifAlias) {
        this.log().debug((Object)("currentAliasIsOutOfDate: ifAlias from collection = " + ifAlias + ", current ifAlias = " + this.getCurrentIfAlias()));
        return ifAlias != null && !ifAlias.equals(this.getCurrentIfAlias());
    }

    void logAlias(String ifAlias) {
        Category log = this.log();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Alias for RRD directory name = " + ifAlias));
        }
    }

    String getAliasDir(String ifAlias, String ifAliasComment) {
        if (ifAlias != null) {
            int si;
            if (ifAliasComment != null && (si = ifAlias.indexOf(ifAliasComment)) > -1) {
                ifAlias = ifAlias.substring(0, si).trim();
            }
            if (ifAlias != null) {
                ifAlias = AlphaNumeric.parseAndReplaceExcept((String)ifAlias, (char)'_', (String)"-._");
            }
        }
        this.logAlias(ifAlias);
        return ifAlias;
    }

    void logForceRescan(String ifAlias) {
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("Forcing rescan.  IfAlias " + ifAlias + " for index " + this.getIndex() + " does not match DB value: " + this.getCurrentIfAlias()));
        }
    }

    boolean isScheduledForCollection() {
        this.log().debug((Object)(this + ".collectionEnabled = " + this.isCollectionEnabled()));
        this.log().debug((Object)("selectCollectionOnly = " + this.getCollection().isSelectCollectionOnly()));
        boolean isScheduled = this.isCollectionEnabled() || !this.getCollection().isSelectCollectionOnly();
        this.log().debug((Object)("isScheduled = " + isScheduled));
        return isScheduled;
    }

    private OnmsSnmpCollection getCollection() {
        return this.getResourceType().getCollection();
    }

    public File getResourceDir(RrdRepository repository) {
        File rrdBaseDir = repository.getRrdBaseDir();
        File nodeDir = new File(rrdBaseDir, String.valueOf(this.getNodeId()));
        File ifDir = new File(nodeDir, this.getLabel());
        return ifDir;
    }

    public String toString() {
        return "node[" + this.getNodeId() + "].interfaceSnmp[" + this.getLabel() + ']';
    }

    boolean shouldStore(ServiceParameters serviceParameters) {
        if (serviceParameters.getStoreByNodeID().equals("normal")) {
            return this.isScheduledForCollection();
        }
        return serviceParameters.getStoreByNodeID().equals("true");
    }

    public boolean shouldPersist(ServiceParameters serviceParameters) {
        boolean shdprsist = this.shouldStore(serviceParameters) && (this.isScheduledForCollection() || serviceParameters.forceStoreByAlias(this.getCurrentIfAlias()));
        this.log().debug((Object)("shouldPersist = " + shdprsist));
        return shdprsist;
    }

    public String getResourceTypeName() {
        return "if";
    }

    public String getInstance() {
        return Integer.toString(this.getIndex());
    }
}

