/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.net.InetAddress;
import java.util.Map;
import net.sourceforge.jradiusclient.RadiusAttribute;
import net.sourceforge.jradiusclient.RadiusClient;
import net.sourceforge.jradiusclient.RadiusPacket;
import net.sourceforge.jradiusclient.exception.InvalidParameterException;
import net.sourceforge.jradiusclient.exception.RadiusException;
import net.sourceforge.jradiusclient.util.ChapUtil;
import org.apache.log4j.Logger;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.AbstractPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RadiusAuthPlugin
extends AbstractPlugin {
    private static final String PROTOCOL_NAME = "RadiusAuth";
    public static final int DEFAULT_TIMEOUT = 5000;
    public static final int DEFAULT_RETRY = 0;
    public static final int DEFAULT_AUTH_PORT = 1812;
    public static final int DEFAULT_ACCT_PORT = 1813;
    public static final String DEFAULT_AUTH_TYPE = "pap";
    public static final String DEFAULT_USER = "OpenNMS";
    public static final String DEFAULT_PASSWORD = "OpenNMS";
    public static final String DEFAULT_SECRET = "secret";
    public static final String DEFAULT_NAS_ID = "opennms";

    private boolean isRadius(InetAddress host, int authport, int acctport, String authType, String user, String password, String secret, String nasid, int retry, int timeout) {
        boolean isRadiusServer = false;
        Logger log = ThreadCategory.getInstance(this.getClass());
        RadiusClient rc = null;
        try {
            rc = new RadiusClient(host.getCanonicalHostName(), authport, acctport, secret, timeout);
        }
        catch (RadiusException rex) {
            log.info((Object)(this.getClass().getName() + ": Radius Exception: " + rex.getMessage()));
            return isRadiusServer;
        }
        catch (InvalidParameterException ivpex) {
            log.error((Object)(this.getClass().getName() + ": Radius parameter exception: " + ivpex.getMessage()));
            return isRadiusServer;
        }
        for (int attempts = 0; attempts <= retry; ++attempts) {
            try {
                ChapUtil chapUtil = new ChapUtil();
                RadiusPacket accessRequest = new RadiusPacket(1);
                RadiusAttribute nasIdAttribute = new RadiusAttribute(32, nasid.getBytes());
                RadiusAttribute userNameAttribute = new RadiusAttribute(1, user.getBytes());
                accessRequest.setAttribute(userNameAttribute);
                accessRequest.setAttribute(nasIdAttribute);
                if (authType.equalsIgnoreCase("chap")) {
                    byte[] chapChallenge = chapUtil.getNextChapChallenge(16);
                    accessRequest.setAttribute(new RadiusAttribute(3, RadiusAuthPlugin.chapEncrypt(password, chapChallenge, chapUtil)));
                    accessRequest.setAttribute(new RadiusAttribute(60, chapChallenge));
                } else {
                    accessRequest.setAttribute(new RadiusAttribute(2, password.getBytes()));
                }
                RadiusPacket accessResponse = rc.authenticate(accessRequest);
                if (!(accessResponse.getPacketType() == 2 | accessResponse.getPacketType() == 11 | accessResponse.getPacketType() == 3)) continue;
                isRadiusServer = true;
                if (!log.isDebugEnabled()) break;
                log.debug((Object)(this.getClass().getName() + ": Discovered Radius service on: " + host.getCanonicalHostName()));
                break;
            }
            catch (InvalidParameterException ivpex) {
                log.error((Object)(this.getClass().getName() + ": Invalid Radius Parameter: " + (Object)((Object)ivpex)));
                continue;
            }
            catch (RadiusException radex) {
                log.info((Object)(this.getClass().getName() + ": Radius Exception : " + (Object)((Object)radex)));
            }
        }
        return isRadiusServer;
    }

    @Override
    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    @Override
    public boolean isProtocolSupported(InetAddress address) {
        return this.isRadius(address, 1812, 1813, DEFAULT_AUTH_TYPE, "OpenNMS", "OpenNMS", DEFAULT_SECRET, DEFAULT_NAS_ID, 0, 5000);
    }

    @Override
    public boolean isProtocolSupported(InetAddress address, Map<String, Object> qualifiers) {
        int authport = 1812;
        int acctport = 1813;
        String authType = DEFAULT_AUTH_TYPE;
        int timeout = 5000;
        int retry = 0;
        String user = "OpenNMS";
        String password = "OpenNMS";
        String secret = DEFAULT_SECRET;
        String nasid = DEFAULT_NAS_ID;
        if (qualifiers != null) {
            authport = ParameterMap.getKeyedInteger(qualifiers, (String)"authport", (int)1812);
            acctport = ParameterMap.getKeyedInteger(qualifiers, (String)"acctport", (int)1813);
            authType = ParameterMap.getKeyedString(qualifiers, (String)"authtype", (String)DEFAULT_AUTH_TYPE);
            timeout = ParameterMap.getKeyedInteger(qualifiers, (String)"timeout", (int)5000);
            retry = ParameterMap.getKeyedInteger(qualifiers, (String)"retry", (int)0);
            user = ParameterMap.getKeyedString(qualifiers, (String)"user", (String)"OpenNMS");
            password = ParameterMap.getKeyedString(qualifiers, (String)"password", (String)"OpenNMS");
            secret = ParameterMap.getKeyedString(qualifiers, (String)DEFAULT_SECRET, (String)DEFAULT_SECRET);
            nasid = ParameterMap.getKeyedString(qualifiers, (String)"nasid", (String)DEFAULT_NAS_ID);
        }
        return this.isRadius(address, authport, acctport, authType, user, password, secret, nasid, retry, timeout);
    }

    private static byte[] chapEncrypt(String plainText, byte[] chapChallenge, ChapUtil chapUtil) {
        byte chapIdentifier = chapUtil.getNextChapIdentifier();
        byte[] chapPassword = new byte[17];
        chapPassword[0] = chapIdentifier;
        System.arraycopy(ChapUtil.chapEncrypt((byte)chapIdentifier, (byte[])plainText.getBytes(), (byte[])chapChallenge), 0, chapPassword, 1, 16);
        return chapPassword;
    }
}

