/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.security.SecureRandom;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.AbstractPlugin;
import org.opennms.netmgt.poller.nrpe.NrpePacket;
import org.opennms.netmgt.utils.RelaxedX509TrustManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NrpePlugin
extends AbstractPlugin {
    private static final String PROTOCOL_NAME = "NRPE";
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 5000;
    private static final boolean DEFAULT_USE_SSL = true;
    private static final String[] ADH_CIPHER_SUITES = new String[]{"TLS_DH_anon_WITH_AES_128_CBC_SHA"};
    private boolean m_useSsl = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isServer(InetAddress host, int port, String command, int padding, int retries, int timeout, RE regex, StringBuffer bannerResult) {
        Logger log = ThreadCategory.getInstance(this.getClass());
        boolean isAServer = false;
        for (int attempts = 0; attempts <= retries && !isAServer; ++attempts) {
            Socket socket = null;
            try {
                socket = new Socket();
                socket.connect(new InetSocketAddress(host, port), timeout);
                socket = this.wrapSocket(socket, host.toString(), port);
                socket.setSoTimeout(timeout);
                log.debug((Object)("NrpePlugin: connected to host: " + host + " on port: " + port));
                NrpePacket p = new NrpePacket(1, 0, command);
                byte[] b = p.buildPacket(padding);
                OutputStream o = socket.getOutputStream();
                o.write(b);
                NrpePacket response = NrpePacket.receivePacket(socket.getInputStream(), padding);
                if (response.getResultCode() == 0) {
                    isAServer = true;
                    continue;
                }
                log.info((Object)("recieved a non-zero return result code, " + response.getResultCode() + ", with message: " + response.getBuffer()));
                isAServer = false;
                break;
            }
            catch (ConnectException e) {
                log.debug((Object)("NrpePlugin: Connection refused to " + host.getHostAddress() + ":" + port));
                isAServer = false;
                continue;
            }
            catch (NoRouteToHostException e) {
                e.fillInStackTrace();
                log.info((Object)("NrpePlugin: Could not connect to host " + host.getHostAddress() + ", no route to host"), (Throwable)e);
                isAServer = false;
                throw new UndeclaredThrowableException(e);
            }
            catch (InterruptedIOException e) {
                log.debug((Object)("NrpePlugin: did not connect to host within timeout: " + timeout + " attempt: " + attempts));
                isAServer = false;
                continue;
            }
            catch (IOException e) {
                log.info((Object)("NrpePlugin: An expected I/O exception occured connecting to host " + host.getHostAddress() + " on port " + port), (Throwable)e);
                isAServer = false;
                continue;
            }
            catch (Throwable t) {
                isAServer = false;
                log.warn((Object)("NrpePlugin: An undeclared throwable exception was caught connecting to host " + host.getHostAddress() + " on port " + port), t);
                continue;
            }
            finally {
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        return isAServer;
    }

    @Override
    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    @Override
    public boolean isProtocolSupported(InetAddress address) {
        throw new UnsupportedOperationException("Undirected TCP checking not supported");
    }

    @Override
    public boolean isProtocolSupported(InetAddress address, Map<String, Object> qualifiers) {
        int retries = 0;
        int timeout = 5000;
        int port = -1;
        int padding = -1;
        String banner = null;
        String match = null;
        String command = null;
        if (qualifiers != null) {
            command = ParameterMap.getKeyedString(qualifiers, (String)"command", (String)"_NRPE_CHECK");
            port = ParameterMap.getKeyedInteger(qualifiers, (String)"port", (int)5666);
            padding = ParameterMap.getKeyedInteger(qualifiers, (String)"padding", (int)2);
            retries = ParameterMap.getKeyedInteger(qualifiers, (String)"retry", (int)0);
            timeout = ParameterMap.getKeyedInteger(qualifiers, (String)"timeout", (int)5000);
            banner = ParameterMap.getKeyedString(qualifiers, (String)"banner", null);
            match = ParameterMap.getKeyedString(qualifiers, (String)"match", null);
            this.m_useSsl = ParameterMap.getKeyedBoolean(qualifiers, (String)"usessl", (boolean)true);
        }
        try {
            StringBuffer bannerResult = null;
            RE regex = null;
            if (match == null && (banner == null || banner.equals("*"))) {
                regex = null;
            } else if (match != null) {
                regex = new RE(match);
                bannerResult = new StringBuffer();
            } else if (banner != null) {
                regex = new RE(banner);
                bannerResult = new StringBuffer();
            }
            boolean result = this.isServer(address, port, command, padding, retries, timeout, regex, bannerResult);
            if (result && qualifiers != null && bannerResult != null && bannerResult.length() > 0) {
                qualifiers.put("banner", bannerResult.toString());
            }
            return result;
        }
        catch (RESyntaxException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    protected Socket wrapSocket(Socket socket, String hostAddress, int hostPort) throws Exception {
        if (!this.m_useSsl) {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)"Parameter 'usessl' is unset or false, not using SSL");
            }
            return socket;
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)"Parameter 'usessl' is true, using SSL");
        }
        SSLSocketFactory sslSF = null;
        TrustManager[] tm = new TrustManager[]{new RelaxedX509TrustManager()};
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, tm, new SecureRandom());
        sslSF = sslContext.getSocketFactory();
        Socket wrappedSocket = sslSF.createSocket(socket, hostAddress, hostPort, true);
        SSLSocket sslSocket = (SSLSocket)wrappedSocket;
        sslSocket.setEnabledCipherSuites(ADH_CIPHER_SUITES);
        return wrappedSocket;
    }

    protected Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

