/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPSocketFactory;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Map;
import org.apache.log4j.Logger;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.AbstractPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LdapPlugin
extends AbstractPlugin {
    private static final String PROTOCOL_NAME = "LDAP";
    private static final int[] DEFAULT_PORTS = new int[]{389};
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 5000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean isServer(InetAddress host, int port, int retries, int timeout) {
        boolean isAServer;
        block28: {
            Logger log = ThreadCategory.getInstance(this.getClass());
            isAServer = false;
            Socket socket = null;
            socket = new Socket();
            socket.connect(new InetSocketAddress(host, port), timeout);
            socket.setSoTimeout(timeout);
            log.debug((Object)"LDAPPlugin.isServer: connect successful");
            for (int attempts = 0; attempts <= retries && !isAServer; ++attempts) {
                log.debug((Object)("LDAPPlugin.isServer: attempt " + attempts + " to connect host " + host.getHostAddress()));
                LDAPConnection lc = null;
                lc = new LDAPConnection((LDAPSocketFactory)new TimeoutLDAPSocket(timeout));
                lc.connect(host.getHostAddress(), port);
                isAServer = true;
                Object var12_15 = null;
                try {
                    if (lc == null) continue;
                    lc.disconnect();
                }
                catch (LDAPException e2) {}
                continue;
                {
                    catch (LDAPException e) {
                        isAServer = false;
                        var12_15 = null;
                        try {
                            if (lc == null) continue;
                            lc.disconnect();
                        }
                        catch (LDAPException e2) {}
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var12_15 = null;
                    try {
                        if (lc != null) {
                            lc.disconnect();
                        }
                    }
                    catch (LDAPException e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            Object var15_18 = null;
            try {
                if (socket != null) {
                    socket.close();
                }
                break block28;
            }
            catch (IOException e3) {}
            break block28;
            {
                catch (ConnectException e) {
                    log.debug((Object)(this.getClass().getName() + ": connection refused to " + host.getHostAddress() + ":" + port));
                    Object var15_19 = null;
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                        break block28;
                    }
                    catch (IOException e3) {}
                    break block28;
                }
                catch (NoRouteToHostException e) {
                    e.fillInStackTrace();
                    log.info((Object)(this.getClass().getName() + ": No route to host " + host.getHostAddress()), (Throwable)e);
                    throw new UndeclaredThrowableException(e);
                }
                catch (InterruptedIOException e) {
                    log.debug((Object)"LDAPPlugin: failed to connect within specified timeout");
                    Object var15_20 = null;
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                        break block28;
                    }
                    catch (IOException e3) {}
                    break block28;
                }
                catch (Throwable t) {
                    log.warn((Object)(this.getClass().getName() + ": An undeclared throwable exception caught contacting host " + host.getHostAddress()), t);
                    Object var15_21 = null;
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                        break block28;
                    }
                    catch (IOException e3) {}
                }
            }
            catch (Throwable throwable) {
                Object var15_22 = null;
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException e3) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return isAServer;
    }

    @Override
    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    @Override
    public boolean isProtocolSupported(InetAddress address) {
        for (int i = 0; i < DEFAULT_PORTS.length; ++i) {
            if (!this.isServer(address, DEFAULT_PORTS[i], 0, 5000)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isProtocolSupported(InetAddress address, Map<String, Object> qualifiers) {
        int retries = ParameterMap.getKeyedInteger(qualifiers, (String)"retry", (int)0);
        int timeout = ParameterMap.getKeyedInteger(qualifiers, (String)"timeout", (int)5000);
        int[] ports = ParameterMap.getKeyedIntegerArray(qualifiers, (String)"port", (int[])DEFAULT_PORTS);
        for (int i = 0; i < ports.length; ++i) {
            if (!this.isServer(address, ports[i], retries, timeout)) continue;
            qualifiers.put("port", new Integer(ports[i]));
            return true;
        }
        return false;
    }

    private class TimeoutLDAPSocket
    implements LDAPSocketFactory {
        private int m_timeout;

        public TimeoutLDAPSocket(int timeout) {
            this.m_timeout = timeout;
        }

        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            Socket socket = new Socket(host, port);
            socket.setSoTimeout(this.m_timeout);
            return socket;
        }
    }
}

