/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.apache.log4j.Logger;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.plugins.JDBCPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JDBCStoredProcedurePlugin
extends JDBCPlugin {
    private static final String DEFAULT_STORED_PROCEDURE = "isRunning";

    public JDBCStoredProcedurePlugin() {
        Logger log = ThreadCategory.getInstance(this.getClass());
        log.info((Object)(this.getClass().getName() + ": JDBCStoredProcedurePlugin class loaded"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean checkStatus(Connection con, Map<String, Object> qualifiers) {
        boolean status = false;
        CallableStatement cs = null;
        try {
            try {
                String storedProcedure = ParameterMap.getKeyedString(qualifiers, (String)"stored-procedure", (String)DEFAULT_STORED_PROCEDURE);
                String procedureCall = "{ ? = call test." + storedProcedure + "()}";
                cs = con.prepareCall(procedureCall);
                this.log().debug((Object)("Calling stored procedure: " + procedureCall));
                cs.registerOutParameter(1, -7);
                cs.executeUpdate();
                status = cs.getBoolean(1);
                this.log().debug((Object)("Stored procedure returned: " + status));
            }
            catch (SQLException sqlEx) {
                this.log().debug((Object)(this.getClass().getName() + ": JDBC stored procedure call not functional: " + sqlEx.getSQLState() + ", " + sqlEx.toString()));
                sqlEx.printStackTrace();
                Object var8_9 = null;
                this.closeStmt(cs);
                return status;
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.closeStmt(cs);
            throw throwable;
        }
        this.closeStmt(cs);
        return status;
    }
}

