/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.net.InetAddress;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Category;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.DBTools;
import org.opennms.netmgt.capsd.AbstractPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCPlugin
extends AbstractPlugin {
    private static final String PROTOCOL_NAME = "JDBC";
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 5000;

    public JDBCPlugin() {
        this.log().info((Object)"JDBCPlugin class loaded");
    }

    protected Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isServer(String hostname, Map<String, Object> qualifiers) {
        String user = ParameterMap.getKeyedString(qualifiers, (String)"user", (String)"sa");
        String password = ParameterMap.getKeyedString(qualifiers, (String)"password", (String)"");
        String db_url = ParameterMap.getKeyedString(qualifiers, (String)"url", (String)"jdbc:sybase:Tds:OPENNMS_JDBC_HOSTNAME/tempdb");
        int timeout = ParameterMap.getKeyedInteger(qualifiers, (String)"timeout", (int)5000);
        int retries = ParameterMap.getKeyedInteger(qualifiers, (String)"retry", (int)0);
        String db_driver = ParameterMap.getKeyedString(qualifiers, (String)"driver", (String)"com.sybase.jdbc2.jdbc.SybDriver");
        boolean status = false;
        Connection con = null;
        Statement statement = null;
        boolean connected = false;
        int attempts = 0;
        while (attempts <= retries && !connected) {
            Object var18_18;
            this.log().info((Object)("Trying to detect JDBC server on '" + hostname + "', attempts #: " + attempts));
            try {
                block5: {
                    try {
                        this.log().debug((Object)("Loading JDBC driver: '" + db_driver + "'"));
                        Driver driver = (Driver)Class.forName(db_driver).newInstance();
                        this.log().debug((Object)("JDBC driver loaded: '" + db_driver + "'"));
                        String url = DBTools.constructUrl(db_url, hostname);
                        this.log().debug((Object)("Constructed JDBC url: '" + url + "'"));
                        Properties props = new Properties();
                        props.setProperty("user", user);
                        props.setProperty("password", password);
                        props.setProperty("timeout", String.valueOf(timeout / 1000));
                        con = driver.connect(url, props);
                        connected = true;
                        this.log().debug((Object)("Got database connection: '" + con + "' (" + url + ", " + user + ", " + password + ")"));
                        status = this.checkStatus(con, qualifiers);
                        if (!status) break block5;
                        this.log().info((Object)("JDBC server detected on: '" + hostname + "', attempts #:" + attempts));
                    }
                    catch (Exception e) {
                        this.log().info((Object)e);
                        e.printStackTrace();
                        var18_18 = null;
                        ++attempts;
                        this.closeStmt(statement);
                        this.closeConn(con);
                        continue;
                    }
                }
                var18_18 = null;
                ++attempts;
                this.closeStmt(statement);
                this.closeConn(con);
            }
            catch (Throwable throwable) {
                var18_18 = null;
                ++attempts;
                this.closeStmt(statement);
                this.closeConn(con);
                throw throwable;
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkStatus(Connection con, Map<String, Object> qualifiers) {
        boolean status = false;
        ResultSet result = null;
        try {
            block5: {
                try {
                    DatabaseMetaData metadata = con.getMetaData();
                    this.log().debug((Object)"Got database metadata");
                    result = metadata.getCatalogs();
                    while (result.next()) {
                        result.getString(1);
                        this.log().debug((Object)("Metadata catalog: '" + result.getString(1) + "'"));
                    }
                    if (result == null) break block5;
                    status = true;
                }
                catch (SQLException sqlException) {
                    this.log().warn((Object)sqlException.toString());
                    Object var7_8 = null;
                    this.closeResult(result);
                }
            }
            Object var7_7 = null;
            this.closeResult(result);
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.closeResult(result);
            throw throwable;
        }
        return status;
    }

    private void closeConn(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected void closeStmt(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void closeResult(ResultSet result) {
        if (result != null) {
            try {
                result.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    @Override
    public boolean isProtocolSupported(InetAddress address) {
        boolean status = false;
        try {
            status = this.isServer(address.getCanonicalHostName(), new HashMap<String, Object>());
        }
        catch (Exception exp) {
            this.log().error((Object)exp);
        }
        return status;
    }

    @Override
    public boolean isProtocolSupported(InetAddress address, Map<String, Object> qualifiers) {
        boolean status = false;
        if (address == null) {
            throw new NullPointerException(this.getClass().getName() + ": Internet address cannot be null");
        }
        if (qualifiers == null) {
            throw new NullPointerException(this.getClass().getName() + ": Map argument cannot be null");
        }
        try {
            status = this.isServer(address.getCanonicalHostName(), qualifiers);
        }
        catch (Exception exp) {
            this.log().error((Object)exp);
        }
        return status;
    }
}

