/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.AbstractTcpPlugin;
import org.opennms.netmgt.capsd.ConnectionConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpPlugin
extends AbstractTcpPlugin {
    protected static final String PROPERTY_NAME_PORT = "port";
    protected static final String PROPERTY_NAME_MAX_RET_CODE = "max-ret-code";
    protected static final String PROPERTY_NAME_RETURN_CODE = "check-return-code";
    protected static final String PROPERTY_NAME_URL = "url";
    protected static final String PROPERTY_NAME_RESPONSE_TEXT = "response-text";
    public static final boolean CHECK_RETURN_CODE = true;
    private static final int[] DEFAULT_PORTS = new int[]{80, 8080, 8888};
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 5000;
    public static final String PROTOCOL_NAME = "HTTP";
    public static final String QUERY_STRING = "GET / HTTP/1.0\r\n\r\n";
    public static final String DEFAULT_URL = "/";
    public static final String RESPONSE_STRING = "HTTP/";
    private boolean m_checkReturnCode = true;
    private int[] m_defaultPorts;
    private String m_queryString = "GET / HTTP/1.0\r\n\r\n";
    private String m_responseString = "HTTP/";

    public HttpPlugin() {
        this(PROTOCOL_NAME, true, QUERY_STRING, RESPONSE_STRING, DEFAULT_PORTS);
    }

    protected HttpPlugin(String protocolName, boolean checkReturnCode, String queryString, String responseString) {
        this(protocolName, checkReturnCode, queryString, responseString, DEFAULT_PORTS);
    }

    protected HttpPlugin(String protocolName, boolean checkReturnCode, String queryString, String responseString, int[] defaultPorts) {
        super(protocolName, 5000, 0);
        this.m_checkReturnCode = checkReturnCode;
        this.m_queryString = queryString;
        this.m_responseString = responseString;
        this.m_defaultPorts = defaultPorts;
    }

    @Override
    protected boolean checkProtocol(Socket socket, ConnectionConfig config) throws IOException {
        boolean isAServer = false;
        this.m_queryString = "GET " + config.getKeyedString(PROPERTY_NAME_URL, DEFAULT_URL) + " HTTP/1.0\r\n\r\n";
        Logger log = ThreadCategory.getInstance(this.getClass());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Query: " + this.m_queryString));
        }
        try {
            StringBuffer response;
            block16: {
                BufferedReader lineRdr = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                socket.getOutputStream().write(this.m_queryString.getBytes());
                char[] cbuf = new char[1024];
                int chars = 0;
                response = new StringBuffer();
                try {
                    while ((chars = lineRdr.read(cbuf, 0, 1024)) != -1) {
                        String line = new String(cbuf, 0, chars);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Read: " + line.length() + " bytes: [" + line.toString() + "] from socket."));
                        }
                        response.append(line);
                    }
                }
                catch (SocketTimeoutException timeoutEx) {
                    if (timeoutEx.bytesTransferred <= 0) break block16;
                    String line = new String(cbuf, 0, timeoutEx.bytesTransferred);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Read: " + line.length() + " bytes: [" + line.toString() + "] from socket @ timeout!"));
                    }
                    response.append(line);
                }
            }
            if (response.toString() != null && response.toString().indexOf(this.m_responseString) > -1) {
                if (this.m_checkReturnCode) {
                    int maxRetCode = config.getKeyedInteger(PROPERTY_NAME_MAX_RET_CODE, 399);
                    if (DEFAULT_URL.equals(config.getKeyedString(PROPERTY_NAME_URL, DEFAULT_URL)) || !config.getKeyedBoolean(PROPERTY_NAME_RETURN_CODE, true)) {
                        maxRetCode = 600;
                    }
                    StringTokenizer t = new StringTokenizer(response.toString());
                    t.nextToken();
                    int rVal = Integer.parseInt(t.nextToken());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(this.getPluginName() + ": Request returned code: " + rVal));
                    }
                    if (rVal >= 99 && rVal <= maxRetCode) {
                        isAServer = true;
                    }
                } else {
                    isAServer = true;
                }
                if (isAServer) {
                    isAServer = this.checkResponseBody(config, response.toString());
                }
            }
        }
        catch (SocketException e) {
            log.debug((Object)(this.getPluginName() + ": a protocol error occurred talking to host " + config.getInetAddress().getHostAddress()), (Throwable)e);
            isAServer = false;
        }
        catch (NumberFormatException e) {
            log.debug((Object)(this.getPluginName() + ": failed to parse response code from host " + config.getInetAddress().getHostAddress()), (Throwable)e);
            isAServer = false;
        }
        return isAServer;
    }

    @Override
    protected List<ConnectionConfig> getConnectionConfigList(Map<String, Object> qualifiers, InetAddress address) {
        int[] ports = this.getKeyedIntegerArray(qualifiers, PROPERTY_NAME_PORT, this.m_defaultPorts);
        LinkedList<ConnectionConfig> list = new LinkedList<ConnectionConfig>();
        for (int i = 0; i < ports.length; ++i) {
            list.add(this.createConnectionConfig(address, ports[i]));
        }
        return list;
    }

    protected boolean checkResponseBody(ConnectionConfig config, String response) {
        String expectedResponse = config.getKeyedString(PROPERTY_NAME_RESPONSE_TEXT, null);
        if (expectedResponse == null) {
            return true;
        }
        if (expectedResponse.startsWith("~")) {
            Pattern bodyPat = Pattern.compile(expectedResponse.substring(1), 32);
            return bodyPat.matcher(response).matches();
        }
        return response.contains(expectedResponse);
    }
}

