/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.net.InetAddress;
import java.util.Map;
import org.apache.log4j.Category;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.AbstractPlugin;
import org.opennms.netmgt.capsd.plugins.Win32ServicePlugin;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostResourceSwRunPlugin
extends AbstractPlugin {
    private static final String PROTOCOL_NAME = "HOST-RESOURCES";
    private static final String HOSTRESOURCE_SW_NAME_OID = ".1.3.6.1.2.1.25.4.2.1.2";
    static final String SNMP_AGENTCONFIG_KEY = "org.opennms.netmgt.snmp.SnmpAgentConfig";

    @Override
    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    @Override
    public boolean isProtocolSupported(InetAddress address) {
        return this.isProtocolSupported(address, null);
    }

    @Override
    public boolean isProtocolSupported(InetAddress ipaddr, Map<String, Object> parameters) {
        boolean status = false;
        SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(ipaddr);
        if (agentConfig == null) {
            throw new RuntimeException("SnmpAgentConfig object not available for interface " + ipaddr);
        }
        String serviceNameOid = ParameterMap.getKeyedString(parameters, (String)"service-name-oid", (String)HOSTRESOURCE_SW_NAME_OID);
        String serviceName = ParameterMap.getKeyedString(parameters, (String)"service-name", null);
        agentConfig.setTimeout(ParameterMap.getKeyedInteger(parameters, (String)"timeout", (int)agentConfig.getTimeout()));
        agentConfig.setRetries(ParameterMap.getKeyedInteger(parameters, (String)"retry", (int)ParameterMap.getKeyedInteger(parameters, (String)"retries", (int)agentConfig.getRetries())));
        agentConfig.setPort(ParameterMap.getKeyedInteger(parameters, (String)"port", (int)agentConfig.getPort()));
        if (HostResourceSwRunPlugin.log().isDebugEnabled()) {
            HostResourceSwRunPlugin.log().debug((Object)("capsd: service= SNMP address= " + agentConfig));
        }
        try {
            if (HostResourceSwRunPlugin.log().isDebugEnabled()) {
                HostResourceSwRunPlugin.log().debug((Object)("HostResourceSwRunMonitor.poll: SnmpAgentConfig address: " + agentConfig));
            }
            if (serviceName == null) {
                HostResourceSwRunPlugin.log().warn((Object)"HostResourceSwRunMonitor.poll: No Service Name Defined! ");
                return status;
            }
            Map nameResults = SnmpUtils.getOidValues((SnmpAgentConfig)agentConfig, (String)"HostResourceSwRunMonitor", (SnmpObjId)SnmpObjId.get((String)serviceNameOid));
            for (SnmpInstId nameInstance : nameResults.keySet()) {
                if (!((SnmpValue)nameResults.get(nameInstance)).toString().equals(serviceName) || status) continue;
                HostResourceSwRunPlugin.log().debug((Object)("poll: HostResourceSwRunMonitor poll succeeded, addr=" + ipaddr.getHostAddress() + " service name=" + serviceName + " value=" + nameResults.get(nameInstance)));
                status = true;
            }
        }
        catch (NumberFormatException e) {
            HostResourceSwRunPlugin.log().warn((Object)("Number operator used on a non-number " + e.getMessage()));
        }
        catch (IllegalArgumentException e) {
            HostResourceSwRunPlugin.log().warn((Object)("Invalid Snmp Criteria: " + e.getMessage()));
        }
        catch (Throwable t) {
            HostResourceSwRunPlugin.log().warn((Object)("Unexpected exception during SNMP poll of interface " + ipaddr.getHostAddress()), t);
        }
        return status;
    }

    public static Category log() {
        return ThreadCategory.getInstance(Win32ServicePlugin.class);
    }
}

