/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Map;
import org.apache.log4j.Logger;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.AbstractPlugin;
import org.opennms.protocols.dns.DNSAddressRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DnsPlugin
extends AbstractPlugin {
    private static final String PROTOCOL_NAME = "DNS";
    private static final int DEFAULT_PORT = 53;
    private static final int DEFAULT_RETRY = 3;
    private static final int DEFAULT_TIMEOUT = 3000;
    private static final String DEFAULT_LOOKUP = "localhost";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isServer(InetAddress nserver, int port, int retries, int timeout, String lookup) {
        boolean isAServer = false;
        Logger log = ThreadCategory.getInstance(this.getClass());
        DatagramSocket socket = null;
        try {
            try {
                socket = new DatagramSocket();
                socket.setSoTimeout(timeout);
                byte[] data = new byte[512];
                for (int count = 0; count < retries && !isAServer; ++count) {
                    try {
                        DNSAddressRequest request = new DNSAddressRequest(lookup);
                        byte[] rdata = request.buildRequest();
                        DatagramPacket outpkt = new DatagramPacket(rdata, rdata.length, nserver, port);
                        rdata = null;
                        socket.send(outpkt);
                        DatagramPacket inpkt = new DatagramPacket(data, data.length);
                        socket.receive(inpkt);
                        if (!inpkt.getAddress().equals(nserver)) continue;
                        try {
                            request.verifyResponse(inpkt.getData(), inpkt.getLength());
                            isAServer = true;
                        }
                        catch (IOException ex) {
                            log.debug((Object)"Failed to match response to request, an IOException occured", (Throwable)ex);
                        }
                        continue;
                    }
                    catch (InterruptedIOException ex) {
                        // empty catch block
                    }
                }
                Object var17_18 = null;
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException ex) {
                log.warn((Object)"isServer: An I/O exception during DNS resolution test.", (Throwable)ex);
                Object var17_19 = null;
                if (socket != null) {
                    socket.close();
                }
            }
        }
        catch (Throwable throwable) {
            Object var17_20 = null;
            if (socket != null) {
                socket.close();
            }
            throw throwable;
        }
        return isAServer;
    }

    @Override
    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    @Override
    public boolean isProtocolSupported(InetAddress address) {
        return this.isServer(address, 53, 3, 3000, DEFAULT_LOOKUP);
    }

    @Override
    public boolean isProtocolSupported(InetAddress address, Map<String, Object> qualifiers) {
        boolean result;
        int port = 53;
        int timeout = 3000;
        int retries = 3;
        String lookup = DEFAULT_LOOKUP;
        if (qualifiers != null) {
            port = ParameterMap.getKeyedInteger(qualifiers, (String)"port", (int)53);
            timeout = ParameterMap.getKeyedInteger(qualifiers, (String)"timeout", (int)3000);
            retries = ParameterMap.getKeyedInteger(qualifiers, (String)"retry", (int)ParameterMap.getKeyedInteger(qualifiers, (String)"retries", (int)3));
            lookup = ParameterMap.getKeyedString(qualifiers, (String)"lookup", (String)DEFAULT_LOOKUP);
        }
        if ((result = this.isServer(address, port, retries, timeout, lookup)) && qualifiers != null && !qualifiers.containsKey("port")) {
            qualifiers.put("port", new Integer(port));
        }
        return result;
    }
}

