/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.net.InetAddress;
import java.util.Map;
import org.apache.log4j.Category;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.plugins.SnmpPlugin;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CiscoIpSlaPlugin
extends SnmpPlugin {
    private static final String PROTOCOL_NAME = "Cisco_IP_SLA";
    private static final String RTT_ADMIN_TAG_OID = ".1.3.6.1.4.1.9.9.42.1.2.1.1.3";
    private static final String RTT_OPER_STATE_OID = ".1.3.6.1.4.1.9.9.42.1.2.9.1.10";

    @Override
    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    @Override
    public boolean isProtocolSupported(InetAddress ipaddr, Map<String, Object> parameters) {
        boolean status = false;
        try {
            String adminTag = ParameterMap.getKeyedString(parameters, (String)"admin-tag", null);
            if (adminTag == null) {
                CiscoIpSlaPlugin.log().warn((Object)"poll: No IP-SLA admin-tag defined! ");
                return status;
            }
            SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(ipaddr);
            if (agentConfig == null) {
                throw new RuntimeException("SnmpAgentConfig object not available for interface " + ipaddr);
            }
            if (parameters != null) {
                if (parameters.get("port") != null) {
                    int port = ParameterMap.getKeyedInteger(parameters, (String)"port", (int)agentConfig.getPort());
                    agentConfig.setPort(port);
                }
                if (parameters.get("timeout") != null) {
                    int timeout = ParameterMap.getKeyedInteger(parameters, (String)"timeout", (int)agentConfig.getTimeout());
                    agentConfig.setTimeout(timeout);
                }
                if (parameters.get("retry") != null) {
                    int retry = ParameterMap.getKeyedInteger(parameters, (String)"retry", (int)agentConfig.getRetries());
                    agentConfig.setRetries(retry);
                }
                if (parameters.get("force version") != null) {
                    String version = (String)parameters.get("force version");
                    if (version.equalsIgnoreCase("snmpv1")) {
                        agentConfig.setVersion(1);
                    } else if (version.equalsIgnoreCase("snmpv2") || version.equalsIgnoreCase("snmpv2c")) {
                        agentConfig.setVersion(2);
                    } else if (version.equalsIgnoreCase("snmpv3")) {
                        agentConfig.setVersion(3);
                    }
                }
                if (CiscoIpSlaPlugin.log().isDebugEnabled()) {
                    CiscoIpSlaPlugin.log().debug((Object)("poll: SnmpAgentConfig address: " + agentConfig));
                }
                if (adminTag == null) {
                    CiscoIpSlaPlugin.log().warn((Object)"poll: No admin tag defined! ");
                    return status;
                }
                Map tagResults = SnmpUtils.getOidValues((SnmpAgentConfig)agentConfig, (String)"CiscoIpSlaMonitor", (SnmpObjId)SnmpObjId.get((String)RTT_ADMIN_TAG_OID));
                if (tagResults == null) {
                    CiscoIpSlaPlugin.log().warn((Object)"poll: No admin tags received! ");
                    return status;
                }
                Map operStateResults = SnmpUtils.getOidValues((SnmpAgentConfig)agentConfig, (String)"CiscoIpSlaMonitor", (SnmpObjId)SnmpObjId.get((String)RTT_OPER_STATE_OID));
                if (operStateResults == null) {
                    CiscoIpSlaPlugin.log().warn((Object)"poll: No oper state received! ");
                    return status;
                }
                for (SnmpInstId ipslaInstance : tagResults.keySet()) {
                    CiscoIpSlaPlugin.log().debug((Object)("poll: admin tag=" + adminTag + " value=" + tagResults.get(ipslaInstance) + " oper state=" + operStateResults.get(ipslaInstance)));
                    if (!((SnmpValue)tagResults.get(ipslaInstance)).toString().equals(adminTag) || ((SnmpValue)operStateResults.get(ipslaInstance)).toInt() != RTT_MON_OPER_STATE.ACTIVE.value()) continue;
                    CiscoIpSlaPlugin.log().debug((Object)"poll: admin tag found");
                    status = true;
                }
            }
        }
        catch (NullPointerException e) {
            CiscoIpSlaPlugin.log().warn((Object)"SNMP not available or CISCO-RTT-MON-MIB not supported!");
        }
        catch (NumberFormatException e) {
            CiscoIpSlaPlugin.log().warn((Object)("Number operator used on a non-number " + e.getMessage()));
        }
        catch (IllegalArgumentException e) {
            CiscoIpSlaPlugin.log().warn((Object)("Invalid Snmp Criteria: " + e.getMessage()));
        }
        catch (Throwable t) {
            CiscoIpSlaPlugin.log().warn((Object)("Unexpected exception during SNMP poll of interface " + ipaddr.getHostAddress()), t);
        }
        return status;
    }

    public static Category log() {
        return ThreadCategory.getInstance(CiscoIpSlaPlugin.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum RTT_MON_OPER_STATE {
        RESET(1),
        ORDERLY_STOP(2),
        IMMEDIATE_STOP(3),
        PENDING(4),
        INACTIVE(5),
        ACTIVE(6),
        RESTART(7);

        private final int state;

        private RTT_MON_OPER_STATE(int s) {
            this.state = s;
        }

        private int value() {
            return this.state;
        }
    }
}

