/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd;

import java.net.InetAddress;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.capsd.Capsd;
import org.opennms.netmgt.capsd.DbNodeEntry;
import org.opennms.netmgt.capsd.InsufficientInformationException;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.utils.XmlrpcUtil;
import org.opennms.netmgt.xml.event.Autoaction;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Forward;
import org.opennms.netmgt.xml.event.Operaction;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Script;
import org.opennms.netmgt.xml.event.Snmp;
import org.opennms.netmgt.xml.event.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventUtils {
    public static void addEventListener(EventListener listener, List<String> ueiList) {
        EventIpcManagerFactory.init();
        EventIpcManagerFactory.getIpcManager().addEventListener(listener, ueiList);
    }

    public static void checkEventId(Event e) throws InsufficientInformationException {
        if (e == null) {
            throw new NullPointerException("e is null");
        }
        if (!e.hasDbid()) {
            throw new InsufficientInformationException("eventID is unavailable");
        }
    }

    public static void checkInterface(Event e) throws InsufficientInformationException {
        if (e == null) {
            throw new NullPointerException("e is null");
        }
        if (e.getInterface() == null || e.getInterface().length() == 0) {
            throw new InsufficientInformationException("ipaddr for event is unavailable");
        }
    }

    public static void checkHost(Event e) throws InsufficientInformationException {
        if (e == null) {
            throw new NullPointerException("e is null");
        }
        if (e.getHost() == null || e.getHost().length() == 0) {
            throw new InsufficientInformationException("host for event is unavailable");
        }
    }

    public static void checkNodeId(Event e) throws InsufficientInformationException {
        if (e == null) {
            throw new NullPointerException("e is null");
        }
        if (!e.hasNodeid()) {
            throw new InsufficientInformationException("nodeid for event is unavailable");
        }
    }

    public static void checkService(Event e) throws InsufficientInformationException {
        if (e == null) {
            throw new NullPointerException("e is null");
        }
        if (e.getService() == null || e.getService().length() == 0) {
            throw new InsufficientInformationException("service for event is unavailable");
        }
    }

    public static Event createDeleteInterfaceEvent(String source, long nodeId, String ipAddr, long txNo) {
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/internal/capsd/deleteInterface");
        newEvent.setSource(source);
        newEvent.setInterface(ipAddr);
        newEvent.setNodeid(nodeId);
        newEvent.setTime(EventConstants.formatToString((Date)new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = null;
        Value parmValue = null;
        eventParm = new Parm();
        eventParm.setParmName("txno");
        parmValue = new Value();
        parmValue.setContent(String.valueOf(txNo));
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        newEvent.setParms(eventParms);
        return newEvent;
    }

    public static Event createDeleteNodeEvent(String source, long nodeId, long txNo) {
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/internal/capsd/deleteNode");
        newEvent.setSource(source);
        newEvent.setNodeid(nodeId);
        newEvent.setTime(EventConstants.formatToString((Date)new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = null;
        Value parmValue = null;
        eventParm = new Parm();
        eventParm.setParmName("txno");
        parmValue = new Value();
        parmValue.setContent(String.valueOf(txNo));
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        newEvent.setParms(eventParms);
        return newEvent;
    }

    public static Event createAssetInfoChangedEvent(String source, long nodeId, long txNo) {
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/nodes/assetInfoChanged");
        newEvent.setSource(source);
        newEvent.setNodeid(nodeId);
        newEvent.setTime(EventConstants.formatToString((Date)new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = null;
        Value parmValue = null;
        eventParm = new Parm();
        eventParm.setParmName("txno");
        parmValue = new Value();
        parmValue.setContent(String.valueOf(txNo));
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        newEvent.setParms(eventParms);
        return newEvent;
    }

    public static Event createInterfaceDeletedEvent(String source, long nodeId, String ipAddr, long txNo) {
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/nodes/interfaceDeleted");
        newEvent.setSource(source);
        newEvent.setNodeid(nodeId);
        newEvent.setInterface(ipAddr);
        newEvent.setTime(EventConstants.formatToString((Date)new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = null;
        Value parmValue = null;
        eventParm = new Parm();
        eventParm.setParmName("txno");
        parmValue = new Value();
        parmValue.setContent(String.valueOf(txNo));
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        newEvent.setParms(eventParms);
        return newEvent;
    }

    public static Event createNodeDeletedEvent(String source, long nodeId, long txNo) {
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/nodes/nodeDeleted");
        newEvent.setSource(source);
        newEvent.setNodeid(nodeId);
        newEvent.setTime(EventConstants.formatToString((Date)new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = null;
        Value parmValue = null;
        eventParm = new Parm();
        eventParm.setParmName("txno");
        parmValue = new Value();
        parmValue.setContent(String.valueOf(txNo));
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        newEvent.setParms(eventParms);
        return newEvent;
    }

    public static Event createServiceDeletedEvent(String source, long nodeId, String ipAddr, String service, long txNo) {
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/nodes/serviceDeleted");
        newEvent.setSource(source);
        newEvent.setNodeid(nodeId);
        newEvent.setInterface(ipAddr);
        newEvent.setService(service);
        newEvent.setTime(EventConstants.formatToString((Date)new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = null;
        Value parmValue = null;
        eventParm = new Parm();
        eventParm.setParmName("txno");
        parmValue = new Value();
        parmValue.setContent(String.valueOf(txNo));
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        newEvent.setParms(eventParms);
        return newEvent;
    }

    public static long getEventID(Event e) {
        long eventID = -1L;
        if (e.hasDbid()) {
            eventID = e.getDbid();
        }
        return eventID;
    }

    public static long getLongParm(Event e, String parmName, long defaultValue) {
        return org.opennms.netmgt.model.events.EventUtils.getLongParm((Event)e, (String)parmName, (long)defaultValue);
    }

    public static int getIntParm(Event e, String parmName, int defaultValue) {
        return org.opennms.netmgt.model.events.EventUtils.getIntParm((Event)e, (String)parmName, (int)defaultValue);
    }

    public static int getIntParm(Event e, String parmName) {
        return org.opennms.netmgt.model.events.EventUtils.getIntParm((Event)e, (String)parmName, (int)0);
    }

    public static long getNodeId(Event e) {
        long nodeID = -1L;
        if (e.hasNodeid()) {
            nodeID = e.getNodeid();
        }
        return nodeID;
    }

    public static String getParm(Event e, String parmName) {
        return org.opennms.netmgt.model.events.EventUtils.getParm((Event)e, (String)parmName);
    }

    public static String getParm(Event e, String parmName, String defaultValue) {
        return org.opennms.netmgt.model.events.EventUtils.getParm((Event)e, (String)parmName, (String)defaultValue);
    }

    public static void requireParm(Event e, String parmName) throws InsufficientInformationException {
        Parms parms = e.getParms();
        if (parms == null) {
            throw new InsufficientInformationException("parameter " + parmName + " required but but no parms are available.");
        }
        Enumeration parmEnum = parms.enumerateParm();
        while (parmEnum.hasMoreElements()) {
            Parm parm = (Parm)parmEnum.nextElement();
            if (!parmName.equals(parm.getParmName())) continue;
            if (parm.getValue() != null && parm.getValue().getContent() != null) {
                return;
            }
            throw new InsufficientInformationException("parameter " + parmName + " required but only null valued parms available");
        }
        throw new InsufficientInformationException("parameter " + parmName + " required but was not available");
    }

    public static void sendEvent(Event newEvent, String callerUei, long txNo, boolean isXmlRpcEnabled) {
        block3: {
            Logger log = ThreadCategory.getInstance(EventUtils.class);
            try {
                EventIpcManagerFactory.getIpcManager().sendNow(newEvent);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("sendEvent: successfully sent event " + newEvent));
                }
            }
            catch (Throwable t) {
                log.warn((Object)"run: unexpected throwable exception caught during send to middleware", t);
                if (!isXmlRpcEnabled) break block3;
                int status = 2;
                XmlrpcUtil.createAndSendXmlrpcNotificationEvent(txNo, callerUei, "caught unexpected throwable exception.", status, "OpenNMS.Capsd");
            }
        }
    }

    public static Event createNodeAddedEvent(DbNodeEntry nodeEntry) {
        return EventUtils.createNodeAddedEvent(nodeEntry.getNodeId(), nodeEntry.getLabel(), String.valueOf(nodeEntry.getLabelSource()));
    }

    public static Event createNodeAddedEvent(int nodeId, String nodeLabel, String labelSource) {
        return EventUtils.createNodeAddedEvent("OpenNMS.Capsd", nodeId, nodeLabel, labelSource);
    }

    public static Event createNodeAddedEvent(String source, int nodeId, String nodeLabel, String labelSource) {
        Logger log = ThreadCategory.getInstance(EventUtils.class);
        if (log.isDebugEnabled()) {
            log.debug((Object)("createAndSendNodeAddedEvent:  nodeId  " + nodeId));
        }
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/nodes/nodeAdded");
        newEvent.setSource(source);
        newEvent.setNodeid((long)nodeId);
        newEvent.setHost(Capsd.getLocalHostAddress());
        newEvent.setTime(EventConstants.formatToString((Date)new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = null;
        Value parmValue = null;
        eventParm = new Parm();
        eventParm.setParmName("nodelabel");
        parmValue = new Value();
        parmValue.setContent(nodeLabel);
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("nodelabelsource");
        parmValue = new Value();
        parmValue.setContent(labelSource);
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        newEvent.setParms(eventParms);
        return newEvent;
    }

    public static Event createNodeGainedInterfaceEvent(DbNodeEntry nodeEntry, InetAddress ifaddr) {
        return EventUtils.createNodeGainedInterfaceEvent("OpenNMS.Capsd", nodeEntry.getNodeId(), ifaddr);
    }

    public static Event createNodeGainedInterfaceEvent(String source, int nodeId, InetAddress ifaddr) {
        Logger log = ThreadCategory.getInstance(EventUtils.class);
        if (log.isDebugEnabled()) {
            log.debug((Object)("createAndSendNodeAddedEvent:  nodeId  " + nodeId));
        }
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/nodes/nodeGainedInterface");
        newEvent.setSource(source);
        newEvent.setNodeid((long)nodeId);
        newEvent.setHost(Capsd.getLocalHostAddress());
        newEvent.setInterface(ifaddr.getHostAddress());
        newEvent.setTime(EventConstants.formatToString((Date)new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = null;
        Value parmValue = null;
        eventParm = new Parm();
        eventParm.setParmName("iphostname");
        parmValue = new Value();
        parmValue.setContent(ifaddr.getHostName());
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParms.addParm(eventParm);
        newEvent.setParms(eventParms);
        return newEvent;
    }

    public static Event createNodeDeletedEvent(String source, int nodeId, String hostName, String nodeLabel, long txNo) {
        Logger log = ThreadCategory.getInstance(EventUtils.class);
        if (log.isDebugEnabled()) {
            log.debug((Object)("createAndSendNodeDeletedEvent:  processing deleteNode event for nodeid:  " + nodeId));
        }
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/nodes/nodeDeleted");
        newEvent.setSource(source);
        newEvent.setNodeid((long)nodeId);
        newEvent.setHost(hostName);
        newEvent.setTime(EventConstants.formatToString((Date)new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = null;
        Value parmValue = null;
        eventParm = new Parm();
        eventParm.setParmName("nodelabel");
        parmValue = new Value();
        parmValue.setContent(nodeLabel);
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("txno");
        parmValue = new Value();
        parmValue.setContent(new Long(txNo).toString());
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        if (nodeLabel != null && new Long(txNo).toString() != null) {
            newEvent.setParms(eventParms);
        }
        return newEvent;
    }

    public static Event createAndSendDeleteNodeEvent(String source, String nodeLabel, String hostName, long txNo) {
        Logger log = ThreadCategory.getInstance(EventUtils.class);
        if (log.isDebugEnabled()) {
            log.debug((Object)"createdAndSendDeleteNodeEvent: processing deleteInterface event... ");
        }
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/internal/capsd/deleteNode");
        newEvent.setSource(source);
        newEvent.setHost(hostName);
        newEvent.setTime(EventConstants.formatToString((Date)new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = null;
        Value parmValue = null;
        eventParm = new Parm();
        eventParm.setParmName("nodelabel");
        parmValue = new Value();
        parmValue.setContent(nodeLabel);
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("txno");
        parmValue = new Value();
        parmValue.setContent(new Long(txNo).toString());
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        newEvent.setParms(eventParms);
        return newEvent;
    }

    public static Event createForceRescanEvent(String hostName, long nodeId) {
        Logger log = ThreadCategory.getInstance(EventUtils.class);
        if (log.isDebugEnabled()) {
            log.debug((Object)"createdAndSendForceRescanEvent: processing forceRescan event... ");
        }
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/internal/capsd/forceRescan");
        newEvent.setSource("OpenNMS.Capsd");
        newEvent.setNodeid(nodeId);
        newEvent.setHost(hostName);
        newEvent.setTime(EventConstants.formatToString((Date)new Date()));
        return newEvent;
    }

    public static Event createAndSendInterfaceDeletedEvent(String source, int nodeId, String ipaddr, String hostName, long txNo) {
        Logger log = ThreadCategory.getInstance(EventUtils.class);
        if (log.isDebugEnabled()) {
            log.debug((Object)("createAndSendInterfaceDeletedEvent:  processing deleteInterface event for interface: " + ipaddr + " at nodeid: " + nodeId));
        }
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/nodes/interfaceDeleted");
        newEvent.setSource(source);
        newEvent.setNodeid((long)nodeId);
        newEvent.setInterface(ipaddr);
        newEvent.setHost(hostName);
        newEvent.setTime(EventConstants.formatToString((Date)new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = null;
        Value parmValue = null;
        eventParm = new Parm();
        eventParm.setParmName("txno");
        parmValue = new Value();
        parmValue.setContent(new Long(txNo).toString());
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        newEvent.setParms(eventParms);
        return newEvent;
    }

    public static Event createNodeGainedServiceEvent(DbNodeEntry nodeEntry, InetAddress ifaddr, String service, long txNo) {
        int nodeId = nodeEntry.getNodeId();
        String nodeLabel = nodeEntry.getLabel();
        String labelSource = String.valueOf(nodeEntry.getLabelSource());
        String sysName = nodeEntry.getSystemName();
        String sysDescr = nodeEntry.getSystemDescription();
        return EventUtils.createNodeGainedServiceEvent("OpenNMS.Capsd", nodeId, ifaddr, service, nodeLabel, labelSource, sysName, sysDescr);
    }

    public static Event createNodeGainedServiceEvent(String source, int nodeId, InetAddress ifaddr, String service, String nodeLabel, String labelSource, String sysName, String sysDescr) {
        Logger log = ThreadCategory.getInstance(EventUtils.class);
        if (log.isDebugEnabled()) {
            log.debug((Object)("createAndSendNodeGainedServiceEvent:  nodeId/interface/service  " + nodeId + "/" + ifaddr.getHostAddress() + "/" + service));
        }
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/nodes/nodeGainedService");
        newEvent.setSource(source);
        newEvent.setNodeid((long)nodeId);
        newEvent.setHost(Capsd.getLocalHostAddress());
        newEvent.setInterface(ifaddr.getHostAddress());
        newEvent.setService(service);
        newEvent.setTime(EventConstants.formatToString((Date)new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = null;
        Value parmValue = null;
        eventParm = new Parm();
        eventParm.setParmName("iphostname");
        parmValue = new Value();
        parmValue.setContent(ifaddr.getHostName());
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("nodelabel");
        parmValue = new Value();
        parmValue.setContent(nodeLabel);
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("nodelabelsource");
        parmValue = new Value();
        parmValue.setContent(labelSource);
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        if (sysName != null) {
            eventParm = new Parm();
            eventParm.setParmName("nodesysname");
            parmValue = new Value();
            parmValue.setContent(sysName);
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
        }
        if (sysDescr != null) {
            eventParm = new Parm();
            eventParm.setParmName("nodesysdescription");
            parmValue = new Value();
            parmValue.setContent(sysDescr);
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
        }
        newEvent.setParms(eventParms);
        return newEvent;
    }

    public static Event createAndSendDeleteServiceEvent(String source, DbNodeEntry nodeEntry, InetAddress ifaddr, String service, String hostName, long txNo) {
        Logger log = ThreadCategory.getInstance(EventUtils.class);
        if (log.isDebugEnabled()) {
            log.debug((Object)("createAndSendDeleteServiceEvent:  nodeId/interface/service  " + nodeEntry.getNodeId() + "/" + ifaddr.getHostAddress() + "/" + service));
        }
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/nodes/deleteService");
        newEvent.setSource(source);
        newEvent.setNodeid((long)nodeEntry.getNodeId());
        newEvent.setHost(hostName);
        newEvent.setInterface(ifaddr.getHostAddress());
        newEvent.setService(service);
        newEvent.setTime(EventConstants.formatToString((Date)new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = null;
        Value parmValue = null;
        eventParm = new Parm();
        eventParm.setParmName("iphostname");
        parmValue = new Value();
        parmValue.setContent(ifaddr.getHostName());
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("nodelabel");
        parmValue = new Value();
        parmValue.setContent(nodeEntry.getLabel());
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("nodelabelsource");
        parmValue = new Value();
        char[] labelSource = new char[]{nodeEntry.getLabelSource()};
        parmValue.setContent(new String(labelSource));
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        newEvent.setParms(eventParms);
        return newEvent;
    }

    public static Event createAddInterfaceEvent(String source, String nodeLabel, String ipaddr, String hostName, long txNo) {
        Logger log = ThreadCategory.getInstance(EventUtils.class);
        if (log.isDebugEnabled()) {
            log.debug((Object)("createAndSendAddInterfaceEvent:  processing updateServer event for interface:  " + ipaddr + " on server: " + hostName));
        }
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/internal/capsd/addInterface");
        newEvent.setSource(source);
        newEvent.setInterface(ipaddr);
        newEvent.setHost(hostName);
        newEvent.setTime(EventConstants.formatToString((Date)new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = null;
        Value parmValue = null;
        eventParm = new Parm();
        eventParm.setParmName("nodelabel");
        parmValue = new Value();
        parmValue.setContent(nodeLabel);
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("txno");
        parmValue = new Value();
        parmValue.setContent(new Long(txNo).toString());
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        newEvent.setParms(eventParms);
        return newEvent;
    }

    public static Event createAndSendDeleteInterfaceEvent(String source, String nodeLabel, String ipaddr, String hostName, long txNo) {
        Logger log = ThreadCategory.getInstance(EventUtils.class);
        if (log.isDebugEnabled()) {
            log.debug((Object)("createAndSendDeleteInterfaceEvent:  processing updateServer event for interface:  " + ipaddr + " on server: " + hostName));
        }
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/internal/capsd/deleteInterface");
        newEvent.setSource(source);
        newEvent.setInterface(ipaddr);
        newEvent.setHost(hostName);
        newEvent.setTime(EventConstants.formatToString((Date)new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = null;
        Value parmValue = null;
        eventParm = new Parm();
        eventParm.setParmName("nodelabel");
        parmValue = new Value();
        parmValue.setContent(nodeLabel);
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("txno");
        parmValue = new Value();
        parmValue.setContent(new Long(txNo).toString());
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        newEvent.setParms(eventParms);
        return newEvent;
    }

    public static Event createChangeServiceEvent(String source, String ipaddr, String service, String action, String hostName, long txNo) {
        Logger log = ThreadCategory.getInstance(EventUtils.class);
        if (log.isDebugEnabled()) {
            log.debug((Object)("createAndSendChangeServiceEvent:  processing updateService event for service:  " + service + " on interface: " + ipaddr));
        }
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/internal/capsd/changeService");
        newEvent.setSource(source);
        newEvent.setInterface(ipaddr);
        newEvent.setService(service);
        newEvent.setTime(EventConstants.formatToString((Date)new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = null;
        Value parmValue = null;
        eventParm = new Parm();
        eventParm.setParmName("action");
        parmValue = new Value();
        parmValue.setContent(action);
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("txno");
        parmValue = new Value();
        parmValue.setContent(new Long(txNo).toString());
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        newEvent.setParms(eventParms);
        return newEvent;
    }

    public static Event createDeleteServiceEvent(String source, long nodeId, String ipAddr, String service, long txNo) {
        Event newEvent = new Event();
        newEvent.setUei("uei.opennms.org/nodes/deleteService");
        newEvent.setSource(source);
        newEvent.setInterface(ipAddr);
        newEvent.setNodeid(nodeId);
        newEvent.setService(service);
        newEvent.setTime(EventConstants.formatToString((Date)new Date()));
        Parms eventParms = new Parms();
        Parm eventParm = null;
        Value parmValue = null;
        eventParm = new Parm();
        eventParm.setParmName("txno");
        parmValue = new Value();
        parmValue.setContent(String.valueOf(txNo));
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        newEvent.setParms(eventParms);
        return newEvent;
    }

    public static String toString(Event event) {
        Iterator i;
        StringBuffer b = new StringBuffer("Event: ");
        if (event.getAutoacknowledge() != null) {
            b.append(" Autoacknowledge: " + event.getAutoacknowledge() + "\n");
        }
        if (event.getAutoactionCount() > 0) {
            b.append(" Autoactions:");
            i = event.getAutoactionCollection().iterator();
            while (i.hasNext()) {
                b.append(" " + ((Autoaction)i.next()).toString());
            }
            b.append("\n");
        }
        if (event.getCreationTime() != null) {
            b.append(" CreationTime: " + event.getCreationTime() + "\n");
        }
        b.append(" Dbid: " + event.getDbid() + "\n");
        if (event.getDescr() != null) {
            b.append(" Descr: " + event.getDescr() + "\n");
        }
        if (event.getDistPoller() != null) {
            b.append(" DistPoller: " + event.getDistPoller() + "\n");
        }
        if (event.getForwardCount() > 0) {
            b.append(" Forwards:");
            i = event.getForwardCollection().iterator();
            while (i.hasNext()) {
                b.append(" " + ((Forward)i.next()).toString());
            }
            b.append("\n");
        }
        if (event.getHost() != null) {
            b.append(" Host: " + event.getHost() + "\n");
        }
        if (event.getInterface() != null) {
            b.append(" Interface: " + event.getInterface() + "\n");
        }
        if (event.getLoggroupCount() > 0) {
            b.append(" Loggroup:");
            i = event.getLoggroupCollection().iterator();
            while (i.hasNext()) {
                b.append(" " + ((String)i.next()).toString());
            }
            b.append("\n");
        }
        if (event.getLogmsg() != null) {
            b.append(" Logmsg: " + event.getLogmsg() + "\n");
        }
        if (event.getMask() != null) {
            b.append(" Mask: " + event.getMask() + "\n");
        }
        if (event.getMasterStation() != null) {
            b.append(" MasterStation: " + event.getMasterStation() + "\n");
        }
        if (event.getMouseovertext() != null) {
            b.append(" Mouseovertext: " + event.getMouseovertext() + "\n");
        }
        b.append(" Nodeid: " + event.getNodeid() + "\n");
        if (event.getOperactionCount() > 0) {
            b.append(" Operaction:");
            i = event.getOperactionCollection().iterator();
            while (i.hasNext()) {
                b.append(" " + ((Operaction)i.next()).toString());
            }
            b.append("\n");
        }
        if (event.getOperinstruct() != null) {
            b.append(" Operinstruct: " + event.getOperinstruct() + "\n");
        }
        if (event.getParms() != null) {
            b.append(" Parms: " + EventUtils.toString(event.getParms()) + "\n");
        }
        if (event.getScriptCount() > 0) {
            b.append(" Script:");
            i = event.getScriptCollection().iterator();
            while (i.hasNext()) {
                b.append(" " + ((Script)i.next()).toString());
            }
            b.append("\n");
        }
        if (event.getService() != null) {
            b.append(" Service: " + event.getService() + "\n");
        }
        if (event.getSeverity() != null) {
            b.append(" Severity: " + event.getSeverity() + "\n");
        }
        if (event.getSnmp() != null) {
            b.append(" Snmp: " + EventUtils.toString(event.getSnmp()) + "\n");
        }
        if (event.getSnmphost() != null) {
            b.append(" Snmphost: " + event.getSnmphost() + "\n");
        }
        if (event.getSource() != null) {
            b.append(" Source: " + event.getSource() + "\n");
        }
        if (event.getTime() != null) {
            b.append(" Time: " + event.getTime() + "\n");
        }
        if (event.getTticket() != null) {
            b.append(" Tticket: " + event.getTticket() + "\n");
        }
        if (event.getUei() != null) {
            b.append(" Uei: " + event.getUei() + "\n");
        }
        if (event.getUuid() != null) {
            b.append(" Uuid: " + event.getUuid() + "\n");
        }
        b.append("End Event\n");
        return b.toString();
    }

    public static String toString(Parms parms) {
        if (parms.getParmCount() == 0) {
            return "Parms: (none)\n";
        }
        StringBuffer b = new StringBuffer();
        b.append("Parms:\n");
        Enumeration e = parms.enumerateParm();
        while (e.hasMoreElements()) {
            Parm p = (Parm)e.nextElement();
            b.append(" ");
            b.append(p.getParmName());
            b.append(" = ");
            b.append(EventUtils.toString(p.getValue()));
            b.append("\n");
        }
        b.append("End Parms\n");
        return b.toString();
    }

    public static String toString(Value value) {
        return value.getType() + "(" + value.getEncoding() + "): " + value.getContent();
    }

    public static String toString(Snmp snmp) {
        StringBuffer b = new StringBuffer("Snmp: ");
        if (snmp.getVersion() != null) {
            b.append("Version: " + snmp.getVersion() + "\n");
        }
        b.append("TimeStamp: " + new Date(snmp.getTimeStamp()) + "\n");
        if (snmp.getCommunity() != null) {
            b.append("Community: " + snmp.getCommunity() + "\n");
        }
        b.append("Generic: " + snmp.getGeneric() + "\n");
        b.append("Specific: " + snmp.getSpecific() + "\n");
        if (snmp.getId() != null) {
            b.append("Id: " + snmp.getId() + "\n");
        }
        if (snmp.getIdtext() != null) {
            b.append("Idtext: " + snmp.getIdtext() + "\n");
        }
        b.append("End Snmp\n");
        return b.toString();
    }

    public static void addParam(Event event, String parmName, Object pollResultId) {
        Parms eventParms = event.getParms();
        if (eventParms == null) {
            eventParms = new Parms();
            event.setParms(eventParms);
        }
        Parm eventParm = null;
        Value parmValue = null;
        eventParm = new Parm();
        eventParm.setParmName(parmName);
        parmValue = new Value();
        parmValue.setContent(String.valueOf(pollResultId));
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
    }
}

