/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.actiond;

import java.util.Enumeration;
import org.apache.log4j.Logger;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.queue.FifoQueueException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.xml.event.Autoaction;
import org.opennms.netmgt.xml.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BroadcastEventProcessor
implements EventListener {
    private final FifoQueue<String> m_execQ;

    BroadcastEventProcessor(FifoQueue<String> execQ) {
        this.m_execQ = execQ;
        EventIpcManagerFactory.init();
        EventIpcManagerFactory.getIpcManager().addEventListener(this);
    }

    public synchronized void close() {
        EventIpcManagerFactory.getIpcManager().removeEventListener(this);
    }

    public void onEvent(Event event) {
        Logger log = ThreadCategory.getInstance(BroadcastEventProcessor.class);
        if (event == null) {
            return;
        }
        Enumeration walker = event.enumerateAutoaction();
        while (walker.hasMoreElements()) {
            try {
                Autoaction aact = (Autoaction)walker.nextElement();
                if (aact.getState().equalsIgnoreCase("on")) {
                    this.m_execQ.add((Object)aact.getContent());
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Added event '" + event.getUei() + "' to execute autoaction '" + aact.getContent() + "'"));
            }
            catch (FifoQueueException ex) {
                log.error((Object)"Failed to add event to execution queue", (Throwable)ex);
                break;
            }
            catch (InterruptedException ex) {
                log.error((Object)"Failed to add event to execution queue", (Throwable)ex);
                break;
            }
        }
        if (event.getTticket() != null && event.getTticket().getState().equalsIgnoreCase("on")) {
            try {
                this.m_execQ.add((Object)event.getTticket().getContent());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Added event '" + event.getUei() + "' to execute tticket '" + event.getTticket().getContent() + "'"));
                }
            }
            catch (FifoQueueException ex) {
                log.error((Object)"Failed to add event to execution queue", (Throwable)ex);
            }
            catch (InterruptedException ex) {
                log.error((Object)"Failed to add event to execution queue", (Throwable)ex);
            }
        }
    }

    public String getName() {
        return "Actiond:BroadcastEventProcessor";
    }
}

