/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.dns;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import org.opennms.protocols.dns.DNSAddressRR;

public class DNSInputStream
extends ByteArrayInputStream {
    public DNSInputStream(byte[] data) {
        super(data);
    }

    public DNSInputStream(byte[] data, int off, int len) {
        super(data, off, len);
    }

    public int readByte() throws IOException {
        int rc = this.read();
        if (rc == -1) {
            throw new EOFException("end of buffer on read");
        }
        return rc;
    }

    public int readShort() throws IOException {
        return this.readByte() << 8 | this.readByte();
    }

    public long readInt() throws IOException {
        long rc = 0L;
        for (int i = 0; i < 4; ++i) {
            rc = rc << 8 | (long)this.readByte();
        }
        return rc;
    }

    public String readString() throws IOException {
        int len = this.readByte();
        if (len == 0) {
            return "";
        }
        byte[] buffer = new byte[len];
        int rc = this.read(buffer);
        if (rc == -1 || rc != len) {
            throw new EOFException("end of file while reading array");
        }
        return new String(buffer);
    }

    public String readDomainName() throws IOException {
        if (this.pos >= this.count) {
            throw new EOFException("EOF reading domain name");
        }
        if ((this.buf[this.pos] & 0xC0) == 0) {
            String tail;
            String label = this.readString();
            if (label.length() > 0 && (tail = this.readDomainName()).length() > 0) {
                label = label + '.' + tail;
            }
            return label;
        }
        if ((this.buf[this.pos] & 0xC0) != 192) {
            throw new IOException("Invalid domain name compression offset");
        }
        int offset = this.readShort() & 0x3FFF;
        DNSInputStream dnsIn = new DNSInputStream(this.buf, offset, this.buf.length - offset);
        return dnsIn.readDomainName();
    }

    public DNSAddressRR readRR() throws IOException {
        String rrName = this.readDomainName();
        int rrType = this.readShort();
        int rrClass = this.readShort();
        long rrTTL = this.readInt();
        int rrDataLen = this.readShort();
        DNSInputStream rrDNSIn = new DNSInputStream(this.buf, this.pos, rrDataLen);
        this.pos += rrDataLen;
        try {
            DNSAddressRR rr = new DNSAddressRR(rrName, rrType, rrClass, rrTTL, rrDNSIn);
            return rr;
        }
        catch (Exception ex) {
            throw new IOException("Unknown DNSAddressRR (type  (" + rrType + "))" + "\nOriginating Exception: " + ex.getMessage());
        }
    }
}

