/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vmmgr;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.service.types.InvokeAtType;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.netmgt.vmmgr.Invoker;
import org.opennms.netmgt.vmmgr.InvokerResult;
import org.opennms.netmgt.vmmgr.InvokerService;
import org.opennms.netmgt.vmmgr.ManagerMBean;
import org.opennms.protocols.icmp.IcmpSocket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Manager
implements ManagerMBean {
    private static final String LOG4J_CATEGORY = "OpenNMS.Manager";

    @Override
    public void stop() {
        this.setLogPrefix();
        for (MBeanServer server : this.getMBeanServers()) {
            this.stop(server);
        }
    }

    private void stop(MBeanServer server) {
        this.log().debug((Object)"Beginning shutdown");
        Invoker invoker = new Invoker();
        invoker.setServer(server);
        invoker.setAtType(InvokeAtType.STOP);
        invoker.setReverse(true);
        invoker.setFailFast(false);
        List<InvokerService> services = InvokerService.createServiceList(Invoker.getDefaultServiceConfigFactory().getServices());
        invoker.setServices(services);
        invoker.getObjectInstances();
        invoker.invokeMethods();
        this.log().debug((Object)"Shutdown complete");
    }

    @Override
    public List<String> status() {
        this.setLogPrefix();
        ArrayList<String> result = new ArrayList<String>();
        for (MBeanServer server : this.getMBeanServers()) {
            result.addAll(this.status(server));
        }
        return result;
    }

    private List<String> status(MBeanServer server) {
        this.log().debug((Object)"Beginning status check");
        Invoker invoker = new Invoker();
        invoker.setServer(server);
        invoker.setAtType(InvokeAtType.STATUS);
        invoker.setFailFast(false);
        List<InvokerService> services = InvokerService.createServiceList(Invoker.getDefaultServiceConfigFactory().getServices());
        invoker.setServices(services);
        invoker.getObjectInstances();
        List<InvokerResult> results = invoker.invokeMethods();
        ArrayList<String> statusInfo = new ArrayList<String>(results.size());
        for (InvokerResult invokerResult : results) {
            if (invokerResult.getThrowable() == null) {
                statusInfo.add("Status: " + invokerResult.getMbean().getObjectName() + " = " + invokerResult.getResult().toString());
                continue;
            }
            statusInfo.add("Status: " + invokerResult.getMbean().getObjectName() + " = STATUS_CHECK_ERROR");
        }
        this.log().debug((Object)"Status check complete");
        return statusInfo;
    }

    @Override
    public void doSystemExit() {
        this.setLogPrefix();
        this.log().debug((Object)"doSystemExit called");
        if (this.log().isDebugEnabled()) {
            this.dumpThreads();
            Runtime r = Runtime.getRuntime();
            this.log().debug((Object)("memory usage (free/used/total/max allowed): " + r.freeMemory() + "/" + (r.totalMemory() - r.freeMemory()) + "/" + r.totalMemory() + "/" + (r.maxMemory() == Long.MAX_VALUE ? "infinite" : Long.valueOf(r.maxMemory()))));
        }
        this.log().info((Object)"calling System.exit(1)");
        this.shutdownLogging();
        System.exit(1);
    }

    private void dumpThreads() {
        Map<Thread, StackTraceElement[]> threads = Thread.getAllStackTraces();
        int daemons = 0;
        for (Thread t : threads.keySet()) {
            if (!t.isDaemon()) continue;
            ++daemons;
        }
        this.log().debug((Object)("Thread dump of " + threads.size() + " threads (" + daemons + " daemons):"));
        TreeMap<Thread, StackTraceElement[]> sortedThreads = new TreeMap<Thread, StackTraceElement[]>(new Comparator<Thread>(){

            @Override
            public int compare(Thread t1, Thread t2) {
                return new Long(t1.getId()).compareTo(new Long(t2.getId()));
            }
        });
        sortedThreads.putAll(threads);
        for (Map.Entry entry : sortedThreads.entrySet()) {
            Thread thread = (Thread)entry.getKey();
            this.log().debug((Object)("Thread " + thread.getId() + (thread.isDaemon() ? " (daemon)" : "") + ": " + thread + " (state: " + (Object)((Object)thread.getState()) + ")"));
            for (StackTraceElement e : (StackTraceElement[])entry.getValue()) {
                this.log().debug((Object)("\t" + e));
            }
        }
        this.log().debug((Object)"Thread dump completed.");
    }

    private void shutdownLogging() {
        Logger.shutdown();
    }

    @Override
    public void doTestLoadLibraries() {
        this.setLogPrefix();
        this.testIcmpSocket();
        this.testRrdInitialize();
        this.testGetLocalHost();
    }

    private void testGetLocalHost() {
        try {
            InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new UndeclaredThrowableException(e, "Could not lookup the host name for the local host machine: " + e);
        }
    }

    private void testIcmpSocket() {
        IcmpSocket s = null;
        try {
            s = new IcmpSocket();
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t, "Could not initialize ICMP socket: " + t.getMessage());
        }
        s.close();
    }

    private void testRrdInitialize() {
        try {
            RrdUtils.initialize();
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t, "Could not initialize RRD subsystem: " + t.getMessage());
        }
    }

    private void setLogPrefix() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    private List<MBeanServer> getMBeanServers() {
        return MBeanServerFactory.findMBeanServer(null);
    }
}

