/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Category;
import org.opennms.core.resource.Vault;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.protocols.ip.IPv4Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeLabel {
    static final String SQL_DB_UPDATE_NODE_LABEL = "UPDATE node SET nodelabel=?,nodelabelsource=? WHERE nodeid=?";
    static final String SQL_DB_RETRIEVE_NETBIOS_NAME = "SELECT nodenetbiosname FROM node WHERE nodeid=?";
    static final String SQL_DB_RETRIEVE_MANAGED_INTERFACES = "SELECT ipaddr,iphostname FROM ipinterface WHERE nodeid=? AND ismanaged='M'";
    static final String SQL_DB_RETRIEVE_NON_MANAGED_INTERFACES = "SELECT ipaddr,iphostname FROM ipinterface WHERE nodeid=? AND ismanaged!='M'";
    static final String SQL_DB_RETRIEVE_SYSNAME = "SELECT nodesysname FROM node WHERE nodeid=?";
    static final String SQL_DB_RETRIEVE_NODELABEL = "SELECT nodelabel,nodelabelsource FROM node WHERE nodeid=?";
    public static final char SOURCE_USERDEFINED = 'U';
    public static final char SOURCE_NETBIOS = 'N';
    public static final char SOURCE_HOSTNAME = 'H';
    public static final char SOURCE_SYSNAME = 'S';
    public static final char SOURCE_ADDRESS = 'A';
    public static final char SOURCE_UNKNOWN = 'X';
    public static final int MAX_NODE_LABEL_LENGTH = 256;
    private static final String SELECT_METHOD_MIN = "min";
    private static final String SELECT_METHOD_MAX = "max";
    private static final String DEFAULT_SELECT_METHOD = "min";
    private String m_nodeLabel;
    private char m_nodeLabelSource;

    public NodeLabel() {
        this.m_nodeLabel = null;
        this.m_nodeLabelSource = (char)88;
    }

    public NodeLabel(String nodeLabel, char nodeLabelSource) {
        this.m_nodeLabel = nodeLabel;
        this.m_nodeLabelSource = nodeLabelSource;
    }

    public String getLabel() {
        return this.m_nodeLabel;
    }

    public char getSource() {
        return this.m_nodeLabelSource;
    }

    public void setLabel(String nodeLabel) {
        this.m_nodeLabel = nodeLabel;
    }

    public void setSource(char nodeLabelSource) {
        this.m_nodeLabelSource = nodeLabelSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NodeLabel retrieveLabel(int nodeID) throws SQLException {
        NodeLabel label = null;
        Connection dbConnection = Vault.getDbConnection();
        try {
            label = NodeLabel.retrieveLabel(nodeID, dbConnection);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            Vault.releaseDbConnection((Connection)dbConnection);
            throw throwable;
        }
        Vault.releaseDbConnection((Connection)dbConnection);
        return label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NodeLabel retrieveLabel(int nodeID, Connection dbConnection) throws SQLException {
        String nodeLabel = null;
        String nodeLabelSource = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        DBUtils d = new DBUtils(NodeLabel.class);
        if (NodeLabel.log().isDebugEnabled()) {
            NodeLabel.log().debug((Object)("NodeLabel.retrieveLabel: sql: SELECT nodelabel,nodelabelsource FROM node WHERE nodeid=? node id: " + nodeID));
        }
        try {
            stmt = dbConnection.prepareStatement(SQL_DB_RETRIEVE_NODELABEL);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeID);
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            if (rs.next()) {
                nodeLabel = rs.getString(1);
                nodeLabelSource = rs.getString(2);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            d.cleanUp();
            throw throwable;
        }
        d.cleanUp();
        if (nodeLabelSource != null) {
            char[] temp = nodeLabelSource.toCharArray();
            return new NodeLabel(nodeLabel, temp[0]);
        }
        return new NodeLabel(nodeLabel, 'X');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assignLabel(int nodeID, NodeLabel nodeLabel) throws SQLException {
        Connection dbConnection = Vault.getDbConnection();
        try {
            NodeLabel.assignLabel(nodeID, nodeLabel, dbConnection);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            Vault.releaseDbConnection((Connection)dbConnection);
            throw throwable;
        }
        Vault.releaseDbConnection((Connection)dbConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assignLabel(int nodeID, NodeLabel nodeLabel, Connection dbConnection) throws SQLException {
        if (nodeLabel == null) {
            nodeLabel = NodeLabel.computeLabel(nodeID, dbConnection);
        }
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(NodeLabel.class);
        try {
            stmt = dbConnection.prepareStatement(SQL_DB_UPDATE_NODE_LABEL);
            d.watch((Object)stmt);
            int column = 1;
            if (NodeLabel.log().isDebugEnabled()) {
                NodeLabel.log().debug((Object)("NodeLabel.assignLabel: Node label: " + nodeLabel.getLabel() + " source: " + nodeLabel.getSource()));
            }
            if (nodeLabel.getLabel() != null) {
                String label = nodeLabel.getLabel();
                if (label.length() > 256) {
                    label = label.substring(0, 256);
                }
                stmt.setString(column++, label);
            } else {
                stmt.setNull(column++, 12);
            }
            stmt.setString(column++, String.valueOf(nodeLabel.getSource()));
            stmt.setInt(column++, nodeID);
            stmt.executeUpdate();
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            d.cleanUp();
            throw throwable;
        }
        d.cleanUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NodeLabel computeLabel(int nodeID) throws SQLException {
        NodeLabel nodeLabel;
        Connection dbConnection = Vault.getDbConnection();
        try {
            nodeLabel = NodeLabel.computeLabel(nodeID, dbConnection);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            Vault.releaseDbConnection((Connection)dbConnection);
            throw throwable;
        }
        Vault.releaseDbConnection((Connection)dbConnection);
        return nodeLabel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NodeLabel computeLabel(int nodeID, Connection dbConnection) throws SQLException {
        NodeLabel nodeLabel;
        int index;
        String primaryHostName;
        DBUtils d;
        ResultSet rs;
        PreparedStatement stmt;
        block21: {
            NodeLabel nodeLabel2;
            String netbiosName = null;
            stmt = null;
            rs = null;
            d = new DBUtils(NodeLabel.class);
            try {
                NodeLabel nodeLabel3;
                stmt = dbConnection.prepareStatement(SQL_DB_RETRIEVE_NETBIOS_NAME);
                d.watch((Object)stmt);
                stmt.setInt(1, nodeID);
                rs = stmt.executeQuery();
                d.watch((Object)rs);
                while (rs.next()) {
                    netbiosName = rs.getString(1);
                }
                if (netbiosName == null) break block21;
                if (netbiosName.length() > 256) {
                    netbiosName = netbiosName.substring(0, 256);
                }
                if (NodeLabel.log().isDebugEnabled()) {
                    NodeLabel.log().debug((Object)("NodeLabel.computeLabel: returning NetBIOS name as nodeLabel: " + netbiosName));
                }
                nodeLabel2 = nodeLabel3 = new NodeLabel(netbiosName, 'N');
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                d.cleanUp();
                throw throwable;
            }
            d.cleanUp();
            return nodeLabel2;
        }
        Object var9_11 = null;
        d.cleanUp();
        String method = System.getProperty("org.opennms.bluebird.dp.primaryInterfaceSelectMethod");
        if (method == null) {
            method = "min";
        }
        if (!method.equals("min") && !method.equals(SELECT_METHOD_MAX)) {
            NodeLabel.log().warn((Object)("Interface selection method is '" + method + "'.  Valid values are 'min' & 'max'.  Will use default value: " + "min"));
            method = "min";
        }
        ArrayList<IPv4Address> ipv4AddrList = new ArrayList<IPv4Address>();
        ArrayList<String> ipHostNameList = new ArrayList<String>();
        try {
            stmt = dbConnection.prepareStatement(SQL_DB_RETRIEVE_MANAGED_INTERFACES);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeID);
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            NodeLabel.loadAddressList(rs, ipv4AddrList, ipHostNameList);
            Object var11_15 = null;
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            d.cleanUp();
            throw throwable;
        }
        d.cleanUp();
        IPv4Address primaryAddr = NodeLabel.selectPrimaryAddress(ipv4AddrList, method);
        if (primaryAddr == null) {
            if (NodeLabel.log().isDebugEnabled()) {
                NodeLabel.log().debug((Object)("NodeLabel.computeLabel: unable to find a primary address for node " + nodeID + ", returning null"));
            }
            ipv4AddrList.clear();
            ipHostNameList.clear();
            try {
                stmt = dbConnection.prepareStatement(SQL_DB_RETRIEVE_NON_MANAGED_INTERFACES);
                d.watch((Object)stmt);
                stmt.setInt(1, nodeID);
                rs = stmt.executeQuery();
                d.watch((Object)rs);
                NodeLabel.loadAddressList(rs, ipv4AddrList, ipHostNameList);
                Object var13_19 = null;
            }
            catch (Throwable throwable) {
                Object var13_20 = null;
                d.cleanUp();
                throw throwable;
            }
            d.cleanUp();
            primaryAddr = NodeLabel.selectPrimaryAddress(ipv4AddrList, method);
        }
        if ((primaryHostName = (String)ipHostNameList.get(index = ipv4AddrList.indexOf(primaryAddr))).length() != 0) {
            if (primaryHostName.length() > 256) {
                primaryHostName = primaryHostName.substring(0, 256);
            }
            return new NodeLabel(primaryHostName, 'H');
        }
        String primarySysName = null;
        try {
            stmt = dbConnection.prepareStatement(SQL_DB_RETRIEVE_SYSNAME);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeID);
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                primarySysName = rs.getString(1);
            }
            Object var15_23 = null;
        }
        catch (Throwable throwable) {
            Object var15_24 = null;
            d.cleanUp();
            throw throwable;
        }
        d.cleanUp();
        if (primarySysName != null && primarySysName.length() > 0) {
            if (primarySysName.length() > 256) {
                primarySysName = primarySysName.substring(0, 256);
            }
            nodeLabel = new NodeLabel(primarySysName, 'S');
            return nodeLabel;
        }
        nodeLabel = new NodeLabel(primaryAddr.toString(), 'A');
        return nodeLabel;
    }

    private static void loadAddressList(ResultSet rs, List<IPv4Address> ipv4AddrList, List<String> ipHostNameList) throws SQLException {
        Category log = NodeLabel.log();
        while (rs.next()) {
            IPv4Address ipv4Addr = new IPv4Address(rs.getString(1));
            ipv4AddrList.add(ipv4Addr);
            String hostName = rs.getString(2);
            if (hostName == null || hostName.equals(ipv4Addr.toString())) {
                ipHostNameList.add("");
            } else {
                ipHostNameList.add(hostName);
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("NodeLabel.computeLabel: adding address " + ipv4Addr.toString() + " with hostname: " + hostName));
        }
    }

    private static IPv4Address selectPrimaryAddress(List<IPv4Address> ipv4AddrList, String method) {
        IPv4Address primaryAddr = null;
        Iterator<IPv4Address> iter = ipv4AddrList.iterator();
        while (iter.hasNext()) {
            if (primaryAddr == null) {
                primaryAddr = iter.next();
                continue;
            }
            IPv4Address currentAddr = iter.next();
            int current = currentAddr.getAddress();
            int primary = primaryAddr.getAddress();
            if (current < 0) {
                current = (int)((long)current + 0x80000000L);
            }
            if (primary < 0) {
                primary = (int)((long)primary + 0x80000000L);
            }
            if (method.equals("min")) {
                if (current >= primary) continue;
                primaryAddr = currentAddr;
                continue;
            }
            if (current <= primary) continue;
            primaryAddr = currentAddr;
        }
        return primaryAddr;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.m_nodeLabel);
        buffer.append(":");
        buffer.append(this.m_nodeLabelSource);
        return buffer.toString();
    }

    private static Category log() {
        return ThreadCategory.getInstance(NodeLabel.class);
    }
}

