/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.tl1d;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.util.concurrent.BlockingQueue;
import org.apache.log4j.Category;
import org.opennms.netmgt.config.tl1d.Tl1Element;
import org.opennms.netmgt.tl1d.Tl1AutonomousMessage;
import org.opennms.netmgt.tl1d.Tl1AutonomousMessageProcessor;
import org.opennms.netmgt.tl1d.Tl1Client;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tl1ClientImpl
implements Tl1Client {
    String m_host;
    int m_port;
    boolean m_started = false;
    private Socket m_tl1Socket;
    private Thread m_socketReader;
    private BlockingQueue<Tl1AutonomousMessage> m_tl1Queue;
    private BufferedReader m_reader;
    private TimeoutSleeper m_sleeper;
    private Category m_log;
    private Tl1AutonomousMessageProcessor m_messageProcessor;
    private long m_reconnectionDelay;
    private int m_reconnectAttempts = 0;

    public Tl1ClientImpl() {
    }

    public Tl1ClientImpl(BlockingQueue<Tl1AutonomousMessage> queue, Tl1Element element, Category log) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.m_host = element.getHost();
        this.m_port = element.getPort();
        this.m_tl1Queue = queue;
        this.m_messageProcessor = (Tl1AutonomousMessageProcessor)Class.forName(element.getTl1MessageParser()).newInstance();
        this.m_reconnectionDelay = element.getReconnectDelay();
        this.m_log = log;
    }

    @Override
    public void start() {
        this.m_log.info((Object)("start: TL1 client: " + this.m_host + ":" + String.valueOf(this.m_port)));
        this.m_log.info((Object)("start:Connection delay = " + this.m_reconnectionDelay));
        this.m_started = true;
        this.m_socketReader = new Thread("TL1-Socket-Reader"){

            public void run() {
                Tl1ClientImpl.this.readMessages();
            }
        };
        this.m_socketReader.start();
        this.m_log.info((Object)("Started TL1 client: " + this.m_host + ":" + String.valueOf(this.m_port)));
    }

    @Override
    public void stop() {
        this.m_log.info((Object)("Stopping TL1 client: " + this.m_host + ":" + String.valueOf(this.m_port)));
        this.m_started = false;
    }

    private BufferedReader getReader() {
        if (this.m_reader == null) {
            this.m_reader = this.createReader();
        }
        return this.m_reader;
    }

    private BufferedReader createReader() {
        while (this.m_started) {
            try {
                this.m_tl1Socket = new Socket(this.m_host, this.m_port);
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.m_tl1Socket.getInputStream()));
                this.resetTimeout();
                return reader;
            }
            catch (IOException e) {
                this.m_log.error((Object)("TL1 Connection Failed to " + this.m_host + ":" + this.m_port));
                this.m_log.debug((Object)e);
                this.waitUntilNextConnectTime();
            }
        }
        return null;
    }

    private void resetTimeout() {
        this.m_log.debug((Object)"resetTimeout: Resetting timeout Thread");
        this.m_reconnectAttempts = 0;
        this.m_sleeper = null;
    }

    private void waitUntilNextConnectTime() {
        this.m_log.debug((Object)("waitUntilNextConnectTime: current connection attempts: " + this.m_reconnectAttempts));
        if (this.m_started) {
            if (this.m_sleeper == null) {
                this.m_sleeper = new TimeoutSleeper();
            }
            ++this.m_reconnectAttempts;
            long waitTime = this.computeWait();
            this.m_log.info((Object)("waitUntilNextConnectTime: Waiting " + waitTime + " ms......"));
            try {
                this.m_sleeper.sleep(waitTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private long computeWait() {
        long waitTime = this.m_reconnectionDelay;
        if (this.m_reconnectAttempts > 5) {
            waitTime = this.m_reconnectionDelay * 5L;
        } else if (this.m_reconnectAttempts > 10) {
            waitTime = this.m_reconnectionDelay * 10L;
        }
        return waitTime;
    }

    private void readMessages() {
        StringBuilder rawMessageBuilder = new StringBuilder();
        this.m_log.info((Object)"readMessages: Begin reading off socket...");
        while (this.m_started) {
            try {
                int ch;
                this.m_log.info((Object)"readMessages: reading line from TL1 socket...");
                BufferedReader reader = this.getReader();
                if (reader == null) continue;
                while ((ch = reader.read()) != -1) {
                    rawMessageBuilder.append((char)ch);
                    if ((char)ch != ';') continue;
                    this.createAndQueueTl1Message(rawMessageBuilder);
                    rawMessageBuilder.setLength(0);
                }
                this.m_log.warn((Object)("readMessages: resetting socket reader to client: " + this.m_host + ":" + this.m_port));
                this.resetReader(null);
            }
            catch (IOException e) {
                this.resetReader(e);
            }
        }
        this.m_log.info((Object)("Stopping TL1 client: " + this.m_host + ":" + String.valueOf(this.m_port)));
    }

    private void createAndQueueTl1Message(StringBuilder rawMessageBuilder) {
        this.m_log.debug((Object)("readMessages: offering message to queue: " + rawMessageBuilder.toString()));
        Tl1AutonomousMessage message = this.detectMessageType(rawMessageBuilder);
        if (message != null) {
            this.m_tl1Queue.offer(message);
            this.m_log.debug((Object)"readMessages: successfully offered to queue.");
        } else {
            this.m_log.debug((Object)"readMessages: message was null, not offered to queue.");
        }
    }

    private Tl1AutonomousMessage detectMessageType(StringBuilder rawMessage) {
        if (this.isAutonomousMessage(rawMessage)) {
            return this.m_messageProcessor.process(rawMessage.toString(), 4);
        }
        return null;
    }

    private boolean isAutonomousMessage(StringBuilder rawMessage) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetReader(IOException ex) {
        if (ex != null) {
            this.m_log.error((Object)"resetReader: connection failure.", (Throwable)ex);
        }
        try {
            try {
                this.m_reader.close();
            }
            catch (IOException e) {
                Object var4_3 = null;
                this.m_reader = null;
            }
            Object var4_2 = null;
            this.m_reader = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.m_reader = null;
            throw throwable;
        }
        try {
            this.m_tl1Socket.close();
        }
        catch (IOException e) {
            this.m_tl1Socket = null;
        }
    }

    @Override
    public String getHost() {
        return this.m_host;
    }

    @Override
    public void setHost(String host) {
        this.m_host = host;
    }

    @Override
    public int getPort() {
        return this.m_port;
    }

    @Override
    public void setPort(int port) {
        this.m_port = port;
    }

    @Override
    public long getReconnectionDelay() {
        return this.m_reconnectionDelay;
    }

    @Override
    public void setReconnectionDelay(long reconnectionDelay) {
        this.m_reconnectionDelay = reconnectionDelay;
    }

    @Override
    public BlockingQueue<Tl1AutonomousMessage> getTl1Queue() {
        return this.m_tl1Queue;
    }

    @Override
    public void setTl1Queue(BlockingQueue<Tl1AutonomousMessage> tl1Queue) {
        this.m_tl1Queue = tl1Queue;
    }

    @Override
    public Tl1AutonomousMessageProcessor getMessageProcessor() {
        return this.m_messageProcessor;
    }

    @Override
    public void setMessageProcessor(Tl1AutonomousMessageProcessor messageProcessor) {
        this.m_messageProcessor = messageProcessor;
    }

    @Override
    public void setLog(Category log) {
        this.m_log = log;
    }

    private class TimeoutSleeper {
        private TimeoutSleeper() {
        }

        public void sleep() throws InterruptedException {
            Thread.sleep(Tl1ClientImpl.this.m_reconnectionDelay);
        }

        public void sleep(long sleepTime) throws InterruptedException {
            Thread.sleep(sleepTime);
        }
    }
}

