/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.threshd.BaseThresholdDefConfigWrapper;
import org.opennms.netmgt.threshd.ThresholdEvaluator;
import org.opennms.netmgt.threshd.ThresholdEvaluatorState;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Value;
import org.springframework.util.Assert;

public class ThresholdEvaluatorHighLow
implements ThresholdEvaluator {
    public boolean supportsType(String type) {
        return "low".equals(type) || "high".equals(type);
    }

    public ThresholdEvaluatorState getThresholdEvaluatorState(BaseThresholdDefConfigWrapper threshold) {
        return new ThresholdEvaluatorStateHighLow(threshold);
    }

    public static class ThresholdEvaluatorStateHighLow
    implements ThresholdEvaluatorState {
        private BaseThresholdDefConfigWrapper m_thresholdConfig;
        private int m_exceededCount;
        private boolean m_armed;

        public ThresholdEvaluatorStateHighLow(BaseThresholdDefConfigWrapper threshold) {
            Assert.notNull((Object)threshold, (String)"threshold argument cannot be null");
            this.setThresholdConfig(threshold);
            this.setExceededCount(0);
            this.setArmed(true);
        }

        public boolean isArmed() {
            return this.m_armed;
        }

        public void setArmed(boolean armed) {
            this.m_armed = armed;
        }

        public int getExceededCount() {
            return this.m_exceededCount;
        }

        public void setExceededCount(int exceededCount) {
            this.m_exceededCount = exceededCount;
        }

        public BaseThresholdDefConfigWrapper getThresholdConfig() {
            return this.m_thresholdConfig;
        }

        public void setThresholdConfig(BaseThresholdDefConfigWrapper thresholdConfig) {
            Assert.notNull((Object)thresholdConfig.getType(), (String)"threshold must have a 'type' value set");
            Assert.notNull((Object)thresholdConfig.getDatasourceExpression(), (String)"threshold must have a 'ds-name' value set");
            Assert.notNull((Object)thresholdConfig.getDsType(), (String)"threshold must have a 'ds-type' value set");
            Assert.isTrue((boolean)thresholdConfig.hasValue(), (String)"threshold must have a 'value' value set");
            Assert.isTrue((boolean)thresholdConfig.hasRearm(), (String)"threshold must have a 'rearm' value set");
            Assert.isTrue((boolean)thresholdConfig.hasTrigger(), (String)"threshold must have a 'trigger' value set");
            this.m_thresholdConfig = thresholdConfig;
        }

        public String getType() {
            return this.getThresholdConfig().getType().toString();
        }

        public ThresholdEvaluatorState.Status evaluate(double dsValue) {
            if (this.isThresholdExceeded(dsValue)) {
                if (this.isArmed()) {
                    this.setExceededCount(this.getExceededCount() + 1);
                    if (this.log().isDebugEnabled()) {
                        this.log().debug((Object)("evaluate: " + this.getType() + " threshold exceeded, count=" + this.getExceededCount()));
                    }
                    if (this.isTriggerCountExceeded()) {
                        this.log().debug((Object)("evaluate: " + this.getType() + " threshold triggered"));
                        this.setExceededCount(1);
                        this.setArmed(false);
                        return ThresholdEvaluatorState.Status.TRIGGERED;
                    }
                }
            } else if (this.isRearmExceeded(dsValue)) {
                if (!this.isArmed()) {
                    this.log().debug((Object)("evaluate: " + this.getType() + " threshold rearmed"));
                    this.setArmed(true);
                    this.setExceededCount(0);
                    return ThresholdEvaluatorState.Status.RE_ARMED;
                }
            } else {
                this.log().debug((Object)("evaluate: resetting " + this.getType() + " threshold count to 0"));
                this.setExceededCount(0);
            }
            return ThresholdEvaluatorState.Status.NO_CHANGE;
        }

        protected boolean isThresholdExceeded(double dsValue) {
            if ("high".equals(this.getThresholdConfig().getType())) {
                return dsValue >= this.getThresholdConfig().getValue();
            }
            if ("low".equals(this.getThresholdConfig().getType())) {
                return dsValue <= this.getThresholdConfig().getValue();
            }
            throw new IllegalStateException("This thresholding strategy can only be used for thresholding types of 'high' and 'low'.");
        }

        protected boolean isRearmExceeded(double dsValue) {
            if ("high".equals(this.getThresholdConfig().getType())) {
                return dsValue <= this.getThresholdConfig().getRearm();
            }
            if ("low".equals(this.getThresholdConfig().getType())) {
                return dsValue >= this.getThresholdConfig().getRearm();
            }
            throw new IllegalStateException("This thresholding strategy can only be used for thresholding types of 'high' and 'low'.");
        }

        protected boolean isTriggerCountExceeded() {
            return this.getExceededCount() >= this.getThresholdConfig().getTrigger();
        }

        public Event getEventForState(ThresholdEvaluatorState.Status status, Date date, double dsValue, String dsInstance) {
            switch (status) {
                case TRIGGERED: {
                    String uei = this.getThresholdConfig().getTriggeredUEI();
                    if ("low".equals(this.getThresholdConfig().getType())) {
                        if (uei == null || "".equals(uei)) {
                            uei = "uei.opennms.org/threshold/lowThresholdExceeded";
                        }
                        return this.createBasicEvent(uei, date, dsValue, dsInstance);
                    }
                    if ("high".equals(this.getThresholdConfig().getType())) {
                        if (uei == null || "".equals(uei)) {
                            uei = "uei.opennms.org/threshold/highThresholdExceeded";
                        }
                        return this.createBasicEvent(uei, date, dsValue, dsInstance);
                    }
                    throw new IllegalArgumentException("Threshold type " + this.getThresholdConfig().getType().toString() + " is not supported");
                }
                case RE_ARMED: {
                    String uei = this.getThresholdConfig().getRearmedUEI();
                    if ("low".equals(this.getThresholdConfig().getType())) {
                        if (uei == null || "".equals(uei)) {
                            uei = "uei.opennms.org/threshold/lowThresholdRearmed";
                        }
                        return this.createBasicEvent(uei, date, dsValue, dsInstance);
                    }
                    if ("high".equals(this.getThresholdConfig().getType())) {
                        if (uei == null || "".equals(uei)) {
                            uei = "uei.opennms.org/threshold/highThresholdRearmed";
                        }
                        return this.createBasicEvent(uei, date, dsValue, dsInstance);
                    }
                    throw new IllegalArgumentException("Threshold type " + this.getThresholdConfig().getType().toString() + " is not supported");
                }
                case NO_CHANGE: {
                    return null;
                }
            }
            throw new IllegalArgumentException("Status " + (Object)((Object)status) + " is not supported for converting to an event.");
        }

        private Event createBasicEvent(String uei, Date date, double dsValue, String dsInstance) {
            Event event = new Event();
            event.setUei(uei);
            event.setSource("OpenNMS.Threshd." + this.getThresholdConfig().getDatasourceExpression());
            try {
                event.setHost(InetAddress.getLocalHost().getHostName());
            }
            catch (UnknownHostException e) {
                event.setHost("unresolved.host");
                this.log().warn((Object)("Failed to resolve local hostname: " + e), (Throwable)e);
            }
            event.setTime(EventConstants.formatToString((Date)date));
            Parms eventParms = new Parms();
            Parm eventParm = null;
            Value parmValue = null;
            eventParm = new Parm();
            eventParm.setParmName("ds");
            parmValue = new Value();
            parmValue.setContent(this.getThresholdConfig().getDatasourceExpression());
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
            eventParm = new Parm();
            eventParm.setParmName("value");
            parmValue = new Value();
            parmValue.setContent(Double.toString(dsValue));
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
            eventParm = new Parm();
            eventParm.setParmName("threshold");
            parmValue = new Value();
            parmValue.setContent(Double.toString(this.getThresholdConfig().getValue()));
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
            eventParm = new Parm();
            eventParm.setParmName("trigger");
            parmValue = new Value();
            parmValue.setContent(Integer.toString(this.getThresholdConfig().getTrigger()));
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
            eventParm = new Parm();
            eventParm.setParmName("rearm");
            parmValue = new Value();
            parmValue.setContent(Double.toString(this.getThresholdConfig().getRearm()));
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
            eventParm = new Parm();
            eventParm.setParmName("instance");
            parmValue = new Value();
            parmValue.setContent(dsInstance != null ? dsInstance : "null");
            eventParm.setValue(parmValue);
            eventParms.addParm(eventParm);
            event.setParms(eventParms);
            return event;
        }

        private final Category log() {
            return ThreadCategory.getInstance(this.getClass());
        }

        public ThresholdEvaluatorState getCleanClone() {
            return new ThresholdEvaluatorStateHighLow(this.m_thresholdConfig);
        }
    }
}

