/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.config.threshd.Threshold;
import org.opennms.netmgt.dao.support.RrdFileConstants;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.threshd.ThresholdingException;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Value;

public class LatencyInterface {
    private NetworkInterface m_iface;
    private String m_serviceName;

    public LatencyInterface(NetworkInterface iface, String serviceName) {
        this.m_iface = iface;
        this.m_serviceName = serviceName;
    }

    public NetworkInterface getNetworkInterface() {
        return this.m_iface;
    }

    Map getThresholdMap() {
        NetworkInterface iface = this.getNetworkInterface();
        Map thresholdMap = (Map)iface.getAttribute("org.opennms.netmgt.collectd.LatencyThresholder.ThresholdMap");
        return thresholdMap;
    }

    InetAddress getInetAddress() {
        NetworkInterface iface = this.getNetworkInterface();
        InetAddress ipAddr = (InetAddress)iface.getAddress();
        return ipAddr;
    }

    public String getServiceName() {
        return this.m_serviceName;
    }

    int getNodeId() throws ThresholdingException {
        NetworkInterface iface = this.getNetworkInterface();
        int nodeId = -1;
        Integer tmp = (Integer)iface.getAttribute("org.opennms.netmgt.collectd.SnmpThresholder.NodeId");
        if (tmp != null) {
            nodeId = tmp;
        }
        if (nodeId == -1) {
            throw new ThresholdingException("Threshold checking failed for " + this.getServiceName() + "/" + this.getInetAddress().getHostAddress() + ", missing nodeId.", 2);
        }
        return nodeId;
    }

    public String getHostName() {
        return this.getInetAddress().getHostAddress();
    }

    File getLatencyDir() throws ThresholdingException {
        File latencyDir;
        String repository = (String)this.getNetworkInterface().getAttribute("org.opennms.netmgt.collectd.LatencyThresholder.RrdRepository");
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("check: rrd repository=" + repository));
        }
        if (!(latencyDir = new File(repository + File.separator + this.getHostName())).exists()) {
            throw new ThresholdingException("Latency directory for " + this.getServiceName() + "/" + this.getHostName() + " does not exist. Threshold checking failed for " + this.getHostName(), 2);
        }
        if (!RrdFileConstants.isValidRRDLatencyDir((File)latencyDir)) {
            throw new ThresholdingException("Latency directory for " + this.getServiceName() + "/" + this.getHostName() + " is not a valid RRD latency directory. Threshold checking failed for " + this.getHostName(), 2);
        }
        return latencyDir;
    }

    private final Category log() {
        return ThreadCategory.getInstance(LatencyInterface.class);
    }

    Event createEvent(double dsValue, Threshold threshold, String uei, Date date) throws ThresholdingException {
        int nodeId = this.getNodeId();
        InetAddress ipAddr = this.getInetAddress();
        Category log = ThreadCategory.getInstance(LatencyInterface.class);
        if (threshold == null) {
            throw new IllegalArgumentException("threshold cannot be null.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("createEvent: ds=" + threshold.getDsName() + " uei=" + uei));
        }
        Event newEvent = new Event();
        newEvent.setUei(uei);
        newEvent.setNodeid((long)nodeId);
        newEvent.setInterface(ipAddr.getHostAddress());
        newEvent.setService(this.getServiceName());
        newEvent.setSource("OpenNMS.Threshd:" + threshold.getDsName());
        try {
            newEvent.setHost(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException uhE) {
            newEvent.setHost("unresolved.host");
            log.warn((Object)"Failed to resolve local hostname", (Throwable)uhE);
        }
        newEvent.setTime(EventConstants.formatToString((Date)date));
        Parms eventParms = new Parms();
        Parm eventParm = null;
        Value parmValue = null;
        eventParm = new Parm();
        eventParm.setParmName("ds");
        parmValue = new Value();
        parmValue.setContent(threshold.getDsName());
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("value");
        parmValue = new Value();
        parmValue.setContent(Double.toString(dsValue));
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("threshold");
        parmValue = new Value();
        parmValue.setContent(Double.toString(threshold.getValue()));
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("trigger");
        parmValue = new Value();
        parmValue.setContent(Integer.toString(threshold.getTrigger()));
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        eventParm = new Parm();
        eventParm.setParmName("rearm");
        parmValue = new Value();
        parmValue.setContent(Double.toString(threshold.getRearm()));
        eventParm.setValue(parmValue);
        eventParms.addParm(eventParm);
        newEvent.setParms(eventParms);
        return newEvent;
    }
}

