/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.scriptd;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.log4j.Category;
import org.opennms.core.fiber.PausableFiber;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.queue.FifoQueueException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.ScriptdConfigFactory;
import org.opennms.netmgt.config.scriptd.Engine;
import org.opennms.netmgt.config.scriptd.EventScript;
import org.opennms.netmgt.config.scriptd.ReloadScript;
import org.opennms.netmgt.config.scriptd.StartScript;
import org.opennms.netmgt.config.scriptd.StopScript;
import org.opennms.netmgt.config.scriptd.Uei;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Script;

final class Executor
implements Runnable,
PausableFiber {
    private FifoQueue m_execQ;
    private Thread m_worker;
    private String m_name;
    private int m_status;
    private ScriptdConfigFactory m_config;
    private ArrayList m_eventScripts;
    private Hashtable m_eventScriptMap;
    private BSFManager m_mgr;

    Executor(FifoQueue execQ, ScriptdConfigFactory config) {
        this.m_execQ = execQ;
        this.m_config = config;
        this.loadConfig();
        this.m_worker = null;
        this.m_name = "Scriptd-Executor";
        this.m_mgr = null;
        this.m_status = 0;
    }

    private void loadConfig() {
        EventScript[] scripts = this.m_config.getEventScripts();
        this.m_eventScripts = new ArrayList();
        this.m_eventScriptMap = new Hashtable();
        for (int i = 0; i < scripts.length; ++i) {
            Uei[] ueis = scripts[i].getUei();
            if (ueis.length == 0) {
                this.m_eventScripts.add(scripts[i]);
                continue;
            }
            for (int j = 0; j < ueis.length; ++j) {
                String uei = ueis[j].getName();
                ArrayList<EventScript> list = (ArrayList<EventScript>)this.m_eventScriptMap.get(uei);
                if (list == null) {
                    list = new ArrayList<EventScript>();
                    list.add(scripts[i]);
                    this.m_eventScriptMap.put(uei, list);
                    continue;
                }
                list.add(scripts[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Category log = ThreadCategory.getInstance(Executor.class);
        Executor executor = this;
        synchronized (executor) {
            this.m_status = 2;
        }
        while (true) {
            Script script;
            executor = this;
            synchronized (executor) {
                if (this.m_status == 3 || this.m_status == 4) {
                    break;
                }
                while (this.m_status == 5 || this.m_status == 6) {
                    this.m_status = 6;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                        break;
                    }
                }
                if (this.m_status == 7) {
                    this.m_status = 2;
                }
            }
            Event event = null;
            try {
                event = (Event)this.m_execQ.remove(1000L);
                if (event == null) {
                    continue;
                }
            }
            catch (InterruptedException ex) {
                break;
            }
            catch (FifoQueueException ex) {
                log.warn((Object)"The input event queue has errors, exiting...", (Throwable)ex);
                break;
            }
            if ("uei.opennms.org/internal/reloadScriptConfig".equals(event.getUei())) {
                try {
                    ScriptdConfigFactory.reload();
                    this.m_config = ScriptdConfigFactory.getInstance();
                    this.loadConfig();
                    ReloadScript[] reloadScripts = this.m_config.getReloadScripts();
                    for (int i = 0; i < reloadScripts.length; ++i) {
                        try {
                            this.m_mgr.exec(reloadScripts[i].getLanguage(), "", 0, 0, (Object)reloadScripts[i].getContent());
                            continue;
                        }
                        catch (BSFException ex) {
                            log.error((Object)("Reload script[" + i + "] failed."), (Throwable)ex);
                        }
                    }
                    log.debug((Object)"Script configuration reloaded");
                }
                catch (Exception ex) {
                    log.error((Object)"Unable to reload ScriptD configuration: ", (Throwable)ex);
                }
            }
            Script[] attachedScripts = event.getScript();
            ArrayList mapScripts = null;
            try {
                mapScripts = (ArrayList)this.m_eventScriptMap.get(event.getUei());
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (attachedScripts.length <= 0 && mapScripts == null && this.m_eventScripts.size() <= 0) continue;
            log.debug((Object)("Executing scripts for: " + event.getUei()));
            this.m_mgr.registerBean("event", (Object)event);
            if (attachedScripts.length > 0) {
                for (int i = 0; i < attachedScripts.length; ++i) {
                    try {
                        script = attachedScripts[i];
                        this.m_mgr.exec(script.getLanguage(), "", 0, 0, (Object)script.getContent());
                        continue;
                    }
                    catch (BSFException ex) {
                        log.error((Object)("Attached script [" + i + "] execution failed"), (Throwable)ex);
                    }
                }
            }
            if (mapScripts != null) {
                for (int i = 0; i < mapScripts.size(); ++i) {
                    try {
                        script = (EventScript)mapScripts.get(i);
                        this.m_mgr.exec(script.getLanguage(), "", 0, 0, (Object)script.getContent());
                        continue;
                    }
                    catch (BSFException ex) {
                        log.error((Object)("UEI-specific event handler script execution failed: " + event.getUei()), (Throwable)ex);
                    }
                }
            }
            for (int i = 0; i < this.m_eventScripts.size(); ++i) {
                try {
                    script = (EventScript)this.m_eventScripts.get(i);
                    this.m_mgr.exec(script.getLanguage(), "", 0, 0, (Object)script.getContent());
                    continue;
                }
                catch (BSFException ex) {
                    log.error((Object)("Non-UEI-specific event handler script [" + i + "] execution failed"), (Throwable)ex);
                }
            }
            this.m_mgr.unregisterBean("event");
            log.debug((Object)("Finished executing scripts for: " + event.getUei()));
        }
        executor = this;
        synchronized (executor) {
            this.m_status = 4;
        }
    }

    public synchronized void start() {
        Category log = ThreadCategory.getInstance(Executor.class);
        if (this.m_worker != null) {
            throw new IllegalStateException("The fiber has already been run");
        }
        this.m_status = 1;
        Engine[] engines = this.m_config.getEngines();
        for (int i = 0; i < engines.length; ++i) {
            Engine engine = engines[i];
            log.debug((Object)("Registering engine: " + engine.getLanguage()));
            String[] extensions = null;
            String extensionList = engines[i].getExtensions();
            if (extensionList != null) {
                StringTokenizer st = new StringTokenizer(extensionList);
                extensions = new String[st.countTokens()];
                int j = 0;
                while (st.hasMoreTokens()) {
                    extensions[j++] = st.nextToken();
                }
            }
            BSFManager.registerScriptingEngine((String)engines[i].getLanguage(), (String)engines[i].getClassName(), (String[])extensions);
        }
        this.m_mgr = new BSFManager();
        this.m_mgr.registerBean("log", (Object)ThreadCategory.getInstance(Executor.class));
        StartScript[] startScripts = this.m_config.getStartScripts();
        for (int i = 0; i < startScripts.length; ++i) {
            try {
                this.m_mgr.exec(startScripts[i].getLanguage(), "", 0, 0, (Object)startScripts[i].getContent());
                continue;
            }
            catch (BSFException ex) {
                log.error((Object)("Start script[" + i + "] failed."), (Throwable)ex);
            }
        }
        this.m_worker = new Thread((Runnable)this, this.getName());
        this.m_worker.start();
    }

    public synchronized void stop() {
        Category log = (Category)this.m_mgr.lookupBean("log");
        if (this.m_worker == null) {
            throw new IllegalStateException("The fiber has never been run");
        }
        if (this.m_status != 4) {
            this.m_status = 3;
        }
        if (this.m_worker.isAlive()) {
            this.m_worker.interrupt();
        }
        StopScript[] stopScripts = this.m_config.getStopScripts();
        this.notifyAll();
        for (int i = 0; i < stopScripts.length; ++i) {
            try {
                this.m_mgr.exec(stopScripts[i].getLanguage(), "", 0, 0, (Object)stopScripts[i].getContent());
                continue;
            }
            catch (BSFException ex) {
                log.error((Object)("Stop script[" + i + "] failed."), (Throwable)ex);
            }
        }
        log.debug((Object)"Stopped");
    }

    public synchronized void pause() {
        if (this.m_worker == null || !this.m_worker.isAlive()) {
            throw new IllegalStateException("The fiber is not running");
        }
        if (this.m_status == 2 || this.m_status == 7) {
            this.m_status = 5;
            this.notifyAll();
        }
    }

    public synchronized void resume() {
        if (this.m_worker == null || !this.m_worker.isAlive()) {
            throw new IllegalStateException("The fiber is not running");
        }
        if (this.m_status == 6 || this.m_status == 5) {
            this.m_status = 7;
            this.notifyAll();
        }
    }

    public String getName() {
        return this.m_name;
    }

    public synchronized int getStatus() {
        if (this.m_worker != null && !this.m_worker.isAlive()) {
            this.m_status = 4;
        }
        return this.m_status;
    }
}

