/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rtc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Category;
import org.opennms.core.concurrent.RunnableConsumerThreadPool;
import org.opennms.core.fiber.Fiber;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.queue.FifoQueueException;
import org.opennms.core.utils.HttpUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.RTCConfigFactory;
import org.opennms.netmgt.rtc.datablock.HttpPostInfo;
import org.opennms.netmgt.rtc.datablock.RTCCategory;
import org.opennms.netmgt.rtc.utils.EuiLevelMapper;
import org.opennms.netmgt.rtc.utils.PipedMarshaller;
import org.opennms.netmgt.xml.rtc.EuiLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DataSender
implements Fiber {
    private Map<String, RTCCategory> m_categories;
    private Map<String, Set<HttpPostInfo>> m_catUrlMap;
    private RunnableConsumerThreadPool m_dsrPool;
    private FifoQueue<Runnable> m_dataSenderQ;
    private EuiLevelMapper m_euiMapper;
    private final int POST_ERROR_LIMIT;
    private int m_status;

    private int setCurrentThreadPriority(int priority) {
        int oldPriority;
        block2: {
            Thread currentThread = Thread.currentThread();
            oldPriority = currentThread.getPriority();
            try {
                currentThread.setPriority(priority);
            }
            catch (Exception e) {
                Category log = ThreadCategory.getInstance(this.getClass());
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)"Error setting thread priority: ", (Throwable)e);
            }
        }
        return oldPriority;
    }

    public DataSender(Map<String, RTCCategory> categories, int numSenders) {
        this.m_categories = categories;
        this.m_catUrlMap = new HashMap<String, Set<HttpPostInfo>>();
        this.m_dsrPool = new RunnableConsumerThreadPool("DataSenderPool", 0.6f, 1.0f, numSenders);
        this.m_dataSenderQ = this.m_dsrPool.getRunQueue();
        this.m_euiMapper = new EuiLevelMapper();
        this.POST_ERROR_LIMIT = RTCConfigFactory.getInstance().getErrorsBeforeUrlUnsubscribe();
    }

    public synchronized void start() {
        this.m_status = 1;
        Category log = ThreadCategory.getInstance(this.getClass());
        log.info((Object)"Starting the datasender thread pool..");
        try {
            this.m_dsrPool.start();
            log.info((Object)"Datasender thread pool started..");
        }
        catch (Exception e) {
            log.error((Object)"Error starting data sender pool", (Throwable)e);
        }
        this.m_status = 2;
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public synchronized void stop() {
        this.m_status = 3;
        this.log().info((Object)"DataSender - shutting down the data sender pool");
        try {
            this.m_dsrPool.stop();
        }
        catch (Exception e) {
            this.log().error((Object)"Error shutting down data sender pool", (Throwable)e);
        }
        this.m_status = 4;
        this.log().info((Object)"DataSender shutdown complete");
    }

    public String getName() {
        return "OpenNMS.RTC.DataSender";
    }

    public int getStatus() {
        return this.m_status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void subscribe(String url, String catlabel, String user, String passwd) {
        RTCCategory cat = this.m_categories.get(catlabel);
        if (cat == null) {
            this.log().warn((Object)("RTC: No information available for category: " + catlabel));
            return;
        }
        HttpPostInfo postInfo = null;
        try {
            postInfo = new HttpPostInfo(url, catlabel, user, passwd);
        }
        catch (MalformedURLException mue) {
            this.log().warn((Object)("ERROR subscribing: Invalid URL '" + url + "' - Data WILL NOT be SENT to the specified url"));
            return;
        }
        Set<HttpPostInfo> urlList = this.m_catUrlMap.get(catlabel);
        if (urlList == null) {
            urlList = new HashSet<HttpPostInfo>();
            this.m_catUrlMap.put(catlabel, urlList);
        }
        if (!urlList.add(postInfo) && this.log().isDebugEnabled()) {
            this.log().debug((Object)("Already subscribed to URL: " + url + "\tcatlabel: " + catlabel + "\tuser:" + user + " - IGNORING LATEST subscribe event"));
        } else if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("Subscribed to URL: " + url + "\tcatlabel: " + catlabel + "\tuser:" + user));
        }
        Reader inr = null;
        InputStream inp = null;
        try {
            block16: {
                try {
                    int bytesRead;
                    int oldPriority = this.setCurrentThreadPriority(10);
                    EuiLevel euidata = this.m_euiMapper.convertToEuiLevelXML(cat);
                    inr = new PipedMarshaller(euidata).getReader();
                    if (this.log().isDebugEnabled()) {
                        this.log().debug((Object)("DataSender: posting data to: " + url));
                    }
                    inp = HttpUtils.post((URL)postInfo.getURL(), (Reader)inr, (String)user, (String)passwd, (int)8192);
                    byte[] tmp = new byte[1024];
                    while ((bytesRead = inp.read(tmp)) != -1) {
                        if (!this.log().isDebugEnabled() || bytesRead <= 0) continue;
                        this.log().debug((Object)("DataSender: post response: " + new String(tmp, 0, bytesRead)));
                    }
                    oldPriority = this.setCurrentThreadPriority(oldPriority);
                    if (!this.log().isDebugEnabled()) break block16;
                    this.log().debug((Object)("DataSender: posted data for category: " + catlabel));
                }
                catch (IOException ioE) {
                    this.log().warn((Object)("DataSender:  Unable to send category '" + catlabel + "' to URL '" + url + "': "), (Throwable)ioE);
                    this.setCurrentThreadPriority(5);
                    Object var15_20 = null;
                    IOUtils.closeQuietly((InputStream)inp);
                    IOUtils.closeQuietly((Reader)inr);
                    return;
                }
                catch (OutOfMemoryError oe) {
                    this.log().warn((Object)("DataSender:  Unable to send category '" + catlabel + "' to URL '" + url + "': "), (Throwable)oe);
                    this.setCurrentThreadPriority(5);
                    Object var15_21 = null;
                    IOUtils.closeQuietly((InputStream)inp);
                    IOUtils.closeQuietly((Reader)inr);
                    return;
                }
                catch (RuntimeException e) {
                    this.log().warn((Object)("DataSender:  Unable to send category '" + catlabel + "' to URL '" + url + "': "), (Throwable)e);
                    this.setCurrentThreadPriority(5);
                    Object var15_22 = null;
                    IOUtils.closeQuietly((InputStream)inp);
                    IOUtils.closeQuietly((Reader)inr);
                    return;
                }
                catch (Throwable t) {
                    this.log().warn((Object)("DataSender:  Unable to send category '" + catlabel + "' to URL '" + url + "': "), t);
                    this.setCurrentThreadPriority(5);
                    Object var15_23 = null;
                    IOUtils.closeQuietly((InputStream)inp);
                    IOUtils.closeQuietly((Reader)inr);
                    return;
                }
            }
            Object var15_19 = null;
            IOUtils.closeQuietly((InputStream)inp);
            IOUtils.closeQuietly((Reader)inr);
            return;
        }
        catch (Throwable throwable) {
            Object var15_24 = null;
            IOUtils.closeQuietly(inp);
            IOUtils.closeQuietly(inr);
            throw throwable;
        }
    }

    public synchronized void unsubscribe(String urlStr) {
        URL url = null;
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException mue) {
            this.log().warn((Object)("ERROR unsubscribing: Invalid URL: " + url));
            return;
        }
        for (String key : this.m_catUrlMap.keySet()) {
            Set<HttpPostInfo> value = this.m_catUrlMap.get(key);
            if (value == null) continue;
            Iterator<HttpPostInfo> postSet = value.iterator();
            while (postSet.hasNext()) {
                HttpPostInfo postInfo = postSet.next();
                if (!url.equals(postInfo.getURL())) continue;
                postSet.remove();
            }
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("Unsubscribed URL: " + url));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void sendData() {
        this.log().debug((Object)"In DataSender sendData()");
        Iterator<RTCCategory> i$ = this.m_categories.values().iterator();
        while (i$.hasNext()) {
            Set<HttpPostInfo> urlList;
            RTCCategory cat = i$.next();
            String catlabel = cat.getLabel();
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("DataSender:sendData(): Category '" + catlabel));
            }
            if ((urlList = this.m_catUrlMap.get(catlabel)) == null || urlList.size() <= 0) {
                if (!this.log().isDebugEnabled()) continue;
                this.log().debug((Object)("DataSender: category '" + catlabel + "' has no listeners"));
                continue;
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("DataSender: category '" + catlabel + "' has listeners - converting to xml..."));
            }
            int oldPriority = this.setCurrentThreadPriority(10);
            EuiLevel euidata = null;
            try {
                euidata = this.m_euiMapper.convertToEuiLevelXML(cat);
            }
            catch (OutOfMemoryError oe) {
                this.log().warn((Object)("DataSender: unable to convert data to xml for category: " + catlabel), (Throwable)oe);
                this.setCurrentThreadPriority(5);
                continue;
            }
            catch (Throwable t) {
                this.log().warn((Object)("DataSender: unable to convert data to xml for category: " + catlabel), t);
                this.setCurrentThreadPriority(5);
            }
            if (urlList != null && urlList.size() > 0) {
                Iterator<HttpPostInfo> urlIter = urlList.iterator();
                while (urlIter.hasNext()) {
                    HttpPostInfo postInfo;
                    block20: {
                        Object var14_19;
                        postInfo = urlIter.next();
                        Reader inr = null;
                        InputStream inp = null;
                        try {
                            try {
                                int bytesRead;
                                inr = new PipedMarshaller(euidata).getReader();
                                if (this.log().isDebugEnabled()) {
                                    this.log().debug((Object)("DataSender: posting data to: " + postInfo.getURLString()));
                                }
                                inp = HttpUtils.post((URL)postInfo.getURL(), (Reader)inr, (String)postInfo.getUser(), (String)postInfo.getPassword(), (int)8192);
                                if (this.log().isDebugEnabled()) {
                                    this.log().debug((Object)("DataSender: posted data for category: " + catlabel));
                                }
                                byte[] tmp = new byte[1024];
                                while ((bytesRead = inp.read(tmp)) != -1) {
                                    if (!this.log().isDebugEnabled() || bytesRead <= 0) continue;
                                    this.log().debug((Object)("DataSender: post response: " + new String(tmp, 0, bytesRead)));
                                }
                                postInfo.clearErrors();
                            }
                            catch (IOException e) {
                                this.log().warn((Object)("DataSender: unable to send data for category: " + catlabel + " due to " + e.getClass().getName() + ": " + e.getMessage()), (Throwable)e);
                                postInfo.incrementErrors();
                                this.setCurrentThreadPriority(5);
                                var14_19 = null;
                                IOUtils.closeQuietly((InputStream)inp);
                                IOUtils.closeQuietly((Reader)inr);
                                break block20;
                            }
                            catch (OutOfMemoryError e) {
                                this.log().warn((Object)("DataSender: unable to send data for category: " + catlabel + " due to " + e.getClass().getName() + ": " + e.getMessage()), (Throwable)e);
                                this.setCurrentThreadPriority(5);
                                var14_19 = null;
                                IOUtils.closeQuietly((InputStream)inp);
                                IOUtils.closeQuietly((Reader)inr);
                                break block20;
                            }
                            catch (RuntimeException e) {
                                this.log().warn((Object)("DataSender: unable to send data for category: " + catlabel + " due to " + e.getClass().getName() + ": " + e.getMessage()), (Throwable)e);
                                this.setCurrentThreadPriority(5);
                                var14_19 = null;
                                IOUtils.closeQuietly((InputStream)inp);
                                IOUtils.closeQuietly((Reader)inr);
                                break block20;
                            }
                            catch (Throwable t) {
                                this.log().warn((Object)("DataSender: unable to send data for category: " + catlabel + " due to " + t.getClass().getName() + ": " + t.getMessage()), t);
                                this.setCurrentThreadPriority(5);
                                var14_19 = null;
                                IOUtils.closeQuietly((InputStream)inp);
                                IOUtils.closeQuietly((Reader)inr);
                                break block20;
                            }
                            var14_19 = null;
                        }
                        catch (Throwable throwable) {
                            var14_19 = null;
                            IOUtils.closeQuietly(inp);
                            IOUtils.closeQuietly((Reader)inr);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((InputStream)inp);
                        IOUtils.closeQuietly((Reader)inr);
                    }
                    if (this.POST_ERROR_LIMIT <= 0 || postInfo.getErrors() < this.POST_ERROR_LIMIT) continue;
                    urlIter.remove();
                    this.log().warn((Object)("URL " + postInfo.getURLString() + " UNSUBSCRIBED due to reaching error limit " + postInfo.getErrors()));
                }
            }
            oldPriority = this.setCurrentThreadPriority(oldPriority);
        }
        return;
    }

    public synchronized void notifyToSend() {
        try {
            this.m_dataSenderQ.add((Object)new SendRequest());
        }
        catch (InterruptedException iE) {
            Category log = ThreadCategory.getInstance(this.getClass());
            log.warn((Object)"Unable to queue datasender to the dsConsumer queue", (Throwable)iE);
        }
        catch (FifoQueueException qE) {
            Category log = ThreadCategory.getInstance(this.getClass());
            log.warn((Object)"Unable to queue datasender to the dsConsumer queue", (Throwable)qE);
        }
    }

    private class SendRequest
    implements Runnable {
        private SendRequest() {
        }

        public void run() {
            DataSender.this.sendData();
        }
    }
}

