/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.pollables;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.PollOutagesConfig;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.poller.Downtime;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.Parameter;
import org.opennms.netmgt.config.poller.Service;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.ServiceMonitor;
import org.opennms.netmgt.poller.pollables.LatencyStoringServiceMonitorAdaptor;
import org.opennms.netmgt.poller.pollables.PollConfig;
import org.opennms.netmgt.poller.pollables.PollableService;
import org.opennms.netmgt.scheduler.ScheduleInterval;
import org.opennms.netmgt.scheduler.Timer;

public class PollableServiceConfig
implements PollConfig,
ScheduleInterval {
    private PollerConfig m_pollerConfig;
    private PollOutagesConfig m_pollOutagesConfig;
    private PollableService m_service;
    private Map m_parameters = null;
    private Package m_pkg;
    private Timer m_timer;
    private Service m_configService;
    private ServiceMonitor m_serviceMonitor;

    public PollableServiceConfig(PollableService svc, PollerConfig pollerConfig, PollOutagesConfig pollOutagesConfig, Package pkg, Timer timer) {
        this.m_service = svc;
        this.m_pollerConfig = pollerConfig;
        this.m_pollOutagesConfig = pollOutagesConfig;
        this.m_pkg = pkg;
        this.m_timer = timer;
        this.m_configService = this.findService(pkg);
        ServiceMonitor monitor = this.getServiceMonitor();
        monitor.initialize(this.m_service);
    }

    private Service findService(Package pkg) {
        Enumeration esvc = this.m_pkg.enumerateService();
        while (esvc.hasMoreElements()) {
            Service s = (Service)esvc.nextElement();
            if (!s.getName().equalsIgnoreCase(this.m_service.getSvcName())) continue;
            return s;
        }
        throw new RuntimeException("Service name not part of package!");
    }

    public PollStatus poll() {
        try {
            ServiceMonitor monitor = this.getServiceMonitor();
            ThreadCategory.getInstance(this.getClass()).debug((Object)("Polling " + this.m_service + " using pkg " + this.m_pkg.getName()));
            PollStatus result = monitor.poll(this.m_service, this.getParameters());
            ThreadCategory.getInstance(this.getClass()).debug((Object)("Finish polling " + this.m_service + " using pkg " + this.m_pkg.getName() + " result =" + result));
            return result;
        }
        catch (Exception e) {
            ThreadCategory.getInstance(this.getClass()).error((Object)("Unexpected exception while polling " + this.m_service + ". Marking service as DOWN"), (Throwable)e);
            return PollStatus.down((String)("Unexception exception while polling " + this.m_service + ". " + e));
        }
        catch (Error e) {
            ThreadCategory.getInstance(this.getClass()).error((Object)("Unexpected error while polling " + this.m_service + ". Marking service as DOWN"), (Throwable)e);
            return PollStatus.down((String)("Unexception error while polling " + this.m_service + ". " + e));
        }
    }

    private ServiceMonitor getServiceMonitor() {
        if (this.m_serviceMonitor == null) {
            ServiceMonitor monitor = this.m_pollerConfig.getServiceMonitor(this.m_service.getSvcName());
            this.m_serviceMonitor = new LatencyStoringServiceMonitorAdaptor(monitor, this.m_pollerConfig, this.m_pkg);
        }
        return this.m_serviceMonitor;
    }

    public synchronized void refresh() {
        Package newPkg = this.m_pollerConfig.getPackage(this.m_pkg.getName());
        if (newPkg == null) {
            ThreadCategory.getInstance(PollableServiceConfig.class).warn((Object)("Package named " + this.m_pkg.getName() + " no longer exists."));
        }
        this.m_pkg = newPkg;
        this.m_configService = this.findService(this.m_pkg);
        this.m_parameters = null;
    }

    private synchronized Map getParameters() {
        if (this.m_parameters == null) {
            this.m_parameters = this.createPropertyMap(this.m_configService);
        }
        return this.m_parameters;
    }

    private Map createPropertyMap(Service svc) {
        Map<String, String> m = Collections.synchronizedMap(new TreeMap());
        Enumeration ep = svc.enumerateParameter();
        while (ep.hasMoreElements()) {
            Parameter p = (Parameter)ep.nextElement();
            String val = p.getValue();
            if (val == null) {
                val = p.getAnyObject() == null ? "" : p.getAnyObject().toString();
            }
            m.put(p.getKey(), val);
        }
        return m;
    }

    public long getCurrentTime() {
        return this.m_timer.getCurrentTime();
    }

    public long getInterval() {
        if (this.m_service.isDeleted()) {
            return -1L;
        }
        long when = this.m_configService.getInterval();
        if (this.m_service.getStatus().isDown()) {
            long downSince = this.m_timer.getCurrentTime() - this.m_service.getStatusChangeTime();
            boolean matched = false;
            Enumeration edowntime = this.m_pkg.enumerateDowntime();
            while (edowntime.hasMoreElements()) {
                Downtime dt = (Downtime)edowntime.nextElement();
                if (dt.getBegin() > downSince) continue;
                if (dt.getDelete() != null && (dt.getDelete().equals("yes") || dt.getDelete().equals("true"))) {
                    when = -1L;
                    matched = true;
                    continue;
                }
                if (dt.hasEnd() && dt.getEnd() > downSince) {
                    when = dt.getInterval();
                    matched = true;
                    continue;
                }
                when = dt.getInterval();
                matched = true;
            }
            if (!matched) {
                ThreadCategory.getInstance(this.getClass()).warn((Object)"getInterval: Could not locate downtime model, throwing runtime exception");
                throw new RuntimeException("Downtime model is invalid, cannot schedule service " + this.m_service);
            }
        }
        if (when < 0L) {
            this.m_service.sendDeleteEvent();
        }
        return when;
    }

    public boolean scheduledSuspension() {
        Iterator iter = this.m_pkg.getOutageCalendarCollection().iterator();
        long nodeId = this.m_service.getNodeId();
        while (iter.hasNext()) {
            String outageName = (String)iter.next();
            if (!this.m_pollOutagesConfig.isTimeInOutage(this.m_timer.getCurrentTime(), outageName) || !this.m_pollOutagesConfig.isNodeIdInOutage(nodeId, outageName) && !this.m_pollOutagesConfig.isInterfaceInOutage(this.m_service.getIpAddr(), outageName) && !this.m_pollOutagesConfig.isInterfaceInOutage("match-any", outageName)) continue;
            if (ThreadCategory.getInstance(this.getClass()).isDebugEnabled()) {
                ThreadCategory.getInstance(this.getClass()).debug((Object)("scheduledOutage: configured outage '" + outageName + "' applies, " + this.m_configService + " will not be polled."));
            }
            return true;
        }
        return false;
    }
}

