/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.PortUnreachableException;
import java.net.Socket;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Level;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;
import org.opennms.netmgt.poller.monitors.TimeoutTracker;

@Distributable
public final class TrivialTimeMonitor
extends IPv4Monitor {
    private static final String DEFAULT_PROTOCOL = "tcp";
    private static final int DEFAULT_PORT = 37;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;
    private static final int DEFAULT_ALLOWED_SKEW = 30;
    private static final int EPOCH_ADJ_FACTOR = 2085978496;
    private static final boolean DEFAULT_PERSIST_SKEW = false;

    public PollStatus poll(MonitoredService svc, Map parameters) {
        NetworkInterface iface = svc.getNetInterface();
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_IPV4 currently supported");
        }
        TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 3000);
        int port = ParameterMap.getKeyedInteger((Map)parameters, (String)"port", (int)37);
        InetAddress ipv4Addr = (InetAddress)iface.getAddress();
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("poll: address = " + ipv4Addr.getHostAddress() + ", port = " + port + ", " + tracker));
        }
        int allowedSkew = ParameterMap.getKeyedInteger((Map)parameters, (String)"allowed-skew", (int)30);
        boolean persistSkew = ParameterMap.getKeyedBoolean((Map)parameters, (String)"persist-skew", (boolean)false);
        PollStatus serviceStatus = PollStatus.unavailable();
        String protocol = ParameterMap.getKeyedString((Map)parameters, (String)"protocol", (String)DEFAULT_PROTOCOL).toLowerCase();
        if (!protocol.equalsIgnoreCase(DEFAULT_PROTOCOL) && !protocol.equalsIgnoreCase("udp")) {
            throw new IllegalArgumentException("Unsupported protocol, only TCP and UDP currently supported");
        }
        if (protocol.equalsIgnoreCase("udp")) {
            this.log().warn((Object)"UDP support is largely untested");
        }
        if (protocol.equalsIgnoreCase(DEFAULT_PROTOCOL)) {
            serviceStatus = this.pollTimeTcp(svc, parameters, serviceStatus, tracker, ipv4Addr, port, allowedSkew, persistSkew);
        } else if (protocol.equalsIgnoreCase("udp")) {
            serviceStatus = this.pollTimeUdp(svc, parameters, serviceStatus, tracker, ipv4Addr, port, allowedSkew, persistSkew);
        }
        return serviceStatus;
    }

    public void storeResult(PollStatus serviceStatus, Number skew, Double responseTime, boolean persistSkew) {
        LinkedHashMap<String, Number> skewProps = new LinkedHashMap<String, Number>();
        if (persistSkew) {
            skewProps.put("skew", skew);
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("persistSkew: Persisting time skew (value = " + skew + ") for this node"));
            }
        }
        skewProps.put("response-time", responseTime);
        serviceStatus.setProperties(skewProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PollStatus pollTimeTcp(MonitoredService svc, Map parameters, PollStatus serviceStatus, TimeoutTracker tracker, InetAddress ipv4Addr, int port, int allowedSkew, boolean persistSkew) {
        localTime = 0;
        remoteTime = 0;
        gotTime = false;
        tracker.reset();
        while (tracker.shouldRetry() != false) {
            block33: {
                if (gotTime != false) return serviceStatus;
                socket = null;
                try {
                    block34: {
                        tracker.startAttempt();
                        socket = new Socket();
                        socket.connect(new InetSocketAddress(ipv4Addr, port), tracker.getConnectionTimeout());
                        socket.setSoTimeout(tracker.getSoTimeout());
                        this.log().debug((Object)("Connected to host: " + ipv4Addr + " on TCP port: " + port));
                        timeBytes = new byte[4];
                        timeByteBuffer = ByteBuffer.wrap(timeBytes);
                        bytesRead = socket.getInputStream().read(timeBytes);
                        if (bytesRead == 4) break block34;
                        var18_21 = null;
                        ** GOTO lbl-1000
                    }
                    if (this.log().isDebugEnabled()) {
                        this.log().debug((Object)("pollTimeTcp: bytes read = " + bytesRead));
                    }
                    try {
                        remoteTime = timeByteBuffer.getInt();
                    }
                    catch (BufferUnderflowException bue) {
                        this.log().error((Object)"Encountered buffer underflow while reading time from remote socket.");
                        remoteTime = 0;
                        serviceStatus = PollStatus.unavailable((String)"Failed to read a valid time from remote host.");
                        var18_21 = null;
                        try {
                            if (socket != null) {
                                socket.close();
                            }
                        }
                        catch (IOException e) {
                            e.fillInStackTrace();
                            if (this.log().isDebugEnabled()) {
                                this.log().debug((Object)"pollTimeTcp: Error closing socket.", (Throwable)e);
                            }
                            break block33;
                        }
                    }
                    localTime = (int)(System.currentTimeMillis() / 1000L) - 2085978496;
                    gotTime = true;
                    serviceStatus = this.qualifyTime(remoteTime, localTime, allowedSkew, serviceStatus, tracker.elapsedTimeInMillis(), persistSkew);
                    ** GOTO lbl133
                }
                catch (NoRouteToHostException e) {
                    serviceStatus = this.logDown(Level.WARN, "No route to host exception for address " + ipv4Addr.getHostAddress(), e);
                    var18_21 = null;
                    try {}
                    catch (IOException e) {
                        e.fillInStackTrace();
                        if (this.log().isDebugEnabled()) {
                            this.log().debug((Object)"pollTimeTcp: Error closing socket.", (Throwable)e);
                        }
                        break block33;
                    }
                    if (socket != null) {
                        socket.close();
                    }
                    break block33;
                }
                catch (InterruptedIOException e) {
                    serviceStatus = this.logDown(Level.DEBUG, "did not connect to host with " + tracker);
                    var18_21 = null;
                    try {}
                    catch (IOException e) {
                        e.fillInStackTrace();
                        if (this.log().isDebugEnabled()) {
                            this.log().debug((Object)"pollTimeTcp: Error closing socket.", (Throwable)e);
                        }
                        break block33;
                    }
                    if (socket != null) {
                        socket.close();
                    }
                    break block33;
                }
                catch (ConnectException e) {
                    serviceStatus = this.logDown(Level.DEBUG, "Connection exception for address: " + ipv4Addr, e);
                    var18_21 = null;
                    try {}
                    catch (IOException e) {
                        e.fillInStackTrace();
                        if (this.log().isDebugEnabled()) {
                            this.log().debug((Object)"pollTimeTcp: Error closing socket.", (Throwable)e);
                        }
                        break block33;
                    }
                    if (socket != null) {
                        socket.close();
                    }
                    break block33;
                }
                catch (IOException e) {
                    serviceStatus = this.logDown(Level.DEBUG, "IOException while polling address: " + ipv4Addr, e);
                    var18_21 = null;
                    try {}
                    catch (IOException e) {
                        e.fillInStackTrace();
                        if (this.log().isDebugEnabled()) {
                            this.log().debug((Object)"pollTimeTcp: Error closing socket.", (Throwable)e);
                        }
                        break block33;
                    }
                    if (socket != null) {
                        socket.close();
                    }
                    break block33;
                }
                {
                    catch (Throwable var17_23) {
                        var18_21 = null;
                        ** try [egrp 3[TRYBLOCK] [21 : 425->438)] { 
lbl113:
                        // 1 sources

                        if (socket == null) throw var17_23;
                        socket.close();
                        throw var17_23;
lbl116:
                        // 1 sources

                        catch (IOException e) {
                            e.fillInStackTrace();
                            if (this.log().isDebugEnabled() == false) throw var17_23;
                            this.log().debug((Object)"pollTimeTcp: Error closing socket.", (Throwable)e);
                        }
                        throw var17_23;
                    }
lbl-1000:
                    // 1 sources

                    try {}
                    catch (IOException e) {
                        e.fillInStackTrace();
                        if (this.log().isDebugEnabled()) {
                            this.log().debug((Object)"pollTimeTcp: Error closing socket.", (Throwable)e);
                        }
                    }
                    if (socket != null) {
                        socket.close();
                    }
lbl133:
                    // 1 sources

                    var18_21 = null;
                    ** try [egrp 3[TRYBLOCK] [21 : 425->438)] { 
lbl135:
                    // 1 sources

                    if (socket != null) {
                        socket.close();
                    }
lbl139:
                    // 1 sources

                    catch (IOException e) {}
                    e.fillInStackTrace();
                    if (!this.log().isDebugEnabled()) break block33;
                    this.log().debug((Object)"pollTimeTcp: Error closing socket.", (Throwable)e);
                }
            }
            tracker.nextAttempt();
        }
        return serviceStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PollStatus pollTimeUdp(MonitoredService svc, Map parameters, PollStatus serviceStatus, TimeoutTracker tracker, InetAddress ipv4Addr, int port, int allowedSkew, boolean persistSkew) {
        int localTime = 0;
        int remoteTime = 0;
        boolean gotTime = false;
        tracker.reset();
        while (tracker.shouldRetry() && !gotTime) {
            block20: {
                Object var19_22;
                DatagramSocket socket = null;
                try {
                    try {
                        tracker.startAttempt();
                        socket = new DatagramSocket();
                        socket.setSoTimeout(tracker.getSoTimeout());
                        this.log().debug((Object)("Requesting time from host: " + ipv4Addr + " on UDP port: " + port));
                        socket.send(new DatagramPacket(new byte[0], 0, ipv4Addr, port));
                        byte[] timeBytes = new byte[4];
                        ByteBuffer timeByteBuffer = ByteBuffer.wrap(timeBytes);
                        DatagramPacket timePacket = new DatagramPacket(timeBytes, timeBytes.length, ipv4Addr, port);
                        socket.receive(timePacket);
                        int bytesRead = timePacket.getLength();
                        if (bytesRead != 4) {
                            var19_22 = null;
                            if (socket != null) {
                                socket.close();
                            }
                            break block20;
                        }
                        if (this.log().isDebugEnabled()) {
                            this.log().debug((Object)("pollTimeUdp: bytes read = " + bytesRead));
                        }
                        try {
                            remoteTime = timeByteBuffer.getInt();
                        }
                        catch (BufferUnderflowException bue) {
                            this.log().error((Object)"Encountered buffer underflow while reading time from remote socket.");
                            remoteTime = 0;
                            serviceStatus = PollStatus.unavailable((String)"Failed to read a valid time from remote host.");
                            var19_22 = null;
                            if (socket != null) {
                                socket.close();
                            }
                            break block20;
                        }
                        localTime = (int)(System.currentTimeMillis() / 1000L) - 2085978496;
                        gotTime = true;
                        serviceStatus = this.qualifyTime(remoteTime, localTime, allowedSkew, serviceStatus, tracker.elapsedTimeInMillis(), persistSkew);
                    }
                    catch (PortUnreachableException e) {
                        serviceStatus = this.logDown(Level.DEBUG, "Port unreachable exception for address " + ipv4Addr.getHostAddress(), e);
                        var19_22 = null;
                        if (socket != null) {
                            socket.close();
                        }
                        break block20;
                    }
                    catch (NoRouteToHostException e) {
                        serviceStatus = this.logDown(Level.WARN, "No route to host exception for address " + ipv4Addr.getHostAddress(), e);
                        var19_22 = null;
                        if (socket != null) {
                            socket.close();
                        }
                        break block20;
                    }
                    catch (InterruptedIOException e) {
                        serviceStatus = this.logDown(Level.DEBUG, "did not connect to host with " + tracker);
                        var19_22 = null;
                        if (socket != null) {
                            socket.close();
                        }
                        break block20;
                    }
                    catch (IOException e) {
                        serviceStatus = this.logDown(Level.DEBUG, "IOException while polling address: " + ipv4Addr, e);
                        var19_22 = null;
                        if (socket != null) {
                            socket.close();
                        }
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    var19_22 = null;
                    if (socket != null) {
                        socket.close();
                    }
                    throw throwable;
                }
                var19_22 = null;
                if (socket != null) {
                    socket.close();
                }
            }
            tracker.nextAttempt();
        }
        return serviceStatus;
    }

    private PollStatus qualifyTime(int remoteTime, int localTime, int allowedSkew, PollStatus serviceStatus, double responseTime, boolean persistSkew) {
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("qualifyTime: checking remote time " + remoteTime + " against local time " + localTime + " with max skew of " + allowedSkew));
        }
        if (localTime - remoteTime > allowedSkew || remoteTime - localTime > allowedSkew) {
            serviceStatus = this.logDown(Level.DEBUG, "Remote time is " + (localTime > remoteTime ? "" + (localTime - remoteTime) + " seconds slow" : "" + (remoteTime - localTime) + " seconds fast"));
        }
        serviceStatus = localTime > remoteTime && localTime - remoteTime > allowedSkew ? this.logDown(Level.DEBUG, "Remote time is " + (localTime - remoteTime) + " seconds behind local, more than the allowable " + allowedSkew) : (remoteTime > localTime && remoteTime - localTime > allowedSkew ? this.logDown(Level.DEBUG, "Remote time is " + (remoteTime - localTime) + " seconds ahead of local, more than the allowable " + allowedSkew) : PollStatus.available());
        this.storeResult(serviceStatus, remoteTime - localTime, responseTime, persistSkew);
        return serviceStatus;
    }
}

