/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Level;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.PropertiesUtils;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.monitors.SnmpMonitorStrategy;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.utils.ParameterMap;

@Distributable(value={DistributionContext.DAEMON})
public class SnmpMonitor
extends SnmpMonitorStrategy {
    private static final String SERVICE_NAME = "SNMP";
    private static final String DEFAULT_OBJECT_IDENTIFIER = ".1.3.6.1.2.1.1.2.0";
    static final String SNMP_AGENTCONFIG_KEY = "org.opennms.netmgt.snmp.SnmpAgentConfig";
    private static final String DEFAULT_REASON_TEMPLATE = "Observed value '${observedValue}' does not meet criteria '${operator} ${operand}'";

    public String serviceName() {
        return SERVICE_NAME;
    }

    public void initialize(Map parameters) {
        try {
            SnmpPeerFactory.init();
        }
        catch (MarshalException ex) {
            this.log().fatal((Object)"initialize: Failed to load SNMP configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (ValidationException ex) {
            this.log().fatal((Object)"initialize: Failed to load SNMP configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (IOException ex) {
            this.log().fatal((Object)"initialize: Failed to load SNMP configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
    }

    public void initialize(MonitoredService svc) {
        NetworkInterface iface = svc.getNetInterface();
        super.initialize(svc);
        InetAddress ipAddr = (InetAddress)iface.getAddress();
        SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(ipAddr);
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("initialize: SnmpAgentConfig address: " + agentConfig));
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("initialize: setting SNMP peer attribute for interface " + ipAddr.getHostAddress()));
        }
        iface.setAttribute(SNMP_AGENTCONFIG_KEY, agentConfig);
        this.log().debug((Object)("initialize: interface: " + agentConfig.getAddress() + " initialized."));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PollStatus poll(MonitoredService svc, Map parameters) {
        NetworkInterface iface = svc.getNetInterface();
        PollStatus status = PollStatus.unavailable();
        InetAddress ipaddr = (InetAddress)iface.getAddress();
        SnmpAgentConfig agentConfig = (SnmpAgentConfig)iface.getAttribute(SNMP_AGENTCONFIG_KEY);
        if (agentConfig == null) {
            throw new RuntimeException("SnmpAgentConfig object not available for interface " + ipaddr);
        }
        String oid = ParameterMap.getKeyedString(parameters, "oid", DEFAULT_OBJECT_IDENTIFIER);
        String operator = ParameterMap.getKeyedString(parameters, "operator", null);
        String operand = ParameterMap.getKeyedString(parameters, "operand", null);
        String walkstr = ParameterMap.getKeyedString(parameters, "walk", "false");
        String matchstr = ParameterMap.getKeyedString(parameters, "match-all", "true");
        int countMin = ParameterMap.getKeyedInteger(parameters, "minimum", 0);
        int countMax = ParameterMap.getKeyedInteger(parameters, "maximum", 0);
        String reasonTemplate = ParameterMap.getKeyedString(parameters, "reason-template", DEFAULT_REASON_TEMPLATE);
        agentConfig.setTimeout(ParameterMap.getKeyedInteger(parameters, "timeout", agentConfig.getTimeout()));
        agentConfig.setRetries(ParameterMap.getKeyedInteger(parameters, "retry", ParameterMap.getKeyedInteger(parameters, "retries", agentConfig.getRetries())));
        agentConfig.setPort(ParameterMap.getKeyedInteger(parameters, "port", agentConfig.getPort()));
        Properties svcParams = new Properties();
        svcParams.setProperty("oid", oid);
        svcParams.setProperty("operator", String.valueOf(operator));
        svcParams.setProperty("operand", String.valueOf(operand));
        svcParams.setProperty("walk", walkstr);
        svcParams.setProperty("matchAll", matchstr);
        svcParams.setProperty("minimum", String.valueOf(countMin));
        svcParams.setProperty("maximum", String.valueOf(countMax));
        svcParams.setProperty("timeout", String.valueOf(agentConfig.getTimeout()));
        svcParams.setProperty("retry", String.valueOf(agentConfig.getRetries()));
        svcParams.setProperty("retries", svcParams.getProperty("retry"));
        svcParams.setProperty("ipaddr", ipaddr.getHostAddress());
        svcParams.setProperty("port", String.valueOf(agentConfig.getPort()));
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("poll: service= SNMP address= " + agentConfig));
        }
        try {
            SnmpValue result;
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("SnmpMonitor.poll: SnmpAgentConfig address: " + agentConfig));
            }
            SnmpObjId snmpObjectId = SnmpObjId.get((String)oid);
            if ("true".equals(walkstr)) {
                if (DEFAULT_REASON_TEMPLATE.equals(reasonTemplate)) {
                    reasonTemplate = "SNMP poll failed, addr=${ipaddr} oid=${oid}";
                }
                List results = SnmpUtils.getColumns((SnmpAgentConfig)agentConfig, (String)"snmpPoller", (SnmpObjId)snmpObjectId);
                Iterator i$ = results.iterator();
                while (i$.hasNext()) {
                    SnmpValue result2 = (SnmpValue)i$.next();
                    svcParams.setProperty("observedValue", result2.toString());
                    if (result2 == null) continue;
                    this.log().debug((Object)("poll: SNMPwalk poll succeeded, addr=" + ipaddr.getHostAddress() + " oid=" + oid + " value=" + result2));
                    if (this.meetsCriteria(result2, operator, operand)) {
                        status = PollStatus.available();
                        if (!"false".equals(matchstr)) continue;
                        return status;
                    }
                    if ("true".equals(matchstr)) return this.logDown(Level.DEBUG, PropertiesUtils.substitute((String)reasonTemplate, (Properties)svcParams));
                }
                return status;
            }
            if ("count".equals(matchstr)) {
                if (DEFAULT_REASON_TEMPLATE.equals(reasonTemplate)) {
                    reasonTemplate = "Value: ${matchCount} outside of range Min: ${minimum} to Max: ${maximum}";
                }
                int matchCount = 0;
                List results = SnmpUtils.getColumns((SnmpAgentConfig)agentConfig, (String)"snmpPoller", (SnmpObjId)snmpObjectId);
                for (SnmpValue result3 : results) {
                    if (result3 == null) continue;
                    this.log().debug((Object)("poll: SNMPwalk poll succeeded, addr=" + ipaddr.getHostAddress() + " oid=" + oid + " value=" + result3));
                    if (!this.meetsCriteria(result3, operator, operand)) continue;
                    ++matchCount;
                }
                svcParams.setProperty("matchCount", String.valueOf(matchCount));
                this.log().debug((Object)("poll: SNMPwalk count succeeded, total=" + matchCount + " min=" + countMin + " max=" + countMax));
                if (matchCount >= countMax) return this.logDown(Level.DEBUG, PropertiesUtils.substitute((String)reasonTemplate, (Properties)svcParams));
                if (matchCount <= countMin) return this.logDown(Level.DEBUG, PropertiesUtils.substitute((String)reasonTemplate, (Properties)svcParams));
                return PollStatus.available();
            }
            if (DEFAULT_REASON_TEMPLATE.equals(reasonTemplate)) {
                reasonTemplate = operator != null ? DEFAULT_REASON_TEMPLATE : "Observed value '${observedValue}' was null";
            }
            if ((result = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)snmpObjectId)) == null) return this.logDown(Level.DEBUG, "SNMP poll failed, addr=" + ipaddr.getHostAddress() + " oid=" + oid);
            svcParams.setProperty("observedValue", result.toString());
            this.log().debug((Object)("poll: SNMP poll succeeded, addr=" + ipaddr.getHostAddress() + " oid=" + oid + " value=" + result));
            if (!this.meetsCriteria(result, operator, operand)) return PollStatus.unavailable((String)PropertiesUtils.substitute((String)reasonTemplate, (Properties)svcParams));
            return PollStatus.available();
        }
        catch (NumberFormatException e) {
            return this.logDown(Level.ERROR, "Number operator used on a non-number " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            return this.logDown(Level.ERROR, "Invalid Snmp Criteria: " + e.getMessage());
        }
        catch (Throwable t) {
            return this.logDown(Level.WARN, "Unexpected exception during SNMP poll of interface " + ipaddr.getHostAddress(), t);
        }
    }
}

