/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.InetAddress;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Level;
import org.opennms.netmgt.DBTools;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;
import org.opennms.netmgt.poller.monitors.TimeoutTracker;
import org.opennms.netmgt.utils.ParameterMap;

@Distributable
public class JDBCMonitor
extends IPv4Monitor {
    public static final int DEFAULT_TIMEOUT = 3000;
    public static final int DEFAULT_RETRY = 0;

    public JDBCMonitor() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.log().info((Object)"JDBCmonitor class loaded");
    }

    public void initialize(Map parameters) {
        super.initialize(parameters);
        this.log().debug((Object)"Calling init");
    }

    public void release() {
        this.log().debug((Object)"Shuting down plugin");
    }

    public void initialize(MonitoredService svc) {
        super.initialize(svc);
        this.log().debug((Object)"initialize");
    }

    public void release(MonitoredService svc) {
        this.log().debug((Object)"Shuting down plugin");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService svc, Map parameters) {
        NetworkInterface iface = svc.getNetInterface();
        PollStatus status = PollStatus.unavailable();
        Driver driver = null;
        Connection con = null;
        Statement statement = null;
        ResultSet resultset = null;
        if (iface.getType() != 1) {
            this.log().error((Object)"Unsupported interface type, only TYPE_IPV4 currently supported");
            throw new NetworkInterfaceNotSupportedException(this.getClass().getName() + ": Unsupported interface type, only TYPE_IPV4 currently supported");
        }
        if (parameters == null) {
            throw new NullPointerException("parameter cannot be null");
        }
        try {
            String driverClass = ParameterMap.getKeyedString(parameters, "driver", "com.sybase.jdbc2.jdbc.SybDriver");
            driver = (Driver)Class.forName(driverClass).newInstance();
        }
        catch (Exception exp) {
            throw new RuntimeException("Unable to load driver class: " + exp.toString(), exp);
        }
        this.log().info((Object)"Loaded JDBC driver");
        InetAddress ipv4Addr = (InetAddress)iface.getAddress();
        String url = null;
        url = DBTools.constructUrl(ParameterMap.getKeyedString(parameters, "url", "jdbc:sybase:Tds:OPENNMS_JDBC_HOSTNAME/tempdb"), ipv4Addr.getCanonicalHostName());
        this.log().debug((Object)("JDBC url: " + url));
        TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 3000);
        String db_user = ParameterMap.getKeyedString(parameters, "user", "sa");
        String db_pass = ParameterMap.getKeyedString(parameters, "password", "");
        Properties props = new Properties();
        props.setProperty("user", db_user);
        props.setProperty("password", db_pass);
        props.setProperty("timeout", String.valueOf(tracker.getTimeoutInSeconds()));
        tracker.reset();
        while (tracker.shouldRetry()) {
            Object var18_18;
            try {
                try {
                    con = driver.connect(url, props);
                    status = PollStatus.unresponsive();
                    if (con != null) {
                        this.log().debug((Object)"JDBC Connection Established");
                        tracker.startAttempt();
                        status = this.checkDatabaseStatus(con, parameters);
                        if (status.isAvailable()) {
                            double responseTime = tracker.elapsedTimeInMillis();
                            status = PollStatus.available((Double)responseTime);
                            this.log().debug((Object)("JDBC service is AVAILABLE on: " + ipv4Addr.getCanonicalHostName()));
                            this.log().debug((Object)("poll: responseTime= " + responseTime + "ms"));
                            var18_18 = null;
                            this.closeResultSet(resultset);
                            this.closeStmt(statement);
                            this.closeConnection(con);
                            break;
                        }
                    }
                    var18_18 = null;
                    this.closeResultSet(resultset);
                    this.closeStmt(statement);
                    this.closeConnection(con);
                }
                catch (SQLException sqlEx) {
                    status = this.logDown(Level.INFO, "JDBC service is not responding on: " + ipv4Addr.getCanonicalHostName() + ", " + sqlEx.getSQLState() + ", " + sqlEx.toString(), sqlEx);
                    var18_18 = null;
                    this.closeResultSet(resultset);
                    this.closeStmt(statement);
                    this.closeConnection(con);
                }
            }
            catch (Throwable throwable) {
                var18_18 = null;
                this.closeResultSet(resultset);
                this.closeStmt(statement);
                this.closeConnection(con);
                throw throwable;
            }
            tracker.nextAttempt();
        }
        return status;
    }

    private void closeConnection(Connection con) {
        if (con == null) {
            return;
        }
        try {
            con.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void closeStmt(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void closeResultSet(ResultSet resultset) {
        if (resultset != null) {
            try {
                resultset.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus checkDatabaseStatus(Connection con, Map parameters) {
        PollStatus status = PollStatus.unavailable((String)"Unable to retrieve database catalogs");
        ResultSet resultset = null;
        try {
            block5: {
                try {
                    status = PollStatus.unresponsive();
                    DatabaseMetaData metadata = con.getMetaData();
                    resultset = metadata.getCatalogs();
                    while (resultset.next()) {
                        resultset.getString(1);
                    }
                    if (resultset == null) break block5;
                    status = PollStatus.available();
                }
                catch (SQLException sqlEx) {
                    status = this.logDown(Level.DEBUG, "JDBC service failed to retrieve metadata: " + sqlEx.getSQLState() + ", " + sqlEx.toString(), sqlEx);
                    Object var7_8 = null;
                    this.closeResultSet(resultset);
                }
            }
            Object var7_7 = null;
            this.closeResultSet(resultset);
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.closeResultSet(resultset);
            throw throwable;
        }
        return status;
    }
}

