/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.util.Map;
import org.apache.log4j.Level;
import org.opennms.netmgt.capsd.plugins.FtpResponse;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;
import org.opennms.netmgt.poller.monitors.TimeoutTracker;
import org.opennms.netmgt.utils.ParameterMap;

@Distributable
public final class FtpMonitor
extends IPv4Monitor {
    private static final int DEFAULT_PORT = 21;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;
    private static final String FTP_ERROR_530_TEXT = "User not logged in. Please login with USER and PASS first";
    private static final String FTP_ERROR_530_TEXT2 = "Not logged in.";
    private static final String FTP_ERROR_425_TEXT = "425 Session is disconnected.";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public PollStatus poll(MonitoredService svc, Map parameters) {
        NetworkInterface iface = svc.getNetInterface();
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_IPV4 currently supported");
        }
        TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 3000);
        int port = ParameterMap.getKeyedInteger(parameters, "port", 21);
        String userid = ParameterMap.getKeyedString(parameters, "userid", null);
        String password = ParameterMap.getKeyedString(parameters, "password", null);
        InetAddress ipv4Addr = (InetAddress)iface.getAddress();
        PollStatus serviceStatus = PollStatus.unavailable();
        tracker.reset();
        while (tracker.shouldRetry() && !serviceStatus.isAvailable()) {
            block37: {
                Socket socket;
                block36: {
                    if (this.log().isDebugEnabled()) {
                        this.log().debug((Object)("FtpMonitor.poll: Polling interface: " + ipv4Addr.getHostAddress() + tracker));
                    }
                    socket = null;
                    tracker.startAttempt();
                    socket = new Socket();
                    socket.connect(new InetSocketAddress(ipv4Addr, port), tracker.getConnectionTimeout());
                    socket.setSoTimeout(tracker.getSoTimeout());
                    this.log().debug((Object)("FtpMonitor: connected to host: " + ipv4Addr + " on port: " + port));
                    serviceStatus = PollStatus.unresponsive();
                    BufferedReader lineRdr = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                    FtpResponse bannerResponse = FtpResponse.readResponse(lineRdr);
                    if (bannerResponse.isSuccess()) {
                        boolean loggedInSuccessfully = false;
                        this.log().debug((Object)"FtpMonitor: Banner response successful.");
                        if (userid == null || userid.length() == 0 || password == null || password.length() == 0) {
                            loggedInSuccessfully = true;
                        } else {
                            FtpResponse.sendCommand(socket, "USER " + userid);
                            FtpResponse userResponse = FtpResponse.readResponse(lineRdr);
                            if (userResponse.isSuccess() || userResponse.isIntermediate()) {
                                this.log().debug((Object)"FtpMonitor: User response successful.");
                                FtpResponse.sendCommand(socket, "PASS " + password);
                                FtpResponse passResponse = FtpResponse.readResponse(lineRdr);
                                if (passResponse.isSuccess()) {
                                    if (this.log().isDebugEnabled()) {
                                        this.log().debug((Object)("FtpMonitor.poll: Login successful, parsed return code: " + passResponse.getCode()));
                                    }
                                    loggedInSuccessfully = true;
                                } else {
                                    if (this.log().isDebugEnabled()) {
                                        this.log().debug((Object)("FtpMonitor.poll: Login failed, parsed return code: " + passResponse.getCode() + ", full response: " + passResponse.toString()));
                                    }
                                    loggedInSuccessfully = false;
                                }
                            }
                        }
                        double responseTime = tracker.elapsedTimeInMillis();
                        if (loggedInSuccessfully) {
                            FtpResponse.sendCommand(socket, "QUIT");
                            FtpResponse quitResponse = FtpResponse.readResponse(lineRdr);
                            if (quitResponse.isSuccess() || quitResponse.getCode() == 530 && (quitResponse.responseContains(FTP_ERROR_530_TEXT) || quitResponse.responseContains(FTP_ERROR_530_TEXT2)) || quitResponse.getCode() == 425 && quitResponse.responseContains(FTP_ERROR_425_TEXT)) {
                                serviceStatus = PollStatus.available((Double)responseTime);
                            }
                        }
                    }
                    if (serviceStatus.isAvailable()) break block36;
                    serviceStatus = PollStatus.unavailable();
                }
                Object var18_23 = null;
                try {
                    if (socket != null) {
                        socket.close();
                    }
                    break block37;
                }
                catch (IOException e2) {
                    this.log().debug((Object)("FtpMonitor.poll: Error closing socket: " + e2), (Throwable)e2);
                }
                break block37;
                {
                    catch (NumberFormatException e) {
                        serviceStatus = this.logDown(Level.DEBUG, "NumberFormatException while polling address: " + ipv4Addr, e);
                        var18_23 = null;
                        try {
                            if (socket != null) {
                                socket.close();
                            }
                            break block37;
                        }
                        catch (IOException e2) {
                            this.log().debug((Object)("FtpMonitor.poll: Error closing socket: " + e2), (Throwable)e2);
                        }
                        break block37;
                    }
                    catch (NoRouteToHostException e) {
                        serviceStatus = this.logDown(Level.WARN, "No route to host exception for address: " + ipv4Addr, e);
                        var18_23 = null;
                        try {
                            if (socket != null) {
                                socket.close();
                            }
                            break block37;
                        }
                        catch (IOException e2) {
                            this.log().debug((Object)("FtpMonitor.poll: Error closing socket: " + e2), (Throwable)e2);
                        }
                        break block37;
                    }
                    catch (InterruptedIOException e) {
                        serviceStatus = this.logDown(Level.DEBUG, "did not connect to host with " + tracker);
                        var18_23 = null;
                        try {
                            if (socket != null) {
                                socket.close();
                            }
                            break block37;
                        }
                        catch (IOException e2) {
                            this.log().debug((Object)("FtpMonitor.poll: Error closing socket: " + e2), (Throwable)e2);
                        }
                        break block37;
                    }
                    catch (ConnectException e) {
                        serviceStatus = this.logDown(Level.DEBUG, "Connection exception for address: " + ipv4Addr, e);
                        var18_23 = null;
                        try {
                            if (socket != null) {
                                socket.close();
                            }
                            break block37;
                        }
                        catch (IOException e2) {
                            this.log().debug((Object)("FtpMonitor.poll: Error closing socket: " + e2), (Throwable)e2);
                        }
                        break block37;
                    }
                    catch (IOException e) {
                        serviceStatus = this.logDown(Level.DEBUG, "IOException while polling address: " + ipv4Addr, e);
                        var18_23 = null;
                        try {
                            if (socket != null) {
                                socket.close();
                            }
                            break block37;
                        }
                        catch (IOException e2) {
                            this.log().debug((Object)("FtpMonitor.poll: Error closing socket: " + e2), (Throwable)e2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    var18_23 = null;
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                    }
                    catch (IOException e2) {
                        this.log().debug((Object)("FtpMonitor.poll: Error closing socket: " + e2), (Throwable)e2);
                    }
                    throw throwable;
                }
            }
            tracker.nextAttempt();
        }
        return serviceStatus;
    }
}

