/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import org.apache.log4j.Category;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.linkd.DbStpNodeEntry;

public class DbStpInterfaceEntry {
    static final char STATUS_ACTIVE = 'A';
    static final char STATUS_NOT_POLLED = 'N';
    static final char STATUS_DELETE = 'D';
    static final char STATUS_UNKNOWN = 'K';
    static final int STP_PORT_DISABLED = 1;
    static final int STP_PORT_BLOCKING = 2;
    static final int STP_PORT_LISTENING = 3;
    static final int STP_PORT_LEARNING = 4;
    static final int STP_PORT_FORWARDING = 5;
    static final int STP_PORT_BROKEN = 6;
    int m_nodeId;
    int m_bridgeport;
    int m_ifindex;
    int m_stpportstate;
    int m_stpportpathcost;
    String m_stpportdesignatedroot;
    int m_stpportdesignatedcost;
    String m_stpportdesignatedbridge;
    String m_stpportdesignatedport;
    int m_stpportvlan;
    char m_status = (char)75;
    Timestamp m_lastPollTime;
    private static final String SQL_LOAD_STPINTERFACE = "SELECT ifindex,stpportstate,stpportpathcost,stpportdesignatedroot,stpportdesignatedcost,stpportdesignatedbridge,stpportdesignatedport,status,lastPollTime FROM stpinterface WHERE nodeid = ? AND bridgeport = ? AND stpvlan = ? ";
    private boolean m_fromDb;
    private int m_changed;
    private static final int CHANGED_IFINDEX = 1;
    private static final int CHANGED_STP_PORT_STATE = 2;
    private static final int CHANGED_STP_PORT_PATH_COST = 4;
    private static final int CHANGED_STP_PORT_DES_ROOT = 8;
    private static final int CHANGED_STP_PORT_DES_COST = 16;
    private static final int CHANGED_STP_PORT_DES_BRIDGE = 32;
    private static final int CHANGED_STP_PORT_DES_PORT = 64;
    private static final int CHANGED_STATUS = 128;
    private static final int CHANGED_POLLTIME = 256;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insert(Connection c) throws SQLException {
        if (this.m_fromDb) {
            throw new IllegalStateException("The record already exists in the database");
        }
        Category log = ThreadCategory.getInstance(this.getClass());
        StringBuffer names = new StringBuffer("INSERT INTO StpInterface (nodeid,bridgeport,stpvlan");
        StringBuffer values = new StringBuffer("?,?,?");
        if ((this.m_changed & 1) == 1) {
            values.append(",?");
            names.append(",ifindex");
        }
        if ((this.m_changed & 2) == 2) {
            values.append(",?");
            names.append(",stpportstate");
        }
        if ((this.m_changed & 4) == 4) {
            values.append(",?");
            names.append(",stpportpathcost");
        }
        if ((this.m_changed & 8) == 8) {
            values.append(",?");
            names.append(",stpportdesignatedroot");
        }
        if ((this.m_changed & 0x10) == 16) {
            values.append(",?");
            names.append(",stpportdesignatedcost");
        }
        if ((this.m_changed & 0x20) == 32) {
            values.append(",?");
            names.append(",stpportdesignatedbridge");
        }
        if ((this.m_changed & 0x40) == 64) {
            values.append(",?");
            names.append(",stpportdesignatedport");
        }
        if ((this.m_changed & 0x80) == 128) {
            values.append(",?");
            names.append(",status");
        }
        if ((this.m_changed & 0x100) == 256) {
            values.append(",?");
            names.append(",lastpolltime");
        }
        names.append(") VALUES (").append(values).append(')');
        if (log.isDebugEnabled()) {
            log.debug((Object)("StpInterfaceEntry.insert: SQL insert statment = " + names.toString()));
        }
        DBUtils d = new DBUtils(this.getClass());
        try {
            PreparedStatement stmt = c.prepareStatement(names.toString());
            d.watch((Object)stmt);
            int ndx = 1;
            stmt.setInt(ndx++, this.m_nodeId);
            stmt.setInt(ndx++, this.m_bridgeport);
            stmt.setInt(ndx++, this.m_stpportvlan);
            if ((this.m_changed & 1) == 1) {
                stmt.setInt(ndx++, this.m_ifindex);
            }
            if ((this.m_changed & 2) == 2) {
                stmt.setInt(ndx++, this.m_stpportstate);
            }
            if ((this.m_changed & 4) == 4) {
                stmt.setInt(ndx++, this.m_stpportpathcost);
            }
            if ((this.m_changed & 8) == 8) {
                stmt.setString(ndx++, this.m_stpportdesignatedroot);
            }
            if ((this.m_changed & 0x10) == 16) {
                stmt.setInt(ndx++, this.m_stpportdesignatedcost);
            }
            if ((this.m_changed & 0x20) == 32) {
                stmt.setString(ndx++, this.m_stpportdesignatedbridge);
            }
            if ((this.m_changed & 0x40) == 64) {
                stmt.setString(ndx++, this.m_stpportdesignatedport);
            }
            if ((this.m_changed & 0x80) == 128) {
                stmt.setString(ndx++, new String(new char[]{this.m_status}));
            }
            if ((this.m_changed & 0x100) == 256) {
                stmt.setTimestamp(ndx++, this.m_lastPollTime);
            }
            int rc = stmt.executeUpdate();
            if (log.isDebugEnabled()) {
                log.debug((Object)("StpInterfaceEntry.insert: row " + rc));
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            d.cleanUp();
            throw throwable;
        }
        d.cleanUp();
        this.m_fromDb = true;
        this.m_changed = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(Connection c) throws SQLException {
        if (!this.m_fromDb) {
            throw new IllegalStateException("The record does not exists in the database");
        }
        Category log = ThreadCategory.getInstance(this.getClass());
        StringBuffer sqlText = new StringBuffer("UPDATE StpInterface SET ");
        int comma = 32;
        if ((this.m_changed & 1) == 1) {
            sqlText.append((char)comma).append("ifindex = ?");
            comma = 44;
        }
        if ((this.m_changed & 2) == 2) {
            sqlText.append((char)comma).append("stpportstate = ?");
            comma = 44;
        }
        if ((this.m_changed & 4) == 4) {
            sqlText.append((char)comma).append("stpportpathcost = ?");
            comma = 44;
        }
        if ((this.m_changed & 8) == 8) {
            sqlText.append((char)comma).append("stpportdesignatedroot = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x10) == 16) {
            sqlText.append((char)comma).append("stpportdesignatedcost = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x20) == 32) {
            sqlText.append((char)comma).append("stpportdesignatedbridge = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x40) == 64) {
            sqlText.append((char)comma).append("stpportdesignatedport = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x80) == 128) {
            sqlText.append((char)comma).append("status = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x100) == 256) {
            sqlText.append((char)comma).append("lastpolltime = ?");
            comma = 44;
        }
        sqlText.append(" WHERE nodeid = ? AND bridgeport = ? AND stpvlan = ? ");
        if (log.isDebugEnabled()) {
            log.debug((Object)("StpInterfaceEntry.update: SQL statement " + sqlText.toString()));
        }
        DBUtils d = new DBUtils(this.getClass());
        try {
            PreparedStatement stmt = c.prepareStatement(sqlText.toString());
            d.watch((Object)stmt);
            int ndx = 1;
            if ((this.m_changed & 1) == 1) {
                stmt.setInt(ndx++, this.m_ifindex);
            }
            if ((this.m_changed & 2) == 2) {
                stmt.setInt(ndx++, this.m_stpportstate);
            }
            if ((this.m_changed & 4) == 4) {
                stmt.setInt(ndx++, this.m_stpportpathcost);
            }
            if ((this.m_changed & 8) == 8) {
                stmt.setString(ndx++, this.m_stpportdesignatedroot);
            }
            if ((this.m_changed & 0x10) == 16) {
                stmt.setInt(ndx++, this.m_stpportdesignatedcost);
            }
            if ((this.m_changed & 0x20) == 32) {
                stmt.setString(ndx++, this.m_stpportdesignatedbridge);
            }
            if ((this.m_changed & 0x40) == 64) {
                stmt.setString(ndx++, this.m_stpportdesignatedport);
            }
            if ((this.m_changed & 0x80) == 128) {
                stmt.setString(ndx++, new String(new char[]{this.m_status}));
            }
            if ((this.m_changed & 0x100) == 256) {
                stmt.setTimestamp(ndx++, this.m_lastPollTime);
            }
            stmt.setInt(ndx++, this.m_nodeId);
            stmt.setInt(ndx++, this.m_bridgeport);
            stmt.setInt(ndx++, this.m_stpportvlan);
            int rc = stmt.executeUpdate();
            if (log.isDebugEnabled()) {
                log.debug((Object)("StpInterfaceEntry.update: row " + rc));
            }
            stmt.close();
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            d.cleanUp();
            throw throwable;
        }
        d.cleanUp();
        this.m_changed = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean load(Connection c) throws SQLException {
        String str;
        ResultSet rset;
        DBUtils d;
        Category log;
        block13: {
            boolean bl;
            if (!this.m_fromDb) {
                throw new IllegalStateException("The record does not exists in the database");
            }
            log = ThreadCategory.getInstance(this.getClass());
            PreparedStatement stmt = null;
            d = new DBUtils(this.getClass());
            try {
                stmt = c.prepareStatement(SQL_LOAD_STPINTERFACE);
                d.watch((Object)stmt);
                stmt.setInt(1, this.m_nodeId);
                stmt.setInt(2, this.m_bridgeport);
                stmt.setInt(3, this.m_stpportvlan);
                rset = stmt.executeQuery();
                d.watch((Object)rset);
                if (rset.next()) break block13;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"StpInterfaceEntry.load: no result found");
                }
                bl = false;
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                d.cleanUp();
                throw throwable;
            }
            d.cleanUp();
            return bl;
        }
        int ndx = 1;
        this.m_ifindex = rset.getInt(ndx++);
        if (rset.wasNull()) {
            this.m_ifindex = -1;
        }
        this.m_stpportstate = rset.getInt(ndx++);
        if (rset.wasNull()) {
            this.m_stpportstate = -1;
        }
        this.m_stpportpathcost = rset.getInt(ndx++);
        if (rset.wasNull()) {
            this.m_stpportpathcost = -1;
        }
        this.m_stpportdesignatedroot = rset.getString(ndx++);
        if (rset.wasNull()) {
            this.m_stpportdesignatedroot = null;
        }
        this.m_stpportdesignatedcost = rset.getInt(ndx++);
        if (rset.wasNull()) {
            this.m_stpportdesignatedcost = -1;
        }
        this.m_stpportdesignatedbridge = rset.getString(ndx++);
        if (rset.wasNull()) {
            this.m_stpportdesignatedbridge = null;
        }
        this.m_stpportdesignatedport = rset.getString(ndx++);
        if (rset.wasNull()) {
            this.m_stpportdesignatedport = null;
        }
        this.m_status = (str = rset.getString(ndx++)) != null && !rset.wasNull() ? str.charAt(0) : (char)75;
        this.m_lastPollTime = rset.getTimestamp(ndx++);
        Object var9_9 = null;
        d.cleanUp();
        if (log.isDebugEnabled()) {
            log.debug((Object)"StpInterfaceEntry.load: result found");
        }
        this.m_changed = 0;
        return true;
    }

    DbStpInterfaceEntry() {
        throw new UnsupportedOperationException("Default constructor not supported!");
    }

    DbStpInterfaceEntry(int nodeId, int bridgeport, int stpvlan, boolean exists) {
        this.m_nodeId = nodeId;
        this.m_fromDb = exists;
        this.m_bridgeport = bridgeport;
        this.m_ifindex = -1;
        this.m_stpportstate = -1;
        this.m_stpportpathcost = -1;
        this.m_stpportdesignatedcost = -1;
        this.m_stpportvlan = stpvlan;
        this.m_stpportdesignatedbridge = null;
        this.m_stpportdesignatedroot = null;
        this.m_stpportdesignatedport = null;
    }

    static DbStpInterfaceEntry create(int nodeId, int bridgeport, int vlan) {
        return new DbStpInterfaceEntry(nodeId, bridgeport, vlan, false);
    }

    public int get_nodeId() {
        return this.m_nodeId;
    }

    public int get_bridgeport() {
        return this.m_bridgeport;
    }

    public int get_stpvlan() {
        return this.m_stpportvlan;
    }

    public int get_ifindex() {
        return this.m_ifindex;
    }

    void set_ifindex(int index) {
        this.m_ifindex = index;
        this.m_changed |= 1;
    }

    boolean hasIfIndexChanged() {
        return (this.m_changed & 1) == 1;
    }

    boolean updateIfIndex(int ifindex) {
        if (ifindex != this.m_ifindex) {
            this.set_ifindex(ifindex);
            return true;
        }
        return false;
    }

    public int get_stpportstate() {
        return this.m_stpportstate;
    }

    void set_stpportstate(int stpportstate) {
        this.m_stpportstate = stpportstate == 2 || stpportstate == 6 || stpportstate == 1 || stpportstate == 5 || stpportstate == 4 || stpportstate == 3 ? stpportstate : -1;
        this.m_changed |= 2;
    }

    boolean hasStpPortStateChanged() {
        return (this.m_changed & 2) == 2;
    }

    boolean updateStpPortState(int stpportstate) {
        if (stpportstate != this.m_stpportstate) {
            this.set_stpportstate(stpportstate);
            return true;
        }
        return false;
    }

    public int get_stpportpathcost() {
        return this.m_stpportpathcost;
    }

    void set_stpportpathcost(int stpportpathcost) {
        this.m_stpportpathcost = stpportpathcost;
        this.m_changed |= 4;
    }

    boolean hasStpPortPathCostChanged() {
        return (this.m_changed & 4) == 4;
    }

    boolean updateStpPortPathCost(int stpportpathcost) {
        if (stpportpathcost != this.m_stpportpathcost) {
            this.set_stpportpathcost(stpportpathcost);
            return true;
        }
        return false;
    }

    public String get_stpportdesignatedroot() {
        return this.m_stpportdesignatedroot;
    }

    void set_stpportdesignatedroot(String stpportdesignatedroot) {
        this.m_stpportdesignatedroot = stpportdesignatedroot;
        this.m_changed |= 8;
    }

    boolean hasStpPortDesignatedRootChanged() {
        return (this.m_changed & 8) == 8;
    }

    boolean updateStpportDesignatedRoot(String stpportdesignatedroot) {
        if (stpportdesignatedroot != this.m_stpportdesignatedroot) {
            this.set_stpportdesignatedroot(stpportdesignatedroot);
            return true;
        }
        return false;
    }

    public int get_stpportdesignatedcost() {
        return this.m_stpportdesignatedcost;
    }

    void set_stpportdesignatedcost(int stpportdesignatedcost) {
        this.m_stpportdesignatedcost = stpportdesignatedcost;
        this.m_changed |= 0x10;
    }

    boolean hasStpPortDesgnatedCostChanged() {
        return (this.m_changed & 0x10) == 16;
    }

    boolean updateStpPortDesignatedCost(int stpportdesignatedcost) {
        if (stpportdesignatedcost != this.m_stpportdesignatedcost) {
            this.set_stpportdesignatedcost(stpportdesignatedcost);
            return true;
        }
        return false;
    }

    public String get_stpportdesignatedbridge() {
        return this.m_stpportdesignatedbridge;
    }

    void set_stpportdesignatedbridge(String stpportdesignatedbridge) {
        this.m_stpportdesignatedbridge = stpportdesignatedbridge;
        this.m_changed |= 0x20;
    }

    boolean hasStpPortDesignatedBridgeChanged() {
        return (this.m_changed & 0x20) == 32;
    }

    boolean updateStpportDesignatedBridge(String stpportdesignatedbridge) {
        if (stpportdesignatedbridge != this.m_stpportdesignatedbridge) {
            this.set_stpportdesignatedbridge(stpportdesignatedbridge);
            return true;
        }
        return false;
    }

    public String get_stpdesignatedport() {
        return this.m_stpportdesignatedport;
    }

    void set_stpportdesignatedport(String stpportdesignatedport) {
        this.m_stpportdesignatedport = stpportdesignatedport;
        this.m_changed |= 0x40;
    }

    boolean hasStpPortDesignatedPortChanged() {
        return (this.m_changed & 0x40) == 64;
    }

    boolean updateStpportDesignatedPort(String stpportdesignatedport) {
        if (stpportdesignatedport != this.m_stpportdesignatedport) {
            this.set_stpportdesignatedport(stpportdesignatedport);
            return true;
        }
        return false;
    }

    char get_status() {
        return this.m_status;
    }

    void set_status(char status) {
        if (status == 'A' || status == 'N' || status == 'D') {
            this.m_status = status;
        }
        this.m_changed |= 0x80;
    }

    boolean hasStatusChanged() {
        return (this.m_changed & 0x80) == 128;
    }

    boolean updateStatus(char status) {
        if (status != this.m_status) {
            this.set_status(status);
            return true;
        }
        return false;
    }

    Timestamp get_lastpolltime() {
        return this.m_lastPollTime;
    }

    String getLastPollTimeString() {
        String result = null;
        if (this.m_lastPollTime != null) {
            result = this.m_lastPollTime.toString();
        }
        return result;
    }

    void set_lastpolltime(String time) throws ParseException {
        if (time == null) {
            this.m_lastPollTime = null;
        } else {
            Date tmpDate = EventConstants.parseToDate((String)time);
            this.m_lastPollTime = new Timestamp(tmpDate.getTime());
        }
        this.m_changed |= 0x100;
    }

    void set_lastpolltime(Date time) {
        this.m_lastPollTime = new Timestamp(time.getTime());
        this.m_changed |= 0x100;
    }

    void set_lastpolltime(Timestamp time) {
        this.m_lastPollTime = time;
        this.m_changed |= 0x100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void store() throws SQLException {
        if (this.m_changed != 0 || !this.m_fromDb) {
            Connection db = null;
            try {
                db = DataSourceFactory.getInstance().getConnection();
                this.store(db);
                if (!db.getAutoCommit()) {
                    db.commit();
                }
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                try {
                    if (db != null) {
                        db.close();
                    }
                }
                catch (SQLException e) {
                    ThreadCategory.getInstance(this.getClass()).warn((Object)"Exception closing JDBC connection", (Throwable)e);
                }
                throw throwable;
            }
            try {
                if (db != null) {
                    db.close();
                }
            }
            catch (SQLException e) {
                ThreadCategory.getInstance(this.getClass()).warn((Object)"Exception closing JDBC connection", (Throwable)e);
            }
        }
    }

    void store(Connection db) throws SQLException {
        if (this.m_changed != 0 || !this.m_fromDb) {
            if (this.m_fromDb) {
                this.update(db);
            } else {
                this.insert(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DbStpInterfaceEntry get(int nid, int bridgeport, int vlan) throws SQLException {
        DbStpInterfaceEntry dbStpInterfaceEntry;
        Connection db = null;
        try {
            db = DataSourceFactory.getInstance().getConnection();
            dbStpInterfaceEntry = DbStpInterfaceEntry.get(db, nid, bridgeport, vlan);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                if (db != null) {
                    db.close();
                }
            }
            catch (SQLException e) {
                ThreadCategory.getInstance(DbStpNodeEntry.class).warn((Object)"Exception closing JDBC connection", (Throwable)e);
            }
            throw throwable;
        }
        try {
            if (db != null) {
                db.close();
            }
        }
        catch (SQLException e) {
            ThreadCategory.getInstance(DbStpNodeEntry.class).warn((Object)"Exception closing JDBC connection", (Throwable)e);
        }
        return dbStpInterfaceEntry;
    }

    static DbStpInterfaceEntry get(Connection db, int nid, int bridgeport, int vlan) throws SQLException {
        DbStpInterfaceEntry entry = new DbStpInterfaceEntry(nid, bridgeport, vlan, true);
        if (!entry.load(db)) {
            entry = null;
        }
        return entry;
    }

    public String toString() {
        String sep = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        buf.append("from db = ").append(this.m_fromDb).append(sep);
        buf.append("node id = ").append(this.m_nodeId).append(sep);
        buf.append("bridge port= ").append(this.m_bridgeport).append(sep);
        buf.append("ifindex = ").append(this.m_ifindex).append(sep);
        buf.append("stp vlan index = ").append(this.m_stpportvlan).append(sep);
        buf.append("stp port state= ").append(this.m_stpportstate).append(sep);
        buf.append("stp port path cost = ").append(this.m_stpportpathcost).append(sep);
        buf.append("stp port designatd root = ").append(this.m_stpportdesignatedroot).append(sep);
        buf.append("stp port designated cost = ").append(this.m_stpportdesignatedcost).append(sep);
        buf.append("stp port designated bridge  = ").append(this.m_stpportdesignatedbridge).append(sep);
        buf.append("stp port designated port = ").append(this.m_stpportdesignatedport).append(sep);
        buf.append("status = ").append(this.m_status).append(sep);
        buf.append("last poll time = ").append(this.m_lastPollTime).append(sep);
        return buf.toString();
    }
}

