/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Category;
import org.opennms.core.utils.Base64;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Snmp;
import org.opennms.netmgt.xml.event.Tticket;
import org.opennms.netmgt.xml.event.Value;

public final class EventUtil {
    static final String TAG_EVENT_DB_ID = "eventid";
    static final String TAG_UEI = "uei";
    static final String TAG_SOURCE = "source";
    static final String TAG_DESCR = "descr";
    static final String TAG_LOGMSG = "logmsg";
    static final String TAG_TIME = "time";
    static final String TAG_DPNAME = "dpname";
    static final String TAG_NODEID = "nodeid";
    static final String TAG_NODELABEL = "nodelabel";
    static final String TAG_HOST = "host";
    static final String TAG_INTERFACE = "interface";
    static final String TAG_INTERFACE_RESOLVE = "interfaceresolve";
    static final String TAG_IFALIAS = "ifalias";
    static final String TAG_SNMP_ID = "id";
    static final String TAG_SNMP = "snmp";
    static final String TAG_SNMP_IDTEXT = "idtext";
    static final String TAG_SNMP_VERSION = "version";
    static final String TAG_SNMP_SPECIFIC = "specific";
    static final String TAG_SNMP_GENERIC = "generic";
    static final String TAG_SNMP_COMMUNITY = "community";
    static final String TAG_SNMPHOST = "snmphost";
    static final String TAG_SERVICE = "service";
    static final String TAG_SEVERITY = "severity";
    static final String TAG_OPERINSTR = "operinstruct";
    static final String TAG_MOUSEOVERTEXT = "mouseovertext";
    static final Object TAG_TTICKET_ID = "tticketid";
    static final String ASSET_BEGIN = "asset[";
    static final String ASSET_END_SUFFIX = "]";
    static final char PERCENT = '%';
    static final String PARMS_NAMES = "parm[names-all]";
    static final String PARMS_VALUES = "parm[values-all]";
    static final String PARMS_ALL = "parm[all]";
    static final String PARM_BEGIN = "parm[";
    static final int PARM_BEGIN_LENGTH = 5;
    static final String NUM_PARMS_STR = "parm[##]";
    static final String PARM_NUM_PREFIX = "parm[#";
    static final int PARM_NUM_PREFIX_LENGTH = 6;
    static final String PARM_NAME_NUMBERED_PREFIX = "parm[name-#";
    static final int PARM_NAME_NUMBERED_PREFIX_LENGTH = 11;
    static final String PARM_END_SUFFIX = "]";
    static final char NAME_VAL_DELIM = '=';
    static final char SPACE_DELIM = ' ';
    static final char ATTRIB_DELIM = ',';

    public static String getValueAsString(Value pvalue) {
        if (pvalue == null) {
            return null;
        }
        if (pvalue.getContent() == null) {
            return null;
        }
        String result = "";
        String encoding = pvalue.getEncoding();
        if (encoding.equals("text")) {
            result = pvalue.getContent();
        } else if (encoding.equals("base64")) {
            result = new String(Base64.decodeBase64((char[])pvalue.getContent().toCharArray()));
        }
        return result.trim();
    }

    public static String escape(String inStr, char delimchar) {
        char delim = delimchar;
        String delimEscStr = "%" + String.valueOf((int)delim);
        StringBuffer outBuffer = new StringBuffer(inStr);
        int index = 0;
        int delimIndex = inStr.indexOf(delimchar, index);
        while (delimIndex != -1) {
            outBuffer.deleteCharAt(delimIndex);
            outBuffer.insert(delimIndex, delimEscStr);
            index = delimIndex + delimEscStr.length() + 1;
            delimIndex = outBuffer.toString().indexOf(delimchar, index);
        }
        return outBuffer.toString();
    }

    public static String getValueOfParm(String parm, Event event) {
        String retParmVal = null;
        if (parm.equals(TAG_UEI)) {
            retParmVal = event.getUei();
        }
        if (parm.equals(TAG_EVENT_DB_ID)) {
            retParmVal = event.hasDbid() ? Integer.toString(event.getDbid()) : "eventid-unknown";
        } else if (parm.equals(TAG_SOURCE)) {
            retParmVal = event.getSource();
        } else if (parm.equals(TAG_DPNAME)) {
            retParmVal = event.getDistPoller();
        } else if (parm.equals(TAG_DESCR)) {
            retParmVal = event.getDescr();
        } else if (parm.equals(TAG_LOGMSG)) {
            retParmVal = event.getLogmsg().getContent();
        } else if (parm.equals(TAG_NODEID)) {
            retParmVal = Long.toString(event.getNodeid());
        } else if (parm.equals(TAG_NODELABEL)) {
            retParmVal = Long.toString(event.getNodeid());
            String nodeLabel = null;
            if (event.getNodeid() > 0L) {
                try {
                    nodeLabel = EventUtil.getNodeLabel(event.getNodeid());
                }
                catch (SQLException sqlE) {
                    // empty catch block
                }
            }
            retParmVal = nodeLabel != null ? nodeLabel : "Unknown";
        } else if (parm.equals(TAG_TIME)) {
            String eventTime = event.getTime();
            try {
                Date actualDate = EventConstants.parseToDate((String)eventTime);
                DateFormat df = DateFormat.getDateTimeInstance(0, 0);
                retParmVal = df.format(actualDate);
            }
            catch (ParseException e) {
                Category log = ThreadCategory.getInstance();
                log.error((Object)("could not parse event date \"" + eventTime + "\": "), (Throwable)e);
                retParmVal = eventTime;
            }
        } else if (parm.equals(TAG_HOST)) {
            retParmVal = event.getHost();
        } else if (parm.equals(TAG_INTERFACE)) {
            retParmVal = event.getInterface();
        } else if (parm.equals(TAG_INTERFACE_RESOLVE)) {
            retParmVal = event.getInterface();
            try {
                InetAddress inet = InetAddress.getByName(retParmVal);
                retParmVal = inet.getHostName();
            }
            catch (UnknownHostException e) {}
        } else if (parm.equals(TAG_IFALIAS)) {
            String ifAlias = null;
            if (event.getNodeid() > 0L && event.getInterface() != null) {
                try {
                    ifAlias = EventUtil.getIfAlias(event.getNodeid(), event.getInterface());
                }
                catch (SQLException sqlE) {
                    ThreadCategory.getInstance(EventUtil.class).info((Object)("ifAlias Unavailable for " + event.getNodeid() + ":" + event.getInterface()), (Throwable)sqlE);
                }
            }
            retParmVal = ifAlias != null ? ifAlias : event.getInterface();
        } else if (parm.equals(TAG_SNMPHOST)) {
            retParmVal = event.getSnmphost();
        } else if (parm.equals(TAG_SERVICE)) {
            retParmVal = event.getService();
        } else if (parm.equals(TAG_SNMP)) {
            Snmp info = event.getSnmp();
            if (info == null) {
                retParmVal = null;
            } else {
                StringBuffer snmpStr = new StringBuffer(info.getId());
                if (info.getIdtext() != null) {
                    snmpStr.append(',' + EventUtil.escape(info.getIdtext().trim(), ','));
                } else {
                    snmpStr.append(",undefined");
                }
                snmpStr.append(',' + info.getVersion());
                if (info.hasSpecific()) {
                    snmpStr.append(',' + Integer.toString(info.getSpecific()));
                } else {
                    snmpStr.append(",undefined");
                }
                if (info.hasGeneric()) {
                    snmpStr.append(',' + Integer.toString(info.getGeneric()));
                } else {
                    snmpStr.append(",undefined");
                }
                if (info.getCommunity() != null) {
                    snmpStr.append(',' + info.getCommunity().trim());
                } else {
                    snmpStr.append(",undefined");
                }
                retParmVal = snmpStr.toString();
            }
        } else if (parm.equals(TAG_SNMP_ID)) {
            Snmp info = event.getSnmp();
            if (info != null) {
                retParmVal = info.getId();
            }
        } else if (parm.equals(TAG_SNMP_IDTEXT)) {
            Snmp info = event.getSnmp();
            if (info != null && info.getIdtext() != null) {
                retParmVal = info.getIdtext();
            }
        } else if (parm.equals(TAG_SNMP_VERSION)) {
            Snmp info = event.getSnmp();
            if (info != null) {
                retParmVal = info.getVersion();
            }
        } else if (parm.equals(TAG_SNMP_SPECIFIC)) {
            Snmp info = event.getSnmp();
            if (info != null && info.hasSpecific()) {
                retParmVal = Integer.toString(info.getSpecific());
            }
        } else if (parm.equals(TAG_SNMP_GENERIC)) {
            Snmp info = event.getSnmp();
            if (info != null && info.hasGeneric()) {
                retParmVal = Integer.toString(info.getGeneric());
            }
        } else if (parm.equals(TAG_SNMP_COMMUNITY)) {
            Snmp info = event.getSnmp();
            if (info != null && info.getCommunity() != null) {
                retParmVal = info.getCommunity();
            }
        } else if (parm.equals(TAG_SEVERITY)) {
            retParmVal = event.getSeverity();
        } else if (parm.equals(TAG_OPERINSTR)) {
            retParmVal = event.getOperinstruct();
        } else if (parm.equals(TAG_MOUSEOVERTEXT)) {
            retParmVal = event.getMouseovertext();
        } else if (parm.equals(TAG_TTICKET_ID)) {
            Tticket ticket = event.getTticket();
            retParmVal = ticket == null ? "" : ticket.getContent();
        } else if (parm.equals(PARMS_VALUES)) {
            retParmVal = EventUtil.getAllParmValues(event);
        } else if (parm.equals(PARMS_NAMES)) {
            retParmVal = EventUtil.getAllParmNames(event);
        } else if (parm.equals(PARMS_ALL)) {
            retParmVal = EventUtil.getAllParamValues(event);
        } else if (parm.equals(NUM_PARMS_STR)) {
            retParmVal = EventUtil.getParmCount(event);
        } else if (parm.startsWith(PARM_NUM_PREFIX)) {
            retParmVal = EventUtil.getNumParmValue(parm, event);
        } else if (parm.startsWith(PARM_NAME_NUMBERED_PREFIX)) {
            retParmVal = EventUtil.getNumParmName(parm, event);
        } else if (parm.startsWith(PARM_BEGIN)) {
            if (parm.length() > 5) {
                retParmVal = EventUtil.getNamedParmValue(parm, event);
            }
        } else if (parm.startsWith(ASSET_BEGIN)) {
            retParmVal = null;
            String assetFieldValue = null;
            if (event.getNodeid() > 0L) {
                assetFieldValue = EventUtil.getAssetFieldValue(parm, event.getNodeid());
            }
            retParmVal = assetFieldValue != null ? assetFieldValue : "Unknown";
        }
        return retParmVal == null ? null : retParmVal.trim();
    }

    private static String getAllParmValues(Event event) {
        String retParmVal = null;
        if (event.getParms() != null && event.getParms().getParmCount() <= 0) {
            retParmVal = null;
        } else {
            StringBuffer ret = new StringBuffer();
            Parms parms = event.getParms();
            Enumeration en = parms.enumerateParm();
            while (en.hasMoreElements()) {
                String parmValueStr;
                Parm evParm = (Parm)en.nextElement();
                Value parmValue = evParm.getValue();
                if (parmValue == null || (parmValueStr = EventUtil.getValueAsString(parmValue)) == null) continue;
                if (ret.length() == 0) {
                    ret.append(parmValueStr);
                    continue;
                }
                ret.append(' ' + parmValueStr);
            }
            retParmVal = ret.toString();
        }
        return retParmVal;
    }

    private static String getAllParmNames(Event event) {
        String retParmVal = null;
        if (event.getParms() != null && event.getParms().getParmCount() <= 0) {
            retParmVal = null;
        } else {
            StringBuffer ret = new StringBuffer();
            Parms parms = event.getParms();
            if (parms != null) {
                Enumeration en = parms.enumerateParm();
                while (en.hasMoreElements()) {
                    Parm evParm = (Parm)en.nextElement();
                    String parmName = evParm.getParmName();
                    if (parmName == null) continue;
                    if (ret.length() == 0) {
                        ret.append(parmName.trim());
                        continue;
                    }
                    ret.append(' ' + parmName.trim());
                }
            }
            retParmVal = ret.toString();
        }
        return retParmVal;
    }

    private static String getAllParamValues(Event event) {
        String retParmVal = null;
        if (event.getParms() != null && event.getParms().getParmCount() <= 0) {
            retParmVal = null;
        } else {
            StringBuffer ret = new StringBuffer();
            Parms parms = event.getParms();
            if (parms != null) {
                Enumeration en = parms.enumerateParm();
                while (en.hasMoreElements()) {
                    Value parmValue;
                    Parm evParm = (Parm)en.nextElement();
                    String parmName = evParm.getParmName();
                    if (parmName == null || (parmValue = evParm.getValue()) == null) continue;
                    String parmValueStr = EventUtil.getValueAsString(parmValue);
                    if (ret.length() != 0) {
                        ret.append(' ');
                    }
                    ret.append(parmName.trim() + '=' + "\"" + parmValueStr + "\"");
                }
            }
            retParmVal = ret.toString();
        }
        return retParmVal;
    }

    private static String getParmCount(Event event) {
        String retParmVal = null;
        if (event.getParms() != null) {
            int count = event.getParms().getParmCount();
            retParmVal = String.valueOf(count);
        }
        return retParmVal;
    }

    private static String getNumParmName(String parm, Event event) {
        String retParmVal = null;
        Parms eventParms = event.getParms();
        int end = parm.lastIndexOf("]");
        if (end != -1 && eventParms != null) {
            String parmSpec = parm.substring(11, end);
            String eparmnum = null;
            String eparmsep = null;
            String eparmoffset = null;
            String eparmrangesep = null;
            String eparmrangelen = null;
            if (parmSpec.matches("^\\d+$")) {
                eparmnum = parmSpec;
            } else {
                Matcher m = Pattern.compile("^(\\d+)([^0-9+-]+)([+-]?\\d+)((:)([+-]?\\d+)?)?$").matcher(parmSpec);
                if (m.matches()) {
                    eparmnum = m.group(1);
                    eparmsep = m.group(2);
                    eparmoffset = m.group(3);
                    eparmrangesep = m.group(5);
                    eparmrangelen = m.group(6);
                }
            }
            int parmNum = -1;
            try {
                parmNum = Integer.parseInt(eparmnum);
            }
            catch (NumberFormatException nfe) {
                parmNum = -1;
                retParmVal = null;
            }
            if (parmNum > 0 && parmNum <= eventParms.getParmCount()) {
                Parm evParm = eventParms.getParm(parmNum - 1);
                String eparmname = evParm.getParmName();
                if (eparmsep != null && eparmoffset != null) {
                    int parmOffset = Integer.parseInt(eparmoffset);
                    boolean doRange = ":".equals(eparmrangesep);
                    int parmRangeLen = eparmrangelen == null ? 0 : Integer.parseInt(eparmrangelen);
                    retParmVal = EventUtil.splitAndExtract(eparmname, eparmsep, parmOffset, doRange, parmRangeLen);
                } else {
                    retParmVal = eparmname;
                }
            } else {
                retParmVal = null;
            }
        }
        return retParmVal;
    }

    private static String splitAndExtract(String src, String sep, int offset, boolean doRange, int rangeLen) {
        String sepLiteral = Pattern.quote(sep);
        if (src.startsWith(sep)) {
            src = src.replaceFirst(sepLiteral, "");
        }
        String[] components = src.split(sepLiteral);
        if (Math.abs(offset) > components.length || offset == 0) {
            return null;
        }
        int startIndex = offset < 0 ? components.length + offset : offset - 1;
        int endIndex = startIndex;
        if (!doRange) {
            return components[startIndex];
        }
        endIndex = rangeLen == 0 ? components.length - 1 : (rangeLen < 0 ? startIndex + 1 + rangeLen : startIndex - 1 + rangeLen);
        StringBuffer retVal = new StringBuffer();
        for (int i = startIndex; i <= endIndex; ++i) {
            retVal.append(components[i]);
            if (i >= endIndex) continue;
            retVal.append(sep);
        }
        return retVal.toString();
    }

    private static String getNumParmValue(String parm, Event event) {
        String retParmVal = null;
        Parms eventParms = event.getParms();
        int end = parm.lastIndexOf("]");
        if (end != -1 && eventParms != null) {
            String eparmname = parm.substring(6, end);
            int parmNum = -1;
            try {
                parmNum = Integer.parseInt(eparmname);
            }
            catch (NumberFormatException nfe) {
                parmNum = -1;
                retParmVal = null;
            }
            if (parmNum > 0 && parmNum <= eventParms.getParmCount()) {
                Parm evParm = eventParms.getParm(parmNum - 1);
                Value eparmval = evParm.getValue();
                if (eparmval != null) {
                    retParmVal = EventUtil.getValueAsString(eparmval);
                }
            } else {
                retParmVal = null;
            }
        }
        return retParmVal;
    }

    public static String getNamedParmValue(String parm, Event event) {
        String retParmVal = null;
        int end = parm.indexOf("]", 5);
        if (end != -1) {
            String eparmname = parm.substring(5, end);
            Parms parms = event.getParms();
            if (parms != null) {
                Enumeration en = parms.enumerateParm();
                while (en.hasMoreElements()) {
                    Value eparmval;
                    Parm evParm = (Parm)en.nextElement();
                    String parmName = evParm.getParmName();
                    if (parmName == null || !parmName.trim().equals(eparmname) || (eparmval = evParm.getValue()) == null) continue;
                    retParmVal = EventUtil.getValueAsString(eparmval);
                    break;
                }
            }
        }
        return retParmVal;
    }

    public static String expandParms(String inp, Event event) {
        String retStr;
        int index1 = -1;
        int index2 = -1;
        if (inp == null) {
            return null;
        }
        StringBuffer ret = new StringBuffer();
        String tempInp = inp;
        int inpLen = inp.length();
        while (tempInp != null && (index1 = tempInp.indexOf(37)) != -1) {
            ret.append(tempInp.substring(0, index1));
            index2 = tempInp.indexOf(37, index1 + 1);
            if (index2 == -1) break;
            String parm = tempInp.substring(index1 + 1, index2);
            String parmVal = EventUtil.getValueOfParm(parm, event);
            if (parmVal != null) {
                ret.append(parmVal);
            }
            if (index2 < inpLen - 1) {
                tempInp = tempInp.substring(index2 + 1);
                continue;
            }
            tempInp = null;
        }
        if ((index1 == -1 || index2 == -1) && tempInp != null) {
            ret.append(tempInp);
        }
        if ((retStr = ret.toString()) != null && !retStr.equals(inp)) {
            return retStr;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getNodeLabel(long nodeId) throws SQLException {
        String nodeLabel = null;
        Connection dbConn = null;
        try {
            block11: {
                Statement stmt = null;
                try {
                    dbConn = DataSourceFactory.getInstance().getConnection();
                    stmt = dbConn.createStatement();
                    ResultSet rs = stmt.executeQuery("SELECT nodelabel FROM node WHERE nodeid=" + String.valueOf(nodeId));
                    if (rs.next()) {
                        nodeLabel = rs.getString(TAG_NODELABEL);
                    }
                    Object var7_5 = null;
                    if (stmt == null) break block11;
                }
                catch (Throwable throwable) {
                    Object var7_6 = null;
                    if (stmt == null) throw throwable;
                    try {
                        stmt.close();
                        throw throwable;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (Exception e) {}
                stmt.close();
            }
            Object var10_10 = null;
            if (dbConn == null) return nodeLabel;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (dbConn == null) throw throwable;
            try {
                dbConn.close();
                throw throwable;
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Throwable t) {
            return nodeLabel;
        }
        dbConn.close();
        return nodeLabel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getIfAlias(long nodeId, String ipaddr) throws SQLException {
        String ifAlias = null;
        Connection dbConn = null;
        try {
            block11: {
                Statement stmt = null;
                try {
                    dbConn = DataSourceFactory.getInstance().getConnection();
                    stmt = dbConn.createStatement();
                    ResultSet rs = stmt.executeQuery("SELECT snmpifalias FROM snmpinterface WHERE nodeid=" + nodeId + " and ipaddr='" + ipaddr + "'");
                    if (rs.next()) {
                        ifAlias = rs.getString("snmpifalias");
                    }
                    Object var8_6 = null;
                    if (stmt == null) break block11;
                }
                catch (Throwable throwable) {
                    Object var8_7 = null;
                    if (stmt == null) throw throwable;
                    try {
                        stmt.close();
                        throw throwable;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (Exception e) {}
                stmt.close();
            }
            Object var11_11 = null;
            if (dbConn == null) return ifAlias;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (dbConn == null) throw throwable;
            try {
                dbConn.close();
                throw throwable;
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Throwable t) {
            return ifAlias;
        }
        dbConn.close();
        return ifAlias;
    }

    public static Event cloneEvent(Event orig) {
        Event copy = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(orig);
            out.flush();
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
            copy = (Event)in.readObject();
        }
        catch (IOException e) {
            ThreadCategory.getInstance(EventUtil.class).error((Object)"Exception cloning event", (Throwable)e);
        }
        catch (ClassNotFoundException cnfe) {
            ThreadCategory.getInstance(EventUtil.class).error((Object)"Exception cloning event", (Throwable)cnfe);
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static String getAssetFieldValue(String parm, long nodeId) {
        retParmVal = null;
        end = parm.lastIndexOf("]");
        assetField = parm.substring(6, end);
        dbConn = null;
        try {
            block19: {
                stmt = null;
                try {
                    block18: {
                        dbConn = DataSourceFactory.getInstance().getConnection();
                        stmt = dbConn.createStatement();
                        rs = stmt.executeQuery("SELECT " + assetField + " FROM assets WHERE nodeid=" + String.valueOf(nodeId));
                        if (!rs.next()) break block18;
                        retParmVal = rs.getString(assetField);
                    }
                    var10_9 = null;
                    ** if (stmt == null) goto lbl-1000
                }
                catch (Throwable var9_15) {
                    var10_11 = null;
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    throw var9_15;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        stmt.close();
                    }
                    catch (Exception e) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block19;
                    catch (SQLException sqlE) {
                        var10_10 = null;
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Exception e) {}
                        }
                    }
                }
            }
            var13_16 = null;
            ** if (dbConn == null) goto lbl-1000
        }
        catch (Throwable var12_20) {
            var13_17 = null;
            if (dbConn != null) {
                try {
                    dbConn.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            throw var12_20;
        }
lbl-1000:
        // 1 sources

        {
            try {
                dbConn.close();
            }
            catch (Throwable t) {}
        }
lbl-1000:
        // 2 sources

        {
        }
        return retParmVal;
    }
}

