/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd;

import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.EventConfDao;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.xml.event.Event;
import org.springframework.util.Assert;

public class BroadcastEventProcessor
implements EventListener {
    private final EventIpcManager m_eventIpcManager;
    private final EventConfDao m_eventConfDao;

    public BroadcastEventProcessor(EventIpcManager eventIpcManager, EventConfDao eventConfDao) {
        Assert.notNull((Object)eventIpcManager, (String)"argument eventIpcManager must not be null");
        Assert.notNull((Object)eventConfDao, (String)"argument eventConfDao must not be null");
        this.m_eventIpcManager = eventIpcManager;
        this.m_eventConfDao = eventConfDao;
        this.addEventListener();
    }

    private void addEventListener() {
        this.m_eventIpcManager.addEventListener(this, "uei.opennms.org/internal/eventsConfigChange");
    }

    public synchronized void close() {
        this.m_eventIpcManager.removeEventListener(this);
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public String getName() {
        return "Eventd:BroadcastEventProcessor";
    }

    public void onEvent(Event event) {
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("received event, UEI = " + event.getUei()));
        }
        if (event.getUei().equals("uei.opennms.org/internal/eventsConfigChange")) {
            try {
                this.m_eventConfDao.reload();
            }
            catch (Exception e) {
                this.log().error((Object)("Could not reload events config: " + e), (Throwable)e);
            }
        } else {
            this.log().warn((Object)("Received unanticipated event with UEI '" + event.getUei() + "': " + event));
        }
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

