/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.discovery;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.opennms.core.utils.DBUtils;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.DiscoveryConfigFactory;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.discovery.DiscoveryPingResponseCallback;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.model.discovery.IPPollAddress;
import org.opennms.netmgt.model.events.AnnotationBasedEventListenerAdapter;
import org.opennms.netmgt.model.events.EventSubscriptionService;
import org.opennms.netmgt.model.events.annotations.EventHandler;
import org.opennms.netmgt.model.events.annotations.EventListener;
import org.opennms.netmgt.ping.PingResponseCallback;
import org.opennms.netmgt.ping.Pinger;
import org.opennms.netmgt.xml.event.Event;

@EventListener(name="OpenNMS.Discovery")
public class Discovery
extends AbstractServiceDaemon {
    private static final Discovery m_singleton = new Discovery();
    private static final DiscoveryPingResponseCallback cb = new DiscoveryPingResponseCallback();
    private static final int PING_IDLE = 0;
    private static final int PING_RUNNING = 1;
    private static final int PING_FINISHING = 2;
    private static final String ALL_IP_ADDRS_SQL = "SELECT DISTINCT ipAddr FROM ipInterface WHERE isManaged <> 'D'";
    private Set<String> m_alreadyDiscovered = Collections.synchronizedSet(new HashSet());
    private DiscoveryConfigFactory m_discoveryFactory;
    private Timer m_timer;
    private int m_xstatus = 0;

    private Discovery() {
        super("OpenNMS.Discovery");
    }

    protected void onInit() {
        this.initializeConfiguration();
        EventIpcManagerFactory.init();
        AnnotationBasedEventListenerAdapter listener = new AnnotationBasedEventListenerAdapter((Object)this, (EventSubscriptionService)EventIpcManagerFactory.getIpcManager());
    }

    private void initializeConfiguration() {
        try {
            DiscoveryConfigFactory.reload();
            this.m_discoveryFactory = DiscoveryConfigFactory.getInstance();
        }
        catch (Exception e) {
            this.fatalf(e, "Unable to initialize the discovery configuration factory", new Object[0]);
            throw new UndeclaredThrowableException(e);
        }
    }

    protected void doPings() {
        this.debugf("starting ping sweep", new Object[0]);
        this.initializeConfiguration();
        this.m_xstatus = 1;
        for (IPPollAddress pollAddress : this.m_discoveryFactory.getConfiguredAddresses()) {
            if (this.m_xstatus == 2 || this.m_timer == null) {
                this.m_xstatus = 0;
                return;
            }
            this.ping(pollAddress);
            try {
                Thread.sleep(this.m_discoveryFactory.getIntraPacketDelay());
            }
            catch (InterruptedException e) {
                break;
            }
        }
        this.debugf("finished discovery sweep", new Object[0]);
        this.m_xstatus = 0;
    }

    private void ping(IPPollAddress pollAddress) {
        InetAddress address = pollAddress.getAddress();
        if (address != null && !this.isAlreadyDiscovered(address)) {
            try {
                Pinger.ping((InetAddress)address, (long)pollAddress.getTimeout(), (int)pollAddress.getRetries(), (short)1, (PingResponseCallback)cb);
            }
            catch (IOException e) {
                this.debugf(e, "error pinging %s", new Object[]{address.getAddress()});
            }
        }
    }

    private boolean isAlreadyDiscovered(InetAddress address) {
        return this.m_alreadyDiscovered.contains(address.getHostAddress());
    }

    public static Discovery getInstance() {
        return m_singleton;
    }

    private void startTimer() {
        if (this.m_timer != null) {
            this.debugf("startTimer() called, but a previous timer exists; making sure it's cleaned up", new Object[0]);
            this.m_xstatus = 2;
            this.m_timer.cancel();
        }
        this.debugf("scheduling new discovery timer", new Object[0]);
        this.m_timer = new Timer("Discovery.Pinger", true);
        TimerTask task = new TimerTask(){

            public void run() {
                Discovery.this.doPings();
            }
        };
        this.m_timer.scheduleAtFixedRate(task, this.m_discoveryFactory.getInitialSleepTime(), this.m_discoveryFactory.getRestartSleepTime());
    }

    private void stopTimer() {
        if (this.m_timer != null) {
            this.debugf("stopping existing timer", new Object[0]);
            this.m_xstatus = 2;
            this.m_timer.cancel();
            this.m_timer = null;
        } else {
            this.debugf("stopTimer() called, but there is no existing timer", new Object[0]);
        }
    }

    protected void onStart() {
        this.syncAlreadyDiscovered();
        this.startTimer();
    }

    protected void onStop() {
        this.stopTimer();
    }

    protected void onPause() {
        this.stopTimer();
    }

    protected void onResume() {
        this.startTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void syncAlreadyDiscovered() {
        block7: {
            Set<String> newAlreadyDiscovered = Collections.synchronizedSet(new HashSet());
            Connection conn = null;
            DBUtils d = new DBUtils(this.getClass());
            try {
                try {
                    conn = DataSourceFactory.getInstance().getConnection();
                    d.watch((Object)conn);
                    PreparedStatement stmt = conn.prepareStatement(ALL_IP_ADDRS_SQL);
                    d.watch((Object)stmt);
                    ResultSet rs = stmt.executeQuery();
                    d.watch((Object)rs);
                    if (rs != null) {
                        while (rs.next()) {
                            newAlreadyDiscovered.add(rs.getString(1));
                        }
                    } else {
                        this.log().warn((Object)"Got null ResultSet from query for all IP addresses");
                    }
                    this.m_alreadyDiscovered = newAlreadyDiscovered;
                }
                catch (SQLException sqle) {
                    this.log().warn((Object)("Caught SQLException while trying to query for all IP addresses: " + sqle.getMessage()));
                    Object var7_8 = null;
                    d.cleanUp();
                    break block7;
                }
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                d.cleanUp();
                throw throwable;
            }
            d.cleanUp();
        }
        this.log().info((Object)("syncAlreadyDiscovered initialized list of managed IP addresses with " + this.m_alreadyDiscovered.size() + " members"));
    }

    @EventHandler(uei="uei.opennms.org/internal/discoveryConfigChange")
    public void handleDiscoveryConfigurationChanged(Event event) {
        this.initializeConfiguration();
        this.stop();
        this.start();
    }

    @EventHandler(uei="uei.opennms.org/nodes/interfaceDeleted")
    public void handleInterfaceDeleted(Event event) {
        this.m_alreadyDiscovered.remove(event.getInterface());
        this.debugf("Removed %s from known node list", event.getInterface());
    }

    @EventHandler(uei="uei.opennms.org/internal/capsd/discResume")
    public void handleDiscoveryResume(Event event) {
        try {
            this.resume();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @EventHandler(uei="uei.opennms.org/internal/capsd/discPause")
    public void handleDiscoveryPause(Event event) {
        try {
            this.pause();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeGainedInterface")
    public void handleNodeGainedInterface(Event event) {
        this.m_alreadyDiscovered.add(event.getInterface());
        this.debugf("Added %s as discovered", event.getInterface());
    }
}

