/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dhcpd;

import edu.bucknell.net.JDHCP.DHCPMessage;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Category;
import org.opennms.core.fiber.Fiber;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.dhcpd.Client;
import org.opennms.netmgt.dhcpd.Message;

final class Receiver
implements Runnable,
Fiber {
    private static final short DHCP_TARGET_PORT = 68;
    private DatagramSocket m_receiver = new DatagramSocket(68);
    private String m_name = "DHCPReceiver";
    private int m_status = 0;
    private Thread m_worker = null;
    private List m_clients;

    Receiver(List clients) throws IOException {
        this.m_receiver.setSoTimeout(1000);
        this.m_clients = clients;
    }

    public synchronized void start() {
        if (this.m_worker != null) {
            throw new IllegalStateException("The fiber has already been started");
        }
        this.m_worker = new Thread((Runnable)this, this.getName());
        this.m_worker.setDaemon(true);
        this.m_worker.start();
        this.m_status = 1;
    }

    public synchronized void stop() {
        this.m_status = 3;
        this.m_receiver.close();
        this.m_worker.interrupt();
    }

    public synchronized int getStatus() {
        return this.m_status;
    }

    public String getName() {
        return this.m_name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Receiver receiver;
        Category log = ThreadCategory.getInstance(this.getClass());
        Receiver receiver2 = this;
        synchronized (receiver2) {
            this.m_status = 2;
        }
        byte[] dgbuf = new byte[2048];
        while (true) {
            Receiver receiver3;
            try {
                DatagramPacket pkt = new DatagramPacket(dgbuf, dgbuf.length);
                this.m_receiver.receive(pkt);
                log.debug((Object)"got a DHCP response.");
                Message msg = new Message(pkt.getAddress(), new DHCPMessage(pkt.getData()));
                List list = this.m_clients;
                synchronized (list) {
                    Iterator iter = this.m_clients.iterator();
                    if (!iter.hasNext()) {
                        log.debug((Object)"No client waiting for response.");
                    }
                    while (iter.hasNext()) {
                        Client c = (Client)iter.next();
                        if (c.getStatus() == 2) {
                            try {
                                log.debug((Object)("sending DHCP response pkt to client " + c.getName()));
                                c.sendMessage(msg);
                            }
                            catch (IOException ex) {
                                log.warn((Object)("Error sending response to client " + c.getName()));
                            }
                            continue;
                        }
                        if (c.getStatus() != 4) continue;
                        log.debug((Object)("Removing stale client " + c.getName()));
                        iter.remove();
                    }
                }
            }
            catch (InterruptedIOException ex) {
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                log.warn((Object)"An error occurred when reading DHCP response. Ignoring exception: ", (Throwable)ex);
            }
            catch (IOException ex) {
                receiver3 = this;
                synchronized (receiver3) {
                    if (this.m_status == 2) {
                        log.warn((Object)"Failed to read message, I/O error", (Throwable)ex);
                    }
                    break;
                }
            }
            catch (Throwable t) {
                receiver3 = this;
                synchronized (receiver3) {
                    if (this.m_status == 2) {
                        log.warn((Object)"Undeclared throwable caught", t);
                    }
                    break;
                }
            }
            receiver = this;
            synchronized (receiver) {
                if (this.m_status != 2) {
                    break;
                }
            }
        }
        receiver = this;
        synchronized (receiver) {
            this.m_status = 3;
        }
        this.m_receiver.close();
        receiver = this;
        synchronized (receiver) {
            this.m_status = 4;
        }
    }
}

