/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dhcpd;

import edu.bucknell.net.JDHCP.DHCPMessage;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Observable;
import org.apache.log4j.Category;
import org.opennms.core.fiber.Fiber;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.dhcpd.Message;

final class Client
extends Observable
implements Runnable,
Fiber {
    private static final short DHCP_TARGET_PORT = 67;
    private static InetAddress NULL_ADDR;
    private DatagramSocket m_sender;
    private Socket m_client;
    private ObjectOutputStream m_objsOut;
    private String m_name;
    private int m_status;
    private Thread m_worker;
    private UnicastListener m_unicastListener;
    private boolean m_keepListening;

    Client(Socket clnt) throws IOException {
        this.m_name = "DHCPClient-TCP-" + clnt.getPort();
        this.m_client = clnt;
        this.m_worker = null;
        this.m_status = 0;
        this.m_sender = new DatagramSocket();
        ThreadCategory.getInstance(this.getClass()).debug((Object)("Client.ctor: outgoing udp socket port: " + this.m_sender.getLocalPort()));
        this.m_unicastListener = new UnicastListener(this.m_sender, this);
        this.m_keepListening = true;
        this.m_objsOut = new ObjectOutputStream(this.m_client.getOutputStream());
        this.m_objsOut.reset();
        this.m_objsOut.flush();
    }

    void sendMessage(Message msg) throws IOException {
        this.m_objsOut.writeObject(msg);
        this.m_objsOut.flush();
    }

    public synchronized void start() {
        if (this.m_worker != null) {
            throw new IllegalStateException("The fiber has already been started");
        }
        this.m_unicastListener.start();
        this.m_worker = new Thread((Runnable)this, this.getName());
        this.m_worker.setDaemon(true);
        this.m_worker.start();
        this.m_status = 1;
    }

    public synchronized void stop() {
        this.m_status = 3;
        try {
            this.m_objsOut.close();
            this.m_client.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_sender.close();
        this.m_worker.interrupt();
    }

    public synchronized int getStatus() {
        return this.m_status;
    }

    public String getName() {
        return this.m_name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Category log = ThreadCategory.getInstance(this.getClass());
        boolean isOk = true;
        ObjectInputStream input = null;
        try {
            input = new ObjectInputStream(this.m_client.getInputStream());
        }
        catch (IOException ex) {
            log.warn((Object)"Failed to read client's input stream", (Throwable)ex);
            isOk = false;
        }
        if (isOk) {
            Client ex = this;
            synchronized (ex) {
                this.m_status = 2;
            }
        }
        while (isOk && this.m_status == 2) {
            try {
                Message msg = (Message)input.readObject();
                if (msg.getAddress().equals(NULL_ADDR)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Got disconnect request from Poller corresponding to sending port " + this.m_sender.getLocalPort()));
                    }
                    isOk = false;
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Got request... adress = " + msg.getAddress()));
                }
                byte[] dhcp = msg.getMessage().externalize();
                DatagramPacket pkt = new DatagramPacket(dhcp, dhcp.length, msg.getAddress(), 67);
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("sending request on port: " + this.m_sender.getLocalPort()));
                    }
                    this.m_sender.send(pkt);
                }
                catch (IOException ex) {
                }
            }
            catch (ClassNotFoundException ex) {
                log.warn((Object)"Failed to read message, no class found", (Throwable)ex);
                isOk = false;
            }
            catch (IOException ex) {
                log.warn((Object)"Failed to read message, I/O error", (Throwable)ex);
                isOk = false;
            }
            catch (ClassCastException ex) {
                log.warn((Object)"Failed to read an appropriate message", (Throwable)ex);
                isOk = false;
            }
            catch (Throwable t) {
                log.warn((Object)"Undeclared throwable caught", t);
                isOk = false;
            }
        }
        Client t = this;
        synchronized (t) {
            this.m_status = 3;
        }
        this.m_keepListening = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)("run: waiting for UnicastListener thread " + this.getName() + " to die..."));
        }
        try {
            this.m_unicastListener.join();
        }
        catch (InterruptedException e) {
            log.debug((Object)("run: interrupted while waiting for UnicastListener thread " + this.getName() + " to die"), (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("run: UnicastListener thread " + this.getName() + " is dead..."));
        }
        this.m_sender.close();
        try {
            input.close();
            this.m_client.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        this.notifyObservers();
        Client client = this;
        synchronized (client) {
            this.m_status = 4;
        }
    }

    static {
        try {
            NULL_ADDR = InetAddress.getByName("0.0.0.0");
        }
        catch (UnknownHostException uhE) {
            throw new RuntimeException(uhE.getMessage());
        }
    }

    public final class UnicastListener
    extends Thread {
        DatagramSocket m_incomingUdp;
        Client m_client;

        public UnicastListener(DatagramSocket incoming, Client client2) {
            super("UnicastListener-UDP-" + incoming.getLocalPort());
            ThreadCategory.getInstance(this.getClass()).debug((Object)("constructing UnicastListener-UDP-" + incoming.getLocalPort()));
            this.m_incomingUdp = incoming;
            this.m_client = client2;
        }

        public void run() {
            Category log = ThreadCategory.getInstance(this.getClass());
            if (log.isDebugEnabled()) {
                log.debug((Object)("thread " + this.getName() + " running..."));
            }
            try {
                this.m_incomingUdp.setSoTimeout(1000);
            }
            catch (IOException ioE) {
                log.error((Object)("UnicastListener.run: unable to set socket timeout, reason: " + ioE.getLocalizedMessage()));
                log.debug((Object)ioE);
                Client.this.m_keepListening = true;
            }
            byte[] dgbuf = new byte[2048];
            while (Client.this.m_keepListening) {
                try {
                    DatagramPacket pkt = new DatagramPacket(dgbuf, dgbuf.length);
                    this.m_incomingUdp.receive(pkt);
                    Message msg = new Message(pkt.getAddress(), new DHCPMessage(pkt.getData()));
                    try {
                        this.m_client.sendMessage(msg);
                    }
                    catch (IOException ex) {
                        log.warn((Object)("Error sending unicast response to client " + this.m_client.getName()));
                    }
                }
                catch (InterruptedIOException ex) {
                }
                catch (ArrayIndexOutOfBoundsException oobE) {
                    log.debug((Object)"UnicastListener.run: array out of bounds exception.", (Throwable)oobE);
                    log.warn((Object)("UnicastListener.run: malformed DHCP packet, packet too large for buffer (buffer sz=" + dgbuf.length + "), discarding packet."));
                }
                catch (IOException ioE) {
                    log.error((Object)"UnicastListener.run: io exception receiving response", (Throwable)ioE);
                    Client.this.m_keepListening = false;
                }
                catch (Exception E) {
                    log.error((Object)"UnicastListener.run: exception receiving response", (Throwable)E);
                    Client.this.m_keepListening = false;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("thread " + this.getName() + " exiting..."));
            }
        }
    }
}

