/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.GroupFactory;
import org.opennms.netmgt.config.UserManager;

public class UserFactory
extends UserManager {
    private static UserManager instance;
    protected File usersFile;
    private static boolean initialized;
    private File m_usersConfFile;
    private long m_lastModified;

    public UserFactory() throws MarshalException, ValidationException, FileNotFoundException, IOException {
        super(GroupFactory.getInstance());
        this.reload();
    }

    public static synchronized void init() throws IOException, FileNotFoundException, MarshalException, ValidationException {
        if (instance == null || !initialized) {
            GroupFactory.init();
            instance = new UserFactory();
            initialized = true;
        }
    }

    public static synchronized UserManager getInstance() {
        return instance;
    }

    public static synchronized void setInstance(UserManager mgr) {
        initialized = true;
        instance = mgr;
    }

    public void reload() throws IOException, FileNotFoundException, MarshalException, ValidationException {
        this.m_usersConfFile = ConfigFileConstants.getFile((int)ConfigFileConstants.USERS_CONF_FILE_NAME);
        FileInputStream configIn = new FileInputStream(this.m_usersConfFile);
        this.m_lastModified = this.m_usersConfFile.lastModified();
        InputStreamReader reader = new InputStreamReader(configIn);
        this.parseXML(reader);
        initialized = true;
    }

    protected void saveXML(String writerString) throws IOException {
        if (writerString != null) {
            FileWriter fileWriter = new FileWriter(this.m_usersConfFile);
            fileWriter.write(writerString);
            fileWriter.flush();
            fileWriter.close();
        }
    }

    public boolean isUpdateNeeded() {
        if (this.m_usersConfFile == null) {
            return true;
        }
        return this.m_lastModified != this.m_usersConfFile.lastModified();
    }

    protected void update() throws IOException, FileNotFoundException, MarshalException, ValidationException {
        if (this.isUpdateNeeded()) {
            this.reload();
        }
    }

    static {
        initialized = false;
    }
}

