/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.scriptd.Engine;
import org.opennms.netmgt.config.scriptd.EventScript;
import org.opennms.netmgt.config.scriptd.ReloadScript;
import org.opennms.netmgt.config.scriptd.ScriptdConfiguration;
import org.opennms.netmgt.config.scriptd.StartScript;
import org.opennms.netmgt.config.scriptd.StopScript;

public final class ScriptdConfigFactory {
    private static ScriptdConfigFactory m_singleton = null;
    private ScriptdConfiguration m_config;
    private static boolean m_loaded = false;

    private ScriptdConfigFactory(String configFile) throws IOException, MarshalException, ValidationException {
        FileInputStream cfgIn = new FileInputStream(configFile);
        this.m_config = (ScriptdConfiguration)Unmarshaller.unmarshal(ScriptdConfiguration.class, (Reader)new InputStreamReader(cfgIn));
        ((InputStream)cfgIn).close();
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.SCRIPTD_CONFIG_FILE_NAME);
        m_singleton = new ScriptdConfigFactory(cfgFile.getPath());
        m_loaded = true;
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        m_singleton = null;
        m_loaded = false;
        ScriptdConfigFactory.init();
    }

    public static synchronized ScriptdConfigFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public synchronized Engine[] getEngines() {
        return this.m_config.getEngine();
    }

    public synchronized StartScript[] getStartScripts() {
        return this.m_config.getStartScript();
    }

    public synchronized StopScript[] getStopScripts() {
        return this.m_config.getStopScript();
    }

    public synchronized ReloadScript[] getReloadScripts() {
        return this.m_config.getReloadScript();
    }

    public synchronized EventScript[] getEventScripts() {
        return this.m_config.getEventScript();
    }
}

