/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.rtc.RTCConfiguration;

public final class RTCConfigFactory {
    private static RTCConfigFactory m_singleton = null;
    private RTCConfiguration m_config;
    private static boolean m_loaded = false;

    private long parseRollingWindow(String rolling) throws IllegalArgumentException {
        String hrStr = null;
        String minStr = null;
        String secStr = null;
        rolling.toLowerCase();
        int hIndex = rolling.indexOf(104);
        int mIndex = rolling.indexOf(109);
        int sIndex = rolling.indexOf(115);
        if (hIndex != -1) {
            hrStr = rolling.substring(0, hIndex);
        }
        if (mIndex != -1) {
            if (hIndex != -1) {
                if (hIndex >= mIndex) {
                    throw new IllegalArgumentException("RTC: Value " + rolling + " - format incorrect");
                }
                minStr = rolling.substring(hIndex + 1, mIndex);
            } else {
                minStr = rolling.substring(0, mIndex);
            }
        }
        if (sIndex != -1) {
            if (mIndex != -1) {
                if (mIndex >= sIndex) {
                    throw new IllegalArgumentException("RTC: Value " + rolling + " - format incorrect");
                }
                secStr = rolling.substring(mIndex + 1, sIndex);
            } else if (hIndex != -1) {
                if (hIndex >= sIndex) {
                    throw new IllegalArgumentException("RTC: Value " + rolling + " - format incorrect");
                }
                secStr = rolling.substring(hIndex + 1, sIndex);
            } else {
                secStr = rolling.substring(0, sIndex);
            }
        }
        int hours = 0;
        int min = 0;
        int sec = 0;
        try {
            if (hrStr != null) {
                hours = Integer.parseInt(hrStr);
            }
            if (minStr != null) {
                min = Integer.parseInt(minStr);
            }
            if (secStr != null) {
                sec = Integer.parseInt(secStr);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("RTC: Value " + rolling + " - format incorrect");
        }
        return (long)(hours * 3600 + min * 60 + sec) * 1000L;
    }

    private RTCConfigFactory(String configFile) throws IOException, MarshalException, ValidationException {
        FileReader reader = new FileReader(configFile);
        this.marshal(reader);
        reader.close();
    }

    public RTCConfigFactory(Reader reader) throws IOException, MarshalException, ValidationException {
        this.marshal(reader);
    }

    private void marshal(Reader reader) throws MarshalException, ValidationException {
        this.m_config = (RTCConfiguration)Unmarshaller.unmarshal(RTCConfiguration.class, (Reader)reader);
    }

    public static void setInstance(RTCConfigFactory instance) {
        m_singleton = instance;
        m_loaded = true;
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.RTC_CONFIG_FILE_NAME);
        RTCConfigFactory.setInstance(new RTCConfigFactory(cfgFile.getPath()));
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        m_singleton = null;
        m_loaded = false;
        RTCConfigFactory.init();
    }

    public static synchronized RTCConfigFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public synchronized int getUpdaters() {
        return this.m_config.getUpdaters();
    }

    public synchronized int getSenders() {
        return this.m_config.getSenders();
    }

    public synchronized String getRollingWindowStr() {
        return this.m_config.getRollingWindow();
    }

    public synchronized long getRollingWindow() {
        return this.parseRollingWindow(this.m_config.getRollingWindow());
    }

    public synchronized int getMaxEventsBeforeResend() {
        return this.m_config.getMaxEventsBeforeResend();
    }

    public synchronized String getLowThresholdIntervalStr() {
        return this.m_config.getLowThresholdInterval();
    }

    public synchronized long getLowThresholdInterval() {
        return this.parseRollingWindow(this.m_config.getLowThresholdInterval());
    }

    public synchronized String getHighThresholdIntervalStr() {
        return this.m_config.getHighThresholdInterval();
    }

    public synchronized long getHighThresholdInterval() {
        return this.parseRollingWindow(this.m_config.getHighThresholdInterval());
    }

    public synchronized String getUserRefreshIntervalStr() {
        return this.m_config.getUserRefreshInterval();
    }

    public synchronized long getUserRefreshInterval() {
        return this.parseRollingWindow(this.m_config.getUserRefreshInterval());
    }

    public synchronized int getErrorsBeforeUrlUnsubscribe() {
        return this.m_config.getErrorsBeforeUrlUnsubscribe();
    }
}

