/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.InputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.notificationCommands.Command;
import org.opennms.netmgt.config.notificationCommands.NotificationCommands;
import org.opennms.netmgt.dao.castor.CastorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NotificationCommandManager {
    private Map<String, Command> m_commands;
    protected InputStream configIn;

    protected void parseXML(Reader reader) throws MarshalException, ValidationException {
        NotificationCommands config = this.getXML(reader);
        HashMap<String, Command> commands = new HashMap<String, Command>();
        for (Command curCommand : this.getCommandsFromConfig(config)) {
            if (curCommand != null && curCommand.getName() != null) {
                commands.put(curCommand.getName(), curCommand);
                continue;
            }
            this.log().warn((Object)("invalid notification command: " + curCommand));
        }
        this.m_commands = commands;
    }

    private NotificationCommands getXML(Reader reader) throws MarshalException, ValidationException {
        return (NotificationCommands)CastorUtils.unmarshal(NotificationCommands.class, (Reader)reader);
    }

    private List<Command> getCommandsFromConfig(NotificationCommands config) {
        if (config == null) {
            this.log().warn((Object)"no notification commands found");
            return Collections.emptyList();
        }
        return config.getCommandCollection();
    }

    private Category log() {
        return ThreadCategory.getInstance(NotificationCommandManager.class);
    }

    public Command getCommand(String name) {
        return this.m_commands.get(name);
    }

    public Map<String, Command> getCommands() {
        return this.m_commands;
    }
}

