/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.monitoringLocations.LocationDef;
import org.opennms.netmgt.config.monitoringLocations.MonitoringLocationsConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitoringLocationsFactory {
    private static MonitoringLocationsFactory m_instance;
    private static boolean m_loadedFromFile;
    protected boolean initialized = false;
    protected static long m_lastModified;
    protected static Map<String, LocationDef> m_defsMap;
    private static MonitoringLocationsConfiguration m_config;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MonitoringLocationsFactory(String configFile) throws MarshalException, ValidationException, IOException {
        InputStreamReader rdr = new InputStreamReader(new FileInputStream(configFile));
        try {
            this.initialize(rdr);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            rdr.close();
            throw throwable;
        }
        rdr.close();
    }

    public MonitoringLocationsFactory(Reader rdr) throws MarshalException, ValidationException {
        this.initialize(rdr);
    }

    private void initialize(Reader rdr) throws MarshalException, ValidationException {
        this.log().debug((Object)"initialize: initializing monitoring locations factory.");
        m_config = (MonitoringLocationsConfiguration)Unmarshaller.unmarshal(MonitoringLocationsConfiguration.class, (Reader)rdr);
        m_defsMap = new HashMap<String, LocationDef>();
        List defList = m_config.getLocations().getLocationDefCollection();
        for (LocationDef def : defList) {
            m_defsMap.put(def.getLocationName(), def);
        }
    }

    public static synchronized void init() throws IOException, FileNotFoundException, MarshalException, ValidationException {
        if (m_instance == null) {
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.MONITORING_LOCATIONS_FILE_NAME);
            m_instance = new MonitoringLocationsFactory(cfgFile.getPath());
            m_lastModified = cfgFile.lastModified();
            m_loadedFromFile = true;
        }
    }

    public static synchronized MonitoringLocationsFactory getInstance() {
        if (m_instance == null) {
            throw new IllegalStateException("You must call init() before calling getInstance().");
        }
        return m_instance;
    }

    public static synchronized void setInstance(MonitoringLocationsFactory instance) {
        m_instance = instance;
        m_loadedFromFile = false;
    }

    public synchronized void reload() throws IOException, FileNotFoundException, MarshalException, ValidationException {
        m_instance = null;
        MonitoringLocationsFactory.init();
    }

    public LocationDef getDef(String defName) throws IOException, MarshalException, ValidationException {
        if (defName == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        this.updateFromFile();
        LocationDef def = m_defsMap.get(defName);
        return def;
    }

    protected void updateFromFile() throws IOException, MarshalException, ValidationException {
        File monitoringLocationsFile;
        if (m_loadedFromFile && m_lastModified != (monitoringLocationsFile = ConfigFileConstants.getFile((int)ConfigFileConstants.MONITORING_LOCATIONS_FILE_NAME)).lastModified()) {
            this.reload();
        }
    }

    public static synchronized MonitoringLocationsConfiguration getConfig() {
        return m_config;
    }

    public static synchronized void setConfig(MonitoringLocationsConfiguration m_config) {
        MonitoringLocationsFactory.m_config = m_config;
    }

    public static synchronized Map<String, LocationDef> getDefsMap() {
        return m_defsMap;
    }

    public static synchronized void setDefsMap(Map<String, LocationDef> map) {
        m_defsMap = map;
    }

    private Category log() {
        return ThreadCategory.getInstance();
    }

    static {
        m_loadedFromFile = false;
    }
}

