/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.CapsdConfigManager;

public class DefaultCapsdConfigManager
extends CapsdConfigManager {
    private long m_currentVersion = -1L;

    public DefaultCapsdConfigManager() {
    }

    public DefaultCapsdConfigManager(Reader rdr) throws MarshalException, ValidationException {
        super(rdr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void update() throws IOException, FileNotFoundException, MarshalException, ValidationException {
        File configFile = ConfigFileConstants.getFile((int)ConfigFileConstants.CAPSD_CONFIG_FILE_NAME);
        this.log().debug((Object)("Checking to see if capsd configuration should be reloaded from " + configFile));
        if (this.m_currentVersion < configFile.lastModified()) {
            this.log().debug((Object)"Reloading capsd configuration file");
            long lastModified = configFile.lastModified();
            FileReader rdr = new FileReader(configFile);
            try {
                this.loadXml(rdr);
                Object var6_4 = null;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                IOUtils.closeQuietly((Reader)rdr);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)rdr);
            this.m_currentVersion = lastModified;
            this.log().info((Object)"Reloaded capsd configuration file");
        }
    }

    protected synchronized void saveXml(String xml) throws IOException {
        if (xml != null) {
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.CAPSD_CONFIG_FILE_NAME);
            FileWriter fileWriter = new FileWriter(cfgFile);
            fileWriter.write(xml);
            fileWriter.flush();
            fileWriter.close();
        }
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

