/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import org.opennms.netmgt.collectd.ResourceType;
import org.opennms.netmgt.collectd.ServiceParameters;
import org.opennms.netmgt.collectd.SnmpCollectionResource;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.snmp.SnmpInstId;

public class GenericIndexResource
extends SnmpCollectionResource {
    private SnmpInstId m_inst;
    private String m_name;

    public GenericIndexResource(ResourceType def, String name, SnmpInstId inst) {
        super(def);
        this.m_name = name;
        this.m_inst = inst;
    }

    public File getResourceDir(RrdRepository repository) {
        File rrdBaseDir = repository.getRrdBaseDir();
        File nodeDir = new File(rrdBaseDir, String.valueOf(this.getCollectionAgent().getNodeId()));
        File typeDir = new File(nodeDir, this.m_name);
        File instDir = new File(typeDir, this.m_inst.toString());
        this.log().debug((Object)("getResourceDir: " + instDir.toString()));
        return instDir;
    }

    public String toString() {
        return "node[" + this.getCollectionAgent().getNodeId() + "]." + this.getResourceTypeName() + "[" + this.m_inst + "]";
    }

    public int getType() {
        return -1;
    }

    public boolean shouldPersist(ServiceParameters params) {
        return true;
    }

    public String getResourceTypeName() {
        return this.m_name;
    }

    public String getInstance() {
        return this.m_inst.toString();
    }
}

