/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.util.Map;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.AbstractPlugin;
import org.opennms.netmgt.utils.ParameterMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MSExchangePlugin
extends AbstractPlugin {
    private static final String PROTOCOL_NAME = "MSExchange";
    private static final String BANNER_STRING = "Microsoft Exchange";
    private static final int DEFAULT_POP3_PORT = 110;
    private static final int DEFAULT_IMAP_PORT = 143;
    private static final int DEFAULT_MAPI_PORT = 593;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 5000;
    private static final int POP3_INDEX = 0;
    private static final int IMAP_INDEX = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean isServer(InetAddress host, int port, int retries, int timeout) {
        Category log = ThreadCategory.getInstance(this.getClass());
        boolean isAServer = false;
        for (int attempts = 0; attempts <= retries && !isAServer; ++attempts) {
            Socket socket;
            block17: {
                int rc;
                socket = null;
                socket = new Socket();
                socket.connect(new InetSocketAddress(host, port), timeout);
                socket.setSoTimeout(timeout);
                log.debug((Object)("MSExchangePlugin: connected to host: " + host + " on port: " + port));
                BufferedReader lineRdr = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                String banner = lineRdr.readLine();
                if (banner == null || (rc = banner.indexOf(BANNER_STRING)) <= -1) break block17;
                isAServer = true;
            }
            Object var13_17 = null;
            try {
                if (socket == null) continue;
                socket.close();
                socket = null;
            }
            catch (IOException e2) {}
            continue;
            {
                catch (ConnectException e) {
                    log.debug((Object)("isServer: Connection refused to " + host.getHostAddress() + ":" + port));
                    var13_17 = null;
                    try {
                        if (socket == null) continue;
                        socket.close();
                        socket = null;
                    }
                    catch (IOException e2) {}
                    continue;
                }
                catch (NoRouteToHostException e) {
                    e.fillInStackTrace();
                    log.info((Object)("isServer: Failed to connect to host " + host.getHostAddress() + ", no route to host"), (Throwable)e);
                    throw new UndeclaredThrowableException(e);
                }
                catch (InterruptedIOException e) {
                    log.debug((Object)("MSExchangePlugin: did not connect to host within timeout: " + timeout + " attempt: " + attempts));
                    var13_17 = null;
                    try {
                        if (socket == null) continue;
                        socket.close();
                        socket = null;
                    }
                    catch (IOException e2) {}
                    continue;
                }
                catch (IOException e) {
                    log.info((Object)("isServer: Unexpected I/O exception occured with host " + host.getHostAddress() + " on port " + port), (Throwable)e);
                    var13_17 = null;
                    try {
                        if (socket == null) continue;
                        socket.close();
                        socket = null;
                    }
                    catch (IOException e2) {}
                    continue;
                }
                catch (Throwable t) {
                    log.error((Object)("isServer: Undeclared throwable caught communicating with host " + host.getHostAddress() + " on port " + port), t);
                    var13_17 = null;
                    try {
                        if (socket == null) continue;
                        socket.close();
                        socket = null;
                    }
                    catch (IOException e2) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var13_17 = null;
                try {
                    if (socket != null) {
                        socket.close();
                        socket = null;
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return isAServer;
    }

    private boolean[] isServer(InetAddress host, int[] ports, int retries, int timeout) {
        boolean isExPop3 = false;
        boolean isExImap = false;
        boolean isExMapi = false;
        if (ports[0] > 0) {
            isExPop3 = this.isServer(host, ports[0], retries, timeout);
        }
        if (ports[1] > 0) {
            isExImap = this.isServer(host, ports[1], retries, timeout);
        }
        return new boolean[]{isExPop3, isExImap, isExMapi};
    }

    @Override
    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    @Override
    public boolean isProtocolSupported(InetAddress address) {
        boolean[] result = this.isServer(address, new int[]{110, 143, 593}, 0, 5000);
        return result[0] || result[1] || result[2];
    }

    @Override
    public boolean isProtocolSupported(InetAddress address, Map<String, Object> qualifiers) {
        int retries = 0;
        int timeout = 5000;
        int pop3port = 110;
        int imapport = 143;
        int mapiport = 593;
        if (qualifiers != null) {
            retries = ParameterMap.getKeyedInteger(qualifiers, "retry", 0);
            timeout = ParameterMap.getKeyedInteger(qualifiers, "timeout", 5000);
            pop3port = ParameterMap.getKeyedInteger(qualifiers, "pop3 port", 110);
            imapport = ParameterMap.getKeyedInteger(qualifiers, "imap port", 143);
            mapiport = ParameterMap.getKeyedInteger(qualifiers, "mapi port", 593);
        }
        boolean[] result = this.isServer(address, new int[]{pop3port, imapport, mapiport}, retries, timeout);
        if (qualifiers != null) {
            if (result[0] && !qualifiers.containsKey("pop3 port")) {
                qualifiers.put("pop3 port", new Integer(pop3port));
            }
            if (result[1] && !qualifiers.containsKey("imap port")) {
                qualifiers.put("imap port", new Integer(imapport));
            }
            if (result[2] && !qualifiers.containsKey("mapi port")) {
                qualifiers.put("mapi port", new Integer(mapiport));
            }
        }
        return result[0] || result[1] || result[2];
    }
}

