/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Category;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.capsd.CapsdDbSyncer;
import org.opennms.netmgt.config.CapsdConfig;
import org.opennms.netmgt.config.CollectdConfigFactory;
import org.opennms.netmgt.config.OpennmsServerConfigFactory;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.poller.Package;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcCapsdDbSyncer
implements InitializingBean,
CapsdDbSyncer {
    private static final String SQL_DB_RETRIEVE_IP_INTERFACE = "SELECT ip.nodeid, ip.ipaddr, ip.ismanaged FROM ipinterface as ip JOIN node as n ON ip.nodeid = n.nodeid WHERE ip.ipaddr!='0.0.0.0' AND ip.isManaged!='D' AND ip.isManaged!='F' AND n.foreignSource is null";
    private static final String SQL_DB_RETRIEVE_IP_INTERFACE_IN_LOCAL_SERVER = "SELECT ip.nodeid, ip.ipaddr, ip.ismanaged FROM ipinterface as ip JOIN node as n ON n.nodeid = ip.nodeid JOIN servermap as s ON ip.ipaddr = s.ipaddr WHERE ip.ipaddr!='0.0.0.0' AND ip.isManaged!='D' AND ip.isManaged!='F' AND s.servername = ? AND n.foreignSource is null";
    private static final String SQL_DB_RETRIEVE_SNMP_IP_INTERFACES = "SELECT DISTINCT ipinterface.nodeid,ipinterface.ipaddr,ipinterface.ifindex,ipinterface.issnmpprimary,snmpinterface.snmpiftype,snmpinterface.snmpifindex FROM ipinterface JOIN node ON node.nodeid = ipinterface.nodeid JOIN snmpinterface ON ipinterface.snmpinterfaceid = snmpinterface.id JOIN ifservices ON ifservices.ipinterfaceid = ipinterface.id JOIN service ON ifservices.serviceid = service.serviceid WHERE ipinterface.ismanaged!='D' AND ifservices.status != 'D' AND service.servicename='SNMP' AND node.foreignSource is null";
    private static final String SQL_DB_UPDATE_SNMP_PRIMARY_STATE = "UPDATE ipinterface SET issnmpprimary=? WHERE nodeid=? AND ipaddr=? AND ismanaged!='D'";
    private static final String SQL_DB_RETRIEVE_IF_SERVICES = "SELECT serviceid, status FROM ifservices WHERE nodeid=? AND ipaddr=? AND status!='D' AND status!='F'";
    private static final String SQL_DB_UPDATE_IP_INTERFACE = "UPDATE ipinterface SET ismanaged=? WHERE nodeid=? AND ipaddr=? AND isManaged!='D' AND isManaged!='F'";
    private static final String SQL_DB_UPDATE_ALL_SERVICES_FOR_NIP = "UPDATE ifservices SET status=? WHERE nodeid=? AND ipaddr=? AND status!='D' AND status!='F'";
    private static final String SQL_DB_UPDATE_SERVICE_FOR_NIP = "UPDATE ifservices SET status=? WHERE nodeid=? AND ipaddr=? AND serviceid=? AND status!='D' AND status!='F'";
    private static final String SVCTBL_LOAD_SQL = "SELECT serviceID, serviceName FROM service";
    private static final String SVCTBL_ADD_SQL = "INSERT INTO service (serviceID, serviceName) VALUES (?,?)";
    private static final String DELETE_IFSERVICES_SQL = "update ifservices    set status = 'D'  where serviceid = ?   and id in (   select svc.id     from ifservices as svc     join ipinterface as ip       on (ip.id = svc.ipinterfaceid)     join node as n       on (n.nodeid = ip.nodeid)    where n.foreignsource is null)";
    private static final String DEFAULT_NEXT_SVC_ID_SQL = "SELECT nextval('serviceNxtId')";
    public static final String RETRIEVE_IPADDR_NODEID_SQL = "SELECT ip.nodeid FROM ipinterface as ip JOIN node as n ON ip.nodeid = n.nodeid WHERE ip.ipaddr=? AND ip.ismanaged!='D' AND n.foreignSource is null";
    public static final String RETRIEVE_IPADDR_SQL = "SELECT ip.ipaddr FROM ipinterface as ip JOIN node as n ON ip.nodeid = n.nodeid WHERE ip.ipaddr=? AND ip.ismanaged!='D'AND n.foreignSource is null";
    private CapsdConfig m_capsdConfig;
    private Map<Integer, String> m_serviceIdToName = new HashMap<Integer, String>();
    private Map<String, Integer> m_serviceNameToId = new HashMap<String, Integer>();
    private OpennmsServerConfigFactory m_opennmsServerConfig;
    private CollectdConfigFactory m_collectdConfig;
    private PollerConfig m_pollerConfig;
    private String m_nextSvcIdSql = "SELECT nextval('serviceNxtId')";
    private JdbcTemplate m_jdbcTemplate;

    @Override
    public Integer getServiceId(String name) {
        Assert.notNull((Object)name, (String)"name argument must not be null");
        return this.m_serviceNameToId.get(name);
    }

    @Override
    public String getServiceName(Integer id) {
        Assert.notNull((Object)id, (String)"id argument must not be null");
        return this.m_serviceIdToName.get(id);
    }

    @Override
    public void syncServices() {
        this.m_jdbcTemplate.execute(new ConnectionCallback(){

            public Object doInConnection(Connection con) throws SQLException, DataAccessException {
                JdbcCapsdDbSyncer.this.syncServices(con);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncServices(Connection conn) throws SQLException {
        List<String> serviceNames = this.syncServicesTable(conn);
        PreparedStatement delFromIfServicesStmt = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            List<String> protocols = this.getCapsdConfig().getConfiguredProtocols();
            for (String service : serviceNames) {
                if (protocols.contains(service)) continue;
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("syncServices: service " + service + " exists in the database but not in the Capsd config file."));
                }
                Integer id = this.m_serviceNameToId.get(service);
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("syncServices: deleting all references to service id " + id + " from the IfServices table."));
                }
                delFromIfServicesStmt = conn.prepareStatement(DELETE_IFSERVICES_SQL);
                d.watch((Object)delFromIfServicesStmt);
                delFromIfServicesStmt.setInt(1, id);
                delFromIfServicesStmt.executeUpdate();
                this.log().info((Object)("syncServices: deleted service id " + id + " for service '" + service + "' from the IfServices table."));
            }
        }
        finally {
            d.cleanUp();
        }
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    @Override
    public List<String> syncServicesTable() {
        return (List)this.m_jdbcTemplate.execute(new ConnectionCallback(){

            public Object doInConnection(Connection con) throws SQLException, DataAccessException {
                return JdbcCapsdDbSyncer.this.syncServicesTable(con);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> syncServicesTable(Connection conn) throws SQLException {
        ArrayList<String> serviceNames;
        this.log().debug((Object)"syncServicesTable: synchronizing services list with the database");
        DBUtils d = new DBUtils(this.getClass());
        try {
            PreparedStatement insStmt = conn.prepareStatement(SVCTBL_ADD_SQL);
            d.watch((Object)insStmt);
            PreparedStatement nxtStmt = conn.prepareStatement(this.getNextSvcIdSql());
            d.watch((Object)nxtStmt);
            PreparedStatement loadStmt = conn.prepareStatement(SVCTBL_LOAD_SQL);
            d.watch((Object)loadStmt);
            serviceNames = new ArrayList<String>();
            ResultSet rs = loadStmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                Integer id = new Integer(rs.getInt(1));
                String name = rs.getString(2);
                this.m_serviceIdToName.put(id, name);
                this.m_serviceNameToId.put(name, id);
                serviceNames.add(name);
            }
            for (String protocol : this.getCapsdConfig().getConfiguredProtocols()) {
                this.log().debug((Object)("syncServicesTable: checking protocol '" + protocol + "'."));
                if (serviceNames.contains(protocol)) continue;
                this.log().debug((Object)("syncServicesTable: protocol '" + protocol + "' is not in the database... adding."));
                rs = nxtStmt.executeQuery();
                d.watch((Object)rs);
                rs.next();
                int id = rs.getInt(1);
                rs.close();
                this.log().debug((Object)("syncServicesTable: using id " + id + " for protocol '" + protocol + "'."));
                insStmt.setInt(1, id);
                insStmt.setString(2, protocol);
                insStmt.executeUpdate();
                Integer xid = new Integer(id);
                this.m_serviceIdToName.put(xid, protocol);
                this.m_serviceNameToId.put(protocol, xid);
                serviceNames.add(protocol);
                this.log().info((Object)("syncServicesTable: added service entry to the database for protocol '" + protocol + "' with id of  " + id));
            }
        }
        finally {
            d.cleanUp();
        }
        return serviceNames;
    }

    @Override
    public void syncManagementState() {
        this.m_jdbcTemplate.execute(new ConnectionCallback(){

            public Object doInConnection(Connection con) throws SQLException, DataAccessException {
                JdbcCapsdDbSyncer.this.syncManagementState(con);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncManagementState(Connection conn) throws SQLException {
        boolean managedByDefault;
        boolean verifyServer = this.getOpennmsServerConfig().verifyServer();
        String localServer = this.getOpennmsServerConfig().getServerName();
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("syncManagementState: local server: " + localServer + " verify server: " + verifyServer));
        }
        if (conn == null) {
            this.log().error((Object)"CapsdConfigFactory.syncManagementState: Sync failed...must have valid database connection.");
            return;
        }
        String managementPolicy = this.getCapsdConfig().getConfiguration().getManagementPolicy();
        boolean bl = managedByDefault = managementPolicy == null || managementPolicy.equalsIgnoreCase("managed");
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("syncManagementState: managed_by_default: " + managedByDefault));
        }
        PreparedStatement ipRetStmt = null;
        DBUtils d = new DBUtils(this.getClass());
        ArrayList<LightWeightIfEntry> ifList = new ArrayList<LightWeightIfEntry>();
        try {
            if (verifyServer) {
                ipRetStmt = conn.prepareStatement(SQL_DB_RETRIEVE_IP_INTERFACE_IN_LOCAL_SERVER);
                d.watch((Object)ipRetStmt);
                ipRetStmt.setString(1, localServer);
            } else {
                ipRetStmt = conn.prepareStatement(SQL_DB_RETRIEVE_IP_INTERFACE);
                d.watch((Object)ipRetStmt);
            }
            ResultSet result = null;
            result = ipRetStmt.executeQuery();
            d.watch((Object)result);
            while (result.next()) {
                int nodeId = result.getInt(1);
                String address = result.getString(2);
                if (address == null) {
                    this.log().warn((Object)"invalid ipInterface table entry, no IP address, skipping...");
                    continue;
                }
                char managedState = ' ';
                String str = result.getString(3);
                if (str != null) {
                    managedState = str.charAt(0);
                }
                ifList.add(new LightWeightIfEntry(nodeId, -1, address, managedState, ' ', -1));
            }
        }
        finally {
            d.cleanUp();
        }
        try {
            PreparedStatement ifUpdateStmt = conn.prepareStatement(SQL_DB_UPDATE_IP_INTERFACE);
            d.watch((Object)ifUpdateStmt);
            PreparedStatement allSvcUpdateStmt = conn.prepareStatement(SQL_DB_UPDATE_ALL_SERVICES_FOR_NIP);
            d.watch((Object)allSvcUpdateStmt);
            PreparedStatement svcRetStmt = conn.prepareStatement(SQL_DB_RETRIEVE_IF_SERVICES);
            d.watch((Object)svcRetStmt);
            PreparedStatement svcUpdateStmt = conn.prepareStatement(SQL_DB_UPDATE_SERVICE_FOR_NIP);
            d.watch((Object)svcUpdateStmt);
            for (LightWeightIfEntry ifEntry : ifList) {
                String ipaddress = ifEntry.getAddress();
                InetAddress ifAddress = null;
                try {
                    ifAddress = InetAddress.getByName(ipaddress);
                }
                catch (UnknownHostException uhE) {
                    this.log().warn((Object)("Failed converting ip address " + ipaddress + " to InetAddress."));
                    continue;
                }
                boolean address_is_unmanaged = this.getCapsdConfig().isAddressUnmanaged(ifAddress);
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("syncManagementState: " + ipaddress + " unmanaged based on capsd config?: " + address_is_unmanaged));
                }
                if (address_is_unmanaged) {
                    if (ifEntry.getManagementState() == 'U') continue;
                    ifUpdateStmt.setString(1, new String(new char[]{'U'}));
                    ifUpdateStmt.setInt(2, ifEntry.getNodeId());
                    ifUpdateStmt.setString(3, ipaddress);
                    ifUpdateStmt.executeUpdate();
                    allSvcUpdateStmt.setString(1, new String(new char[]{'U'}));
                    allSvcUpdateStmt.setInt(2, ifEntry.getNodeId());
                    allSvcUpdateStmt.setString(3, ipaddress);
                    allSvcUpdateStmt.executeUpdate();
                    if (!this.log().isDebugEnabled()) continue;
                    this.log().debug((Object)("syncManagementState: update completed for node/interface: " + ifEntry.getNodeId() + "/" + ipaddress + " to unmanaged"));
                    continue;
                }
                Package ipPkg = this.getPollerConfig().getFirstPackageMatch(ipaddress);
                boolean ipToBePolled = false;
                if (ipPkg != null) {
                    ipToBePolled = true;
                }
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("syncManagementState: " + ipaddress + " to be polled based on poller config?: " + ipToBePolled));
                }
                if (ifEntry.getManagementState() == 'M' && ipToBePolled || ifEntry.getManagementState() == 'N' && !ipToBePolled) {
                    if (this.log().isDebugEnabled()) {
                        this.log().debug((Object)("syncManagementState: " + ipaddress + " - no change in status"));
                    }
                } else {
                    if (ipToBePolled) {
                        ifUpdateStmt.setString(1, new String(new char[]{'M'}));
                    } else {
                        ifUpdateStmt.setString(1, new String(new char[]{'N'}));
                    }
                    ifUpdateStmt.setInt(2, ifEntry.getNodeId());
                    ifUpdateStmt.setString(3, ipaddress);
                    ifUpdateStmt.executeUpdate();
                    if (this.log().isDebugEnabled()) {
                        this.log().debug((Object)("syncManagementState: update completed for node/interface: " + ifEntry.getNodeId() + "/" + ipaddress));
                    }
                }
                svcRetStmt.setInt(1, ifEntry.getNodeId());
                svcRetStmt.setString(2, ipaddress);
                ResultSet svcRS = svcRetStmt.executeQuery();
                d.watch((Object)svcRS);
                while (svcRS.next()) {
                    int svcId = svcRS.getInt(1);
                    char svcStatus = ' ';
                    String str = svcRS.getString(2);
                    if (str != null) {
                        svcStatus = str.charAt(0);
                    }
                    String svcName = this.getServiceName(new Integer(svcId));
                    char oldStatus = svcStatus;
                    char newStatus = 'U';
                    boolean svcToBePolledLocally = this.isServicePolledLocally(ipaddress, svcName, ipPkg);
                    boolean svcToBePolledRemotely = this.isServicePolled(ipaddress, svcName, ipPkg);
                    if (this.log().isDebugEnabled()) {
                        this.log().debug((Object)("syncManagementState: " + ipaddress + "/" + svcName + " to be polled based on poller config?: " + svcToBePolledLocally));
                    }
                    if (svcStatus == 'A' && svcToBePolledLocally || svcStatus == 'N' && !ipToBePolled) {
                        if (!this.log().isDebugEnabled()) continue;
                        this.log().debug((Object)("syncManagementState: " + ifEntry.getNodeId() + "/" + ipaddress + "/" + svcName + " status = " + svcStatus + " - no change in status"));
                        continue;
                    }
                    if (svcStatus == 'S' && svcToBePolledLocally) {
                        svcUpdateStmt.setString(1, new String(new char[]{'F'}));
                        newStatus = 'F';
                    } else if (svcToBePolledLocally) {
                        svcUpdateStmt.setString(1, new String(new char[]{'A'}));
                        newStatus = 'A';
                    } else if (svcToBePolledRemotely) {
                        svcUpdateStmt.setString(1, new String(new char[]{'X'}));
                        newStatus = 'X';
                    } else {
                        svcUpdateStmt.setString(1, new String(new char[]{'N'}));
                        newStatus = 'N';
                    }
                    svcUpdateStmt.setInt(2, ifEntry.getNodeId());
                    svcUpdateStmt.setString(3, ipaddress);
                    svcUpdateStmt.setInt(4, svcId);
                    svcUpdateStmt.executeUpdate();
                    if (!this.log().isDebugEnabled()) continue;
                    this.log().debug((Object)("syncManagementState: update completed for node/interface/svc: " + ifEntry.getNodeId() + "/" + ipaddress + "/" + svcName + " status changed from " + oldStatus + " to " + newStatus));
                }
            }
        }
        finally {
            d.cleanUp();
        }
    }

    private boolean isServicePolled(String ifAddr, String svcName, Package ipPkg) {
        boolean svcToBePolled = false;
        if (ipPkg != null && !(svcToBePolled = this.getPollerConfig().isPolled(svcName, ipPkg))) {
            svcToBePolled = this.getPollerConfig().isPolled(ifAddr, svcName);
        }
        return svcToBePolled;
    }

    private boolean isServicePolledLocally(String ifAddr, String svcName, Package ipPkg) {
        boolean svcToBePolled = false;
        if (ipPkg != null && !ipPkg.getRemote() && !(svcToBePolled = this.getPollerConfig().isPolled(svcName, ipPkg))) {
            svcToBePolled = this.getPollerConfig().isPolledLocally(ifAddr, svcName);
        }
        return svcToBePolled;
    }

    @Override
    public void syncSnmpPrimaryState() {
        this.m_jdbcTemplate.execute(new ConnectionCallback(){

            public Object doInConnection(Connection con) throws SQLException, DataAccessException {
                JdbcCapsdDbSyncer.this.syncSnmpPrimaryState(con);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void syncSnmpPrimaryState(Connection conn) throws SQLException {
        if (conn == null) {
            throw new IllegalArgumentException("Sync failed...must have valid database connection.");
        }
        this.log().debug((Object)"syncSnmpPrimaryState: building map of nodes to interfaces...");
        HashMap nodes = new HashMap();
        DBUtils d = new DBUtils(this.getClass());
        try {
            PreparedStatement ipRetStmt = conn.prepareStatement(SQL_DB_RETRIEVE_SNMP_IP_INTERFACES);
            d.watch((Object)ipRetStmt);
            ResultSet result = ipRetStmt.executeQuery();
            d.watch((Object)result);
            List<LightWeightIfEntry> ifList = new ArrayList();
            while (result.next()) {
                int nodeId = result.getInt(1);
                String address = result.getString(2);
                if (address == null) {
                    this.log().warn((Object)"invalid ipInterface table entry, no IP address, skipping...");
                    continue;
                }
                int ifIndex = result.getInt(6);
                if (result.wasNull()) {
                    if (this.log().isDebugEnabled()) {
                        this.log().debug((Object)("ipInterface table entry for address " + address + " does not have a valid ifIndex "));
                    }
                    ifIndex = -1;
                } else if (ifIndex < 1) {
                    if (ifIndex == -100) {
                        if (this.log().isDebugEnabled()) {
                            this.log().debug((Object)("Using ifIndex = -100 for address " + address));
                        }
                    } else {
                        if (this.log().isDebugEnabled()) {
                            this.log().debug((Object)("ipInterface table entry for address " + address + " does not have a valid ifIndex "));
                        }
                        ifIndex = -1;
                    }
                }
                char primarySnmpState = ' ';
                String str = result.getString(4);
                if (str != null) {
                    primarySnmpState = str.charAt(0);
                }
                int ifType = result.getInt(5);
                if (result.wasNull()) {
                    if (this.log().isDebugEnabled()) {
                        this.log().debug((Object)("snmpInterface table entry for address " + address + " does not have a valid ifType"));
                    }
                    ifType = -1;
                }
                if ((ifList = (List)nodes.get(new Integer(nodeId))) == null) {
                    ifList = new ArrayList();
                    ifList.add(new LightWeightIfEntry(nodeId, ifIndex, address, ' ', primarySnmpState, ifType));
                    nodes.put(new Integer(nodeId), ifList);
                    continue;
                }
                ifList.add(new LightWeightIfEntry(nodeId, ifIndex, address, ' ', primarySnmpState, ifType));
            }
        }
        finally {
            d.cleanUp();
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("syncSnmpPrimaryState: iterating over nodes in map and checking primary SNMP interface, node count: " + nodes.size()));
        }
        for (Integer nId : nodes.keySet()) {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("building SNMP address list for node " + nId));
            }
            List ifEntries = (List)nodes.get(nId);
            ArrayList<InetAddress> addressList = new ArrayList<InetAddress>();
            ArrayList<InetAddress> lbAddressList = new ArrayList<InetAddress>();
            for (LightWeightIfEntry lwIf : ifEntries) {
                if (lwIf.getIfIndex() == -1) {
                    if (!this.log().isDebugEnabled()) continue;
                    this.log().debug((Object)("skipping address " + lwIf.getAddress() + ": does not have a valid ifIndex."));
                    continue;
                }
                try {
                    InetAddress addr = InetAddress.getByName(lwIf.getAddress());
                    addressList.add(addr);
                    if (lwIf.getIfType() != 24) continue;
                    lbAddressList.add(addr);
                }
                catch (UnknownHostException uhe) {
                    this.log().warn((Object)("Unknown host exception for " + lwIf.getAddress()), (Throwable)uhe);
                }
            }
            boolean strict = true;
            InetAddress primarySnmpIf = null;
            String psiType = null;
            if (lbAddressList != null) {
                primarySnmpIf = this.getCapsdConfig().determinePrimarySnmpInterface(lbAddressList, strict);
                psiType = ConfigFileConstants.getFileName((int)ConfigFileConstants.COLLECTD_CONFIG_FILE_NAME) + " loopback addresses";
            }
            if (primarySnmpIf == null) {
                primarySnmpIf = this.getCapsdConfig().determinePrimarySnmpInterface(addressList, strict);
                psiType = ConfigFileConstants.getFileName((int)ConfigFileConstants.COLLECTD_CONFIG_FILE_NAME) + " addresses";
            }
            strict = false;
            if (primarySnmpIf == null && lbAddressList != null) {
                primarySnmpIf = this.getCapsdConfig().determinePrimarySnmpInterface(lbAddressList, strict);
                psiType = "DB loopback addresses";
            }
            if (primarySnmpIf == null) {
                primarySnmpIf = this.getCapsdConfig().determinePrimarySnmpInterface(addressList, strict);
                psiType = "DB addresses";
            }
            if (this.log().isDebugEnabled()) {
                if (primarySnmpIf == null) {
                    this.log().debug((Object)("syncSnmpPrimaryState: No primary SNMP interface found for node " + nId));
                } else {
                    this.log().debug((Object)("syncSnmpPrimaryState: primary SNMP interface for node " + nId + " is: " + primarySnmpIf + ", selected from " + psiType));
                }
            }
            for (LightWeightIfEntry lwIf : ifEntries) {
                if (lwIf.getIfIndex() == -1) {
                    lwIf.setSnmpPrimaryState('N');
                } else if (primarySnmpIf == null || !lwIf.getAddress().equals(primarySnmpIf.getHostAddress())) {
                    if (this.getCollectdConfig().isServiceCollectionEnabled(lwIf.getAddress(), "SNMP")) {
                        lwIf.setSnmpPrimaryState('S');
                    } else {
                        lwIf.setSnmpPrimaryState('N');
                    }
                } else {
                    lwIf.setSnmpPrimaryState('P');
                }
                if (!lwIf.hasSnmpPrimaryStateChanged()) continue;
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("syncSnmpPrimaryState: updating " + lwIf.getNodeId() + "/" + lwIf.getAddress() + ", marking with state: " + lwIf.getSnmpPrimaryState()));
                }
                try {
                    PreparedStatement updateStmt = conn.prepareStatement(SQL_DB_UPDATE_SNMP_PRIMARY_STATE);
                    d.watch((Object)updateStmt);
                    updateStmt.setString(1, new String(new char[]{lwIf.getSnmpPrimaryState()}));
                    updateStmt.setInt(2, lwIf.getNodeId());
                    updateStmt.setString(3, lwIf.getAddress());
                    updateStmt.executeUpdate();
                }
                finally {
                    d.cleanUp();
                }
            }
        }
        this.log().debug((Object)"syncSnmpPrimaryState: sync completed.");
    }

    public CapsdConfig getCapsdConfig() {
        return this.m_capsdConfig;
    }

    public void setCapsdConfig(CapsdConfig capsdConfig) {
        this.m_capsdConfig = capsdConfig;
    }

    public OpennmsServerConfigFactory getOpennmsServerConfig() {
        return this.m_opennmsServerConfig;
    }

    public void setOpennmsServerConfig(OpennmsServerConfigFactory serverConfigFactory) {
        this.m_opennmsServerConfig = serverConfigFactory;
    }

    public PollerConfig getPollerConfig() {
        return this.m_pollerConfig;
    }

    public void setPollerConfig(PollerConfig pollerConfig) {
        this.m_pollerConfig = pollerConfig;
    }

    public CollectdConfigFactory getCollectdConfig() {
        return this.m_collectdConfig;
    }

    public void setCollectdConfig(CollectdConfigFactory collectdConfigFactory) {
        this.m_collectdConfig = collectdConfigFactory;
    }

    public void afterPropertiesSet() {
        Assert.state((this.m_jdbcTemplate != null ? 1 : 0) != 0, (String)"property jdbcTemplate must be set to a non-null value");
        Assert.state((this.m_capsdConfig != null ? 1 : 0) != 0, (String)"property capsdConfig must be set to a non-null value");
        Assert.state((this.m_opennmsServerConfig != null ? 1 : 0) != 0, (String)"property opennmsServerConfig must be set to a non-null value");
        Assert.state((this.m_pollerConfig != null ? 1 : 0) != 0, (String)"property pollerConfig must be set to a non-null value");
        Assert.state((this.m_collectdConfig != null ? 1 : 0) != 0, (String)"property collectdConfig must be set to a non-null value");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInterfaceDbNodeId(Connection dbConn, InetAddress ifAddress, int ifIndex) throws SQLException {
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("getInterfaceDbNodeId: attempting to lookup interface " + ifAddress.getHostAddress() + "/ifindex: " + ifIndex + " in the database."));
        }
        StringBuffer qs = new StringBuffer(RETRIEVE_IPADDR_NODEID_SQL);
        if (ifIndex != -1) {
            qs.append(" AND ifindex=?");
        }
        int nodeid = -1;
        DBUtils d = new DBUtils(this.getClass());
        try {
            PreparedStatement s = dbConn.prepareStatement(qs.toString());
            d.watch((Object)s);
            s.setString(1, ifAddress.getHostAddress());
            if (ifIndex != -1) {
                s.setInt(2, ifIndex);
            }
            ResultSet rs = s.executeQuery();
            d.watch((Object)rs);
            if (rs.next()) {
                nodeid = rs.getInt(1);
            }
        }
        finally {
            d.cleanUp();
        }
        return nodeid;
    }

    @Override
    public boolean isInterfaceInDB(final InetAddress ifAddress) {
        return (Boolean)this.m_jdbcTemplate.execute(new ConnectionCallback(){

            public Object doInConnection(Connection con) throws SQLException, DataAccessException {
                return JdbcCapsdDbSyncer.this.isInterfaceInDB(con, ifAddress) ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInterfaceInDB(Connection dbConn, InetAddress ifAddress) throws SQLException {
        boolean result = false;
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("isInterfaceInDB: attempting to lookup interface " + ifAddress.getHostAddress() + " in the database."));
        }
        ResultSet rs = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            PreparedStatement s = dbConn.prepareStatement(RETRIEVE_IPADDR_SQL);
            d.watch((Object)s);
            s.setString(1, ifAddress.getHostAddress());
            rs = s.executeQuery();
            d.watch((Object)rs);
            result = rs.next();
        }
        finally {
            d.cleanUp();
        }
        return result;
    }

    public void setNextSvcIdSql(String nextSvcIdSql) {
        this.m_nextSvcIdSql = nextSvcIdSql;
    }

    public String getNextSvcIdSql() {
        return this.m_nextSvcIdSql;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.m_jdbcTemplate = jdbcTemplate;
    }

    protected static final class LightWeightIfEntry {
        protected static final int NULL_IFINDEX = -1;
        protected static final int NULL_IFTYPE = -1;
        protected static final int LOOPBACK_IFTYPE = 24;
        private int m_nodeId;
        private int m_ifIndex;
        private int m_ifType;
        private String m_address;
        private char m_managementState;
        private char m_snmpPrimaryState;
        private boolean m_primaryStateChanged;

        public LightWeightIfEntry(int nodeId, int ifIndex, String address, char managementState, char snmpPrimaryState, int ifType) {
            this.m_nodeId = nodeId;
            this.m_ifIndex = ifIndex;
            this.m_address = address;
            this.m_managementState = managementState;
            this.m_snmpPrimaryState = snmpPrimaryState;
            this.m_ifType = ifType;
            this.m_primaryStateChanged = false;
        }

        public String getAddress() {
            return this.m_address;
        }

        public int getNodeId() {
            return this.m_nodeId;
        }

        public int getIfIndex() {
            return this.m_ifIndex;
        }

        public int getIfType() {
            return this.m_ifType;
        }

        public char getManagementState() {
            return this.m_managementState;
        }

        public char getSnmpPrimaryState() {
            return this.m_snmpPrimaryState;
        }

        public void setSnmpPrimaryState(char state) {
            if (state != this.m_snmpPrimaryState) {
                this.m_snmpPrimaryState = state;
                this.m_primaryStateChanged = true;
            }
        }

        public boolean hasSnmpPrimaryStateChanged() {
            return this.m_primaryStateChanged;
        }
    }
}

