/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.xmlrpcd;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;
import org.opennms.netmgt.xmlrpcd.XmlrpcAnticipator;

public class XmlrpcAnticipatorTest
extends TestCase {
    private static final int PORT = 9000;
    private XmlrpcAnticipator m_anticipator;

    protected void setUp() throws Exception {
        super.setUp();
        this.m_anticipator = new XmlrpcAnticipator(9000);
    }

    protected void tearDown() throws Exception {
        if (this.m_anticipator != null) {
            this.m_anticipator.shutdown();
        }
        super.tearDown();
    }

    public void testSetupAndTearDown() {
    }

    public void testSetupTwice() throws IOException {
        this.m_anticipator.shutdown();
        this.m_anticipator = new XmlrpcAnticipator(9000);
    }

    public void testGoodAnticipation() throws IOException, XmlRpcException {
        Vector<Object> v = new Vector<Object>();
        Hashtable<String, String> t = new Hashtable<String, String>();
        v.add(t);
        t.put("foo", "bar");
        Vector v2 = new Vector();
        Hashtable<String, String> t2 = new Hashtable<String, String>();
        v2.add(t2);
        t2.put("foo", "bar");
        this.m_anticipator.anticipateCall("howCheesyIsIt", v);
        XmlRpcClient client = new XmlRpcClient("http://localhost:9000");
        client.execute("howCheesyIsIt", v2);
        this.m_anticipator.verifyAnticipated();
    }

    public void testAnticipatedNotSeen() throws IOException, XmlRpcException {
        Vector<Object> v = new Vector<Object>();
        Hashtable<String, String> t = new Hashtable<String, String>();
        v.add(t);
        t.put("foo", "bar");
        Vector v2 = new Vector();
        Hashtable<String, String> t2 = new Hashtable<String, String>();
        v2.add(t2);
        t2.put("foo", "baz");
        this.m_anticipator.anticipateCall("howCheesyIsIt", v);
        XmlRpcClient client = new XmlRpcClient("http://localhost:9000");
        client.execute("howCheesyIsIt", v2);
        boolean sawException = false;
        try {
            this.m_anticipator.verifyAnticipated();
        }
        catch (AssertionFailedError e) {
            sawException = true;
        }
        if (!sawException) {
            XmlrpcAnticipatorTest.fail((String)"Did not receive an expected AssertionFailedError when calling verifyAnticipated() on the anticipator");
        }
    }

    public void testIgnoreDescriptionInsideHashtable() throws IOException, XmlRpcException {
        Vector<Object> v = new Vector<Object>();
        Hashtable<String, String> t = new Hashtable<String, String>();
        v.add(t);
        t.put("description", "cheesy");
        t.put("something other than description", "hello");
        Vector v2 = new Vector();
        Hashtable<String, String> t2 = new Hashtable<String, String>();
        v2.add(t2);
        t2.put("description", "cheesiest");
        t2.put("something other than description", "hello");
        this.m_anticipator.anticipateCall("howCheesyIsIt", v);
        XmlRpcClient client = new XmlRpcClient("http://localhost:9000");
        client.execute("howCheesyIsIt", v2);
        this.m_anticipator.verifyAnticipated();
    }
}

