/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.xmlrpcd;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.xmlrpc.WebServer;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.netmgt.xmlrpcd.Provisioner;
import org.opennms.spring.xmlrpc.XmlRpcProxyFactoryBean;
import org.opennms.spring.xmlrpc.XmlRpcServiceExporter;
import org.opennms.spring.xmlrpc.XmlRpcWebServerFactoryBean;
import org.opennms.test.mock.EasyMockUtils;
import org.opennms.test.mock.MockLogAppender;

public class XmlRpcTest {
    private static WebServer m_webServer;
    private Provisioner m_provisioner;
    private Provisioner m_proxy;
    private XmlRpcServiceExporter m_exporter;
    private EasyMockUtils m_mocks = new EasyMockUtils();

    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging();
        this.m_provisioner = (Provisioner)this.m_mocks.createMock(Provisioner.class);
        this.m_proxy = this.createRemoteProxy(this.m_provisioner);
    }

    private Provisioner createRemoteProxy(Provisioner bean) throws Exception {
        this.setUpWebServer();
        this.m_exporter = new XmlRpcServiceExporter();
        this.m_exporter.setServiceInterface(Provisioner.class);
        this.m_exporter.setService((Object)bean);
        this.m_exporter.setWebServer(m_webServer);
        this.m_exporter.afterPropertiesSet();
        Thread.sleep(1000L);
        return this.createRemoteProxy("http://localhost:9192/RPC2");
    }

    private Provisioner createRemoteProxy(String serverUrl) throws Exception {
        XmlRpcProxyFactoryBean pfb = new XmlRpcProxyFactoryBean();
        pfb.setServiceInterface(Provisioner.class);
        pfb.setServiceUrl(serverUrl);
        pfb.afterPropertiesSet();
        return (Provisioner)pfb.getObject();
    }

    private void setUpWebServer() throws Exception {
        if (m_webServer == null) {
            XmlRpcWebServerFactoryBean wsf = new XmlRpcWebServerFactoryBean();
            wsf.setPort(9192);
            wsf.setSecure(false);
            wsf.afterPropertiesSet();
            m_webServer = (WebServer)wsf.getObject();
            Thread.sleep(1000L);
        }
    }

    @After
    public void tearDown() throws Exception {
        if (this.m_exporter != null) {
            this.m_exporter.destroy();
        }
    }

    @Test
    public void testXmlRpcAddServiceICMP() throws Throwable {
        EasyMock.expect((Object)this.m_provisioner.addServiceICMP("RS-ICMP-1", 3, 1000, 300000, 30000, 300000)).andReturn((Object)true);
        this.m_mocks.replayAll();
        boolean retVal = this.m_proxy.addServiceICMP("RS-ICMP-1", 3, 1000, 300000, 30000, 300000);
        Assert.assertTrue((boolean)retVal);
        this.m_mocks.verifyAll();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testXmlRpcAddServiceICMPIllegalArg() throws Throwable {
        String msg = "retries must be greater than or equals to zero";
        EasyMock.expect((Object)this.m_provisioner.addServiceICMP("RS-ICMP-1", -1, 1000, 300000, 30000, 300000)).andThrow((Throwable)new IllegalArgumentException(msg));
        this.m_mocks.replayAll();
        this.m_proxy.addServiceICMP("RS-ICMP-1", -1, 1000, 300000, 30000, 300000);
    }

    @Test
    public void testAddServiceDNS() {
        EasyMock.expect((Object)this.m_provisioner.addServiceDNS("RS-DNS-1", 3, 1000, 300000, 30000, 300000, 1234, "www.opennms.org")).andReturn((Object)true);
        this.m_mocks.replayAll();
        boolean retVal = this.m_proxy.addServiceDNS("RS-DNS-1", 3, 1000, 300000, 30000, 300000, 1234, "www.opennms.org");
        Assert.assertTrue((boolean)retVal);
        this.m_mocks.verifyAll();
    }

    @Test
    public void testAddServiceTCP() {
        EasyMock.expect((Object)this.m_provisioner.addServiceTCP("RS-TCP-1", 3, 1000, 300000, 30000, 300000, 1234, "HELO")).andReturn((Object)true);
        this.m_mocks.replayAll();
        boolean retVal = this.m_proxy.addServiceTCP("RS-TCP-1", 3, 1000, 300000, 30000, 300000, 1234, "HELO");
        Assert.assertTrue((boolean)retVal);
        this.m_mocks.verifyAll();
    }

    @Test
    public void testAddServiceHTTP() throws MalformedURLException {
        String url = "http://www.opennms.org";
        EasyMock.expect((Object)this.m_provisioner.addServiceHTTP("RS-HTTP-1", 3, 1000, 300000, 30000, 300000, "", 80, "200", "Login", url, "user", "pw", "OpenNMS Monitor")).andReturn((Object)true);
        this.m_mocks.replayAll();
        boolean retVal = this.m_proxy.addServiceHTTP("RS-HTTP-1", 3, 1000, 300000, 30000, 300000, "", 80, "200", "Login", url, "user", "pw", "OpenNMS Monitor");
        Assert.assertTrue((boolean)retVal);
        this.m_mocks.verifyAll();
    }

    @Test(expected=MalformedURLException.class)
    public void testAddServiceHTTPInvalidURL() throws MalformedURLException {
        String url = "htt://www.opennms.org";
        EasyMock.expect((Object)this.m_provisioner.addServiceHTTP("RS-HTTP-1", 3, 1000, 300000, 30000, 300000, "", 80, "200", "Login", url, "user", "pw", "OpenNMS Monitor")).andThrow((Throwable)this.getMalformedUrlException(url));
        this.m_mocks.replayAll();
        this.m_proxy.addServiceHTTP("RS-HTTP-1", 3, 1000, 300000, 30000, 300000, "", 80, "200", "Login", url, "user", "pw", "OpenNMS Monitor");
    }

    private MalformedURLException getMalformedUrlException(String url) {
        MalformedURLException urlException = null;
        try {
            new URL(url);
        }
        catch (MalformedURLException e) {
            urlException = e;
        }
        return urlException;
    }

    @Test
    public void testAddServiceHTTPS() throws MalformedURLException {
        String url = "https://www.opennms.org";
        EasyMock.expect((Object)this.m_provisioner.addServiceHTTPS("RS-HTTPS-1", 3, 1000, 300000, 30000, 300000, "", 80, "200", "Login", url, "user", "pw", "OpenNMS Monitor")).andReturn((Object)true);
        this.m_mocks.replayAll();
        boolean retVal = this.m_proxy.addServiceHTTPS("RS-HTTPS-1", 3, 1000, 300000, 30000, 300000, "", 80, "200", "Login", url, "user", "pw", "OpenNMS Monitor");
        Assert.assertTrue((boolean)retVal);
        this.m_mocks.verifyAll();
    }

    @Test
    public void testAddServiceDatabase() throws MalformedURLException {
        String url = "jdbc://localhost/database";
        EasyMock.expect((Object)this.m_provisioner.addServiceDatabase("RS-POSTGRES-1", 3, 1000, 300000, 30000, 300000, "sa", "", "org.postgresql.Driver", url)).andReturn((Object)true);
        this.m_mocks.replayAll();
        boolean retVal = this.m_proxy.addServiceDatabase("RS-POSTGRES-1", 3, 1000, 300000, 30000, 300000, "sa", "", "org.postgresql.Driver", url);
        Assert.assertTrue((boolean)retVal);
        this.m_mocks.verifyAll();
    }
}

