/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.xmlrpcd;

import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.sql.DataSource;
import junit.framework.TestCase;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.xmlrpcd.XmlrpcServer;
import org.opennms.netmgt.mock.MockDatabase;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Snmp;
import org.opennms.netmgt.xml.event.Value;
import org.opennms.netmgt.xmlrpcd.XmlRpcNotifier;
import org.opennms.netmgt.xmlrpcd.XmlrpcAnticipator;
import org.opennms.test.ThrowableAnticipator;
import org.opennms.test.mock.MockLogAppender;
import org.opennms.test.mock.MockUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlRpcNotifierTest
extends TestCase {
    private XmlrpcAnticipator m_anticipator;
    private XmlRpcNotifier m_notifier;
    private MockDatabase m_db;
    private MockNetwork m_network;
    private static final String s_uei = "uei!";
    private static final int s_noNodeId = 0;
    private static final int s_nodeId = 1;
    private static final String s_nodeLabel = "Router";
    private static final String s_source = XmlRpcNotifierTest.class.getName();
    private static final String s_host = "bar";
    private static final String s_interface = "192.168.1.1";
    private static final String s_service = "ICMP";
    private static final String s_description = "the ICMP service";
    private static final String s_severity = "Critical";
    private static final int s_unknownNodeId = 2;
    private static int s_port = 9000;
    private static final boolean USE_DIFFERENT_PORT_PER_TEST = false;

    public void setUp() throws Exception, InterruptedException, IOException {
        System.setProperty("mock.logLevel", "DEBUG");
        System.setProperty("mock.debug", "true");
        super.setUp();
        MockUtil.println((String)("------------ Begin Test " + this.getName() + " --------------------------"));
        MockLogAppender.setupLogging();
        int port = s_port;
        this.m_anticipator = new XmlrpcAnticipator(port);
        this.anticipateNotifyReceivedEvent();
        XmlrpcServer remoteServer = new XmlrpcServer();
        remoteServer.setUrl("http://localhost:" + port);
        this.m_notifier = new XmlRpcNotifier(new XmlrpcServer[]{remoteServer}, 1, 1500, false, "");
        this.m_network = new MockNetwork();
        this.m_network.setCriticalService(s_service);
        this.m_network.addNode(1, s_nodeLabel);
        this.m_network.addInterface(s_interface);
        this.m_network.addService(s_service);
        this.m_db = new MockDatabase();
        this.m_db.populate(this.m_network);
        DataSourceFactory.setInstance((DataSource)((Object)this.m_db));
    }

    public void anticipateNotifyReceivedEvent() {
        Vector<Object> v = new Vector<Object>();
        v.add("0");
        v.add("uei.opennms.org/internal/capsd/xmlrpcNotification");
        v.add("test connection");
        this.m_anticipator.anticipateCall("notifyReceivedEvent", v);
    }

    public void finishUp() {
        this.m_anticipator.verifyAnticipated();
        MockLogAppender.assertNoWarningsOrGreater();
        MockUtil.println((String)("------------ End Test " + this.getName() + " --------------------------"));
    }

    public void tearDown() throws Exception, InterruptedException, IOException {
        this.m_anticipator.shutdown();
        super.tearDown();
    }

    public void testEventListener() {
        this.finishUp();
    }

    public void testNotifySuccess() {
        long txNo = 12345L;
        String uei = "uei.opennms.org/something!";
        String message = "hello";
        Vector<Object> v = new Vector<Object>();
        v.add(String.valueOf(txNo));
        v.add(uei);
        v.add(message);
        this.m_anticipator.anticipateCall("notifySuccess", v);
        XmlRpcNotifierTest.assertTrue((String)"notifier notifySuccess", (boolean)this.m_notifier.notifySuccess(txNo, uei, message));
        this.finishUp();
    }

    public void testFailureNotifySuccess() throws Exception {
        long txNo = 12345L;
        String uei = "uei.opennms.org/something!";
        String message = "hello";
        this.finishUp();
        this.m_anticipator.shutdown();
        XmlRpcNotifierTest.assertFalse((String)"notifier notifySuccess", (boolean)this.m_notifier.notifySuccess(txNo, uei, message));
    }

    public void testNotifyFailure() {
        long txNo = 12345L;
        String uei = "uei.opennms.org/something!";
        String message = "hello";
        Vector<Object> v = new Vector<Object>();
        v.add(String.valueOf(txNo));
        v.add(uei);
        v.add(message);
        this.m_anticipator.anticipateCall("notifyFailure", v);
        XmlRpcNotifierTest.assertTrue((String)"notifier notifyFailure", (boolean)this.m_notifier.notifyFailure(txNo, uei, message));
        this.finishUp();
    }

    public void testFailureNotifyFailure() throws Exception {
        long txNo = 12345L;
        String uei = "uei.opennms.org/something!";
        String message = "hello";
        this.finishUp();
        this.m_anticipator.shutdown();
        XmlRpcNotifierTest.assertFalse((String)"notifier notifyFailure", (boolean)this.m_notifier.notifyFailure(txNo, uei, message));
    }

    public void testNotifyReceivedEvent() {
        long txNo = 12345L;
        String uei = "uei.opennms.org/something!";
        String message = "hello";
        Vector<Object> v = new Vector<Object>();
        v.add(String.valueOf(txNo));
        v.add(uei);
        v.add(message);
        this.m_anticipator.anticipateCall("notifyReceivedEvent", v);
        XmlRpcNotifierTest.assertTrue((String)"notifier notifyReceviedEvent", (boolean)this.m_notifier.notifyReceivedEvent(txNo, uei, message));
        this.finishUp();
    }

    public void testFailureNotifyReceivedEvent() throws Exception {
        long txNo = 12345L;
        String uei = "uei.opennms.org/something!";
        String message = "hello";
        this.finishUp();
        this.m_anticipator.shutdown();
        XmlRpcNotifierTest.assertFalse((String)"notifier notifyReceviedEvent", (boolean)this.m_notifier.notifyReceivedEvent(txNo, uei, message));
    }

    public void testSendServiceDownEvent() throws Exception {
        String date = new Date().toString();
        Vector<Object> v = new Vector<Object>();
        v.add(s_nodeLabel);
        v.add(s_interface);
        v.add(s_service);
        v.add("Not Available");
        v.add(s_host);
        v.add(date);
        this.m_anticipator.anticipateCall("sendServiceDownEvent", v);
        Event e = new Event();
        e.setNodeid(1L);
        e.setInterface(s_interface);
        e.setService(s_service);
        e.setHost(s_host);
        e.setTime(date);
        XmlRpcNotifierTest.assertTrue((String)"notifier sendServiceDownEvent", (boolean)this.m_notifier.sendServiceDownEvent(e));
        this.finishUp();
    }

    public void testFailureSendServiceDownEvent() throws Exception {
        String date = new Date().toString();
        this.finishUp();
        this.m_anticipator.shutdown();
        Event e = new Event();
        e.setNodeid(1L);
        e.setInterface(s_interface);
        e.setService(s_service);
        e.setHost(s_host);
        e.setTime(date);
        XmlRpcNotifierTest.assertFalse((String)"notifier sendServiceDownEvent", (boolean)this.m_notifier.sendServiceDownEvent(e));
    }

    public void testSendServiceUpEvent() throws Exception {
        String date = new Date().toString();
        Vector<Object> v = new Vector<Object>();
        v.add(s_nodeLabel);
        v.add(s_interface);
        v.add(s_service);
        v.add("Not Available");
        v.add(s_host);
        v.add(date);
        this.m_anticipator.anticipateCall("sendServiceUpEvent", v);
        Event e = new Event();
        e.setNodeid(1L);
        e.setInterface(s_interface);
        e.setService(s_service);
        e.setHost(s_host);
        e.setTime(date);
        XmlRpcNotifierTest.assertTrue((String)"notifier sendServiceUpEvent", (boolean)this.m_notifier.sendServiceUpEvent(e));
        this.finishUp();
    }

    public void testFailureSendServiceUpEvent() throws Exception {
        String date = new Date().toString();
        this.finishUp();
        this.m_anticipator.shutdown();
        Event e = new Event();
        e.setNodeid(1L);
        e.setInterface(s_interface);
        e.setService(s_service);
        e.setHost(s_host);
        e.setTime(date);
        XmlRpcNotifierTest.assertFalse((String)"notifier sendServiceUpEvent", (boolean)this.m_notifier.sendServiceUpEvent(e));
    }

    public void testSendInterfaceDownEvent() throws Exception {
        String date = new Date().toString();
        Vector<Object> v = new Vector<Object>();
        v.add(s_nodeLabel);
        v.add(s_interface);
        v.add(s_host);
        v.add(date);
        this.m_anticipator.anticipateCall("sendInterfaceDownEvent", v);
        Event e = new Event();
        e.setNodeid(1L);
        e.setInterface(s_interface);
        e.setService(s_service);
        e.setHost(s_host);
        e.setTime(date);
        XmlRpcNotifierTest.assertTrue((String)"notifier sendInterfaceDownEvent", (boolean)this.m_notifier.sendInterfaceDownEvent(e));
        this.finishUp();
    }

    public void testFailureSendInterfaceDownEvent() throws Exception {
        String date = new Date().toString();
        this.finishUp();
        this.m_anticipator.shutdown();
        Event e = new Event();
        e.setNodeid(1L);
        e.setInterface(s_interface);
        e.setService(s_service);
        e.setHost(s_host);
        e.setTime(date);
        XmlRpcNotifierTest.assertFalse((String)"notifier sendInterfaceDownEvent", (boolean)this.m_notifier.sendInterfaceDownEvent(e));
    }

    public void testSendInterfaceUpEvent() throws Exception {
        String date = new Date().toString();
        Vector<Object> v = new Vector<Object>();
        v.add(s_nodeLabel);
        v.add(s_interface);
        v.add(s_host);
        v.add(s_host);
        v.add(date);
        this.m_anticipator.anticipateCall("sendInterfaceUpEvent", v);
        Event e = new Event();
        e.setNodeid(1L);
        e.setInterface(s_interface);
        e.setService(s_service);
        e.setHost(s_host);
        e.setTime(date);
        XmlRpcNotifierTest.assertTrue((String)"notifier sendInterfaceUpEvent", (boolean)this.m_notifier.sendInterfaceUpEvent(e));
        this.finishUp();
    }

    public void testFailureSendInterfaceUpEvent() throws Exception {
        String date = new Date().toString();
        this.finishUp();
        this.m_anticipator.shutdown();
        Event e = new Event();
        e.setNodeid(1L);
        e.setInterface(s_interface);
        e.setService(s_service);
        e.setHost(s_host);
        e.setTime(date);
        XmlRpcNotifierTest.assertFalse((String)"notifier sendInterfaceUpEvent", (boolean)this.m_notifier.sendInterfaceUpEvent(e));
    }

    public void testSendNodeDownEvent() throws Exception {
        String date = new Date().toString();
        Vector<Object> v = new Vector<Object>();
        v.add(s_nodeLabel);
        v.add(s_host);
        v.add(date);
        this.m_anticipator.anticipateCall("sendNodeDownEvent", v);
        Event e = new Event();
        e.setNodeid(1L);
        e.setHost(s_host);
        e.setTime(date);
        XmlRpcNotifierTest.assertTrue((String)"notifier sendNodeDownEvent", (boolean)this.m_notifier.sendNodeDownEvent(e));
        this.finishUp();
    }

    public void testFailureSendNodeDownEvent() throws Exception {
        String date = new Date().toString();
        this.finishUp();
        this.m_anticipator.shutdown();
        Event e = new Event();
        e.setNodeid(1L);
        e.setHost(s_host);
        e.setTime(date);
        XmlRpcNotifierTest.assertFalse((String)"notifier sendNodeDownEvent", (boolean)this.m_notifier.sendNodeDownEvent(e));
    }

    public void testSendNodeUpEvent() throws Exception {
        String date = new Date().toString();
        Vector<Object> v = new Vector<Object>();
        v.add(s_nodeLabel);
        v.add(s_host);
        v.add(date);
        this.m_anticipator.anticipateCall("sendNodeUpEvent", v);
        Event e = new Event();
        e.setNodeid(1L);
        e.setHost(s_host);
        e.setTime(date);
        XmlRpcNotifierTest.assertTrue((String)"notifier sendNodeUpEvent", (boolean)this.m_notifier.sendNodeUpEvent(e));
        this.finishUp();
    }

    public void testFailureSendNodeUpEvent() throws Exception {
        String date = new Date().toString();
        this.finishUp();
        this.m_anticipator.shutdown();
        Event e = new Event();
        e.setNodeid(1L);
        e.setHost(s_host);
        e.setTime(date);
        XmlRpcNotifierTest.assertFalse((String)"notifier sendNodeUpEvent", (boolean)this.m_notifier.sendNodeUpEvent(e));
    }

    public void testSendEventSimple() {
        String date = new Date().toString();
        Vector<Object> v = new Vector<Object>();
        XmlRpcNotifierTest.makeBasicRpcHashtable(v, date);
        this.m_anticipator.anticipateCall("sendEvent", v);
        Event e = XmlRpcNotifierTest.makeBasicEvent(date);
        XmlRpcNotifierTest.assertTrue((String)"notifier sendEvent", (boolean)this.m_notifier.sendEvent(e));
        this.finishUp();
    }

    public void testFailureSendEventSimple() throws Exception {
        String date = new Date().toString();
        this.finishUp();
        this.m_anticipator.shutdown();
        Event e = XmlRpcNotifierTest.makeBasicEvent(date);
        XmlRpcNotifierTest.assertFalse((String)"notifier sendEvent", (boolean)this.m_notifier.sendEvent(e));
    }

    public void testSendEventSource() {
        String date = new Date().toString();
        Vector<Object> v = new Vector<Object>();
        Hashtable<String, String> t = XmlRpcNotifierTest.makeBasicRpcHashtable(v, date);
        t.put("source", s_source);
        this.m_anticipator.anticipateCall("sendEvent", v);
        Event e = XmlRpcNotifierTest.makeBasicEvent(date);
        e.setSource(s_source);
        XmlRpcNotifierTest.assertTrue((String)"notifier sendEvent", (boolean)this.m_notifier.sendEvent(e));
        this.finishUp();
    }

    public void testSendEventHost() {
        String date = new Date().toString();
        Vector<Object> v = new Vector<Object>();
        Hashtable<String, String> t = XmlRpcNotifierTest.makeBasicRpcHashtable(v, date);
        t.put("host", s_host);
        this.m_anticipator.anticipateCall("sendEvent", v);
        Event e = XmlRpcNotifierTest.makeBasicEvent(date);
        e.setHost(s_host);
        XmlRpcNotifierTest.assertTrue((String)"notifier sendEvent", (boolean)this.m_notifier.sendEvent(e));
        this.finishUp();
    }

    public void testSendEventInterface() {
        String date = new Date().toString();
        Vector<Object> v = new Vector<Object>();
        Hashtable<String, String> t = XmlRpcNotifierTest.makeBasicRpcHashtable(v, date);
        t.put("interface", s_interface);
        this.m_anticipator.anticipateCall("sendEvent", v);
        Event e = XmlRpcNotifierTest.makeBasicEvent(date);
        e.setInterface(s_interface);
        XmlRpcNotifierTest.assertTrue((String)"notifier sendEvent", (boolean)this.m_notifier.sendEvent(e));
        this.finishUp();
    }

    public void testSendEventService() {
        String date = new Date().toString();
        Vector<Object> v = new Vector<Object>();
        Hashtable<String, String> t = XmlRpcNotifierTest.makeBasicRpcHashtable(v, date);
        t.put("service", s_service);
        this.m_anticipator.anticipateCall("sendEvent", v);
        Event e = XmlRpcNotifierTest.makeBasicEvent(date);
        e.setService(s_service);
        XmlRpcNotifierTest.assertTrue((String)"notifier sendEvent", (boolean)this.m_notifier.sendEvent(e));
        this.finishUp();
    }

    public void testSendEventDescription() {
        String date = new Date().toString();
        Vector<Object> v = new Vector<Object>();
        Hashtable<String, String> t = XmlRpcNotifierTest.makeBasicRpcHashtable(v, date);
        t.put("description", s_description);
        this.m_anticipator.anticipateCall("sendEvent", v);
        Event e = XmlRpcNotifierTest.makeBasicEvent(date);
        e.setDescr(s_description);
        XmlRpcNotifierTest.assertTrue((String)"notifier sendEvent", (boolean)this.m_notifier.sendEvent(e));
        this.finishUp();
    }

    public void testSendEventSeverity() {
        String date = new Date().toString();
        Vector<Object> v = new Vector<Object>();
        Hashtable<String, String> t = XmlRpcNotifierTest.makeBasicRpcHashtable(v, date);
        t.put("severity", s_severity);
        this.m_anticipator.anticipateCall("sendEvent", v);
        Event e = XmlRpcNotifierTest.makeBasicEvent(date);
        e.setSeverity(s_severity);
        XmlRpcNotifierTest.assertTrue((String)"notifier sendEvent", (boolean)this.m_notifier.sendEvent(e));
        this.finishUp();
    }

    public void testSendEventEmptyParms() {
        String date = new Date().toString();
        Vector<Object> v = new Vector<Object>();
        XmlRpcNotifierTest.makeBasicRpcHashtable(v, date);
        this.m_anticipator.anticipateCall("sendEvent", v);
        Event e = XmlRpcNotifierTest.makeBasicEvent(date);
        Parms p = new Parms();
        e.setParms(p);
        XmlRpcNotifierTest.assertTrue((String)"notifier sendEvent", (boolean)this.m_notifier.sendEvent(e));
        this.finishUp();
    }

    public void testSendEventOneParm() {
        String date = new Date().toString();
        String parmZeroName = "foo";
        String parmZeroContent = s_host;
        String parmZeroType = "string";
        Vector<Object> v = new Vector<Object>();
        Hashtable<String, String> t = XmlRpcNotifierTest.makeBasicRpcHashtable(v, date);
        XmlRpcNotifierTest.addRpcParm(t, 0, parmZeroName, parmZeroContent, parmZeroType);
        this.m_anticipator.anticipateCall("sendEvent", v);
        Event e = XmlRpcNotifierTest.makeBasicEvent(date);
        Parms p = new Parms();
        e.setParms(p);
        p.addParm(this.makeEventParm(parmZeroName, parmZeroContent, parmZeroType, "text"));
        XmlRpcNotifierTest.assertTrue((String)"notifier sendEvent", (boolean)this.m_notifier.sendEvent(e));
        this.finishUp();
    }

    public void testSendEventTwoParms() {
        String date = new Date().toString();
        String parmZeroName = "foo";
        String parmZeroContent = s_host;
        String parmZeroType = "string";
        String parmOneName = "baz";
        String parmOneContent = "blam";
        String parmOneType = "string";
        Vector<Object> v = new Vector<Object>();
        Hashtable<String, String> t = XmlRpcNotifierTest.makeBasicRpcHashtable(v, date);
        XmlRpcNotifierTest.addRpcParm(t, 0, parmZeroName, parmZeroContent, parmZeroType);
        XmlRpcNotifierTest.addRpcParm(t, 1, parmOneName, parmOneContent, parmOneType);
        this.m_anticipator.anticipateCall("sendEvent", v);
        Event e = XmlRpcNotifierTest.makeBasicEvent(date);
        Parms p = new Parms();
        e.setParms(p);
        p.addParm(this.makeEventParm(parmZeroName, parmZeroContent, parmZeroType, "text"));
        p.addParm(this.makeEventParm(parmOneName, parmOneContent, parmOneType, "text"));
        XmlRpcNotifierTest.assertTrue((String)"notifier sendEvent", (boolean)this.m_notifier.sendEvent(e));
        this.finishUp();
    }

    public void testSendEventNoNodeId() {
        String date = new Date().toString();
        Vector<Object> v = new Vector<Object>();
        Hashtable<String, String> t = new Hashtable<String, String>();
        v.add(t);
        t.put("uei", "hi!");
        t.put("time", date);
        t.put("nodeId", String.valueOf(0));
        this.m_anticipator.anticipateCall("sendEvent", v);
        Event e = new Event();
        e.setUei("hi!");
        e.setTime(date);
        XmlRpcNotifierTest.assertTrue((String)"notifier sendEvent", (boolean)this.m_notifier.sendEvent(e));
        this.finishUp();
    }

    public void testSendEventNoNodeLabel() {
        String date = new Date().toString();
        Vector<Object> v = new Vector<Object>();
        Hashtable<String, String> t = new Hashtable<String, String>();
        v.add(t);
        t.put("uei", "hi!");
        t.put("time", date);
        t.put("nodeId", String.valueOf(2));
        this.m_anticipator.anticipateCall("sendEvent", v);
        Event e = new Event();
        e.setUei("hi!");
        e.setNodeid(2L);
        e.setTime(date);
        XmlRpcNotifierTest.assertTrue((String)"notifier sendEvent", (boolean)this.m_notifier.sendEvent(e));
        this.finishUp();
    }

    public void testSendEventNullEvent() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("event object must not be null"));
        try {
            this.m_notifier.sendEvent(null);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
        this.finishUp();
    }

    public static Event makeBasicEvent(String time) {
        Event e = new Event();
        e.setUei(s_uei);
        e.setNodeid(1L);
        e.setTime(time);
        return e;
    }

    public static Snmp makeBasicTrapEventSnmp(String community, int generic, String enterpriseId, int specific, long dateLong, String version) {
        Snmp s = new Snmp();
        s.setCommunity(community);
        s.setGeneric(generic);
        s.setId(enterpriseId);
        s.setSpecific(specific);
        s.setTimeStamp(dateLong);
        s.setVersion(version);
        return s;
    }

    public static Hashtable<String, String> makeBasicRpcHashtable(Vector<Object> v, String time) {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("uei", s_uei);
        t.put("time", time);
        t.put("nodeId", String.valueOf(1));
        t.put("nodeLabel", s_nodeLabel);
        v.add(t);
        return t;
    }

    public static Hashtable<String, String> makeBasicRpcTrapHashtable(Vector<Object> v, String date, String community, int generic, String enterpriseId, int specific, long dateLong, String version) {
        Hashtable<String, String> t = XmlRpcNotifierTest.makeBasicRpcHashtable(v, date);
        t.put("communityString", community);
        t.put("genericTrapNumber", String.valueOf(generic));
        t.put("enterpriseId", enterpriseId);
        t.put("specificTrapNumber", String.valueOf(specific));
        t.put("timeStamp", String.valueOf(dateLong));
        t.put("version", version);
        return t;
    }

    public Parm makeEventParm(String name, String content, String type, String encoding) {
        Parm p = new Parm();
        p.setParmName(name);
        Value v = new Value();
        v.setContent(content);
        v.setType(type);
        v.setEncoding(encoding);
        p.setValue(v);
        return p;
    }

    public static void addRpcParm(Hashtable<String, String> t, int index, String name, String content, String type) {
        String prefix = "param" + index + " ";
        t.put(prefix + "name", name);
        t.put(prefix + "value", content);
        t.put(prefix + "type", type);
    }

    public void testSendTrapSimple() {
        long dateLong = System.currentTimeMillis();
        String date = EventConstants.formatToString((Date)new Date(dateLong));
        String enterpriseId = ".1.3.6.4.1.1.1";
        Vector<Object> v = new Vector<Object>();
        XmlRpcNotifierTest.makeBasicRpcTrapHashtable(v, date, "public", 6, enterpriseId, 2, dateLong, "1");
        this.m_anticipator.anticipateCall("sendSnmpTrapEvent", v);
        Event e = XmlRpcNotifierTest.makeBasicEvent(date);
        e.setSnmp(XmlRpcNotifierTest.makeBasicTrapEventSnmp("public", 6, enterpriseId, 2, dateLong, "1"));
        XmlRpcNotifierTest.assertTrue((String)"notifier sendEvent", (boolean)this.m_notifier.sendEvent(e));
        this.finishUp();
    }

    public void testFailureSendTrapSimple() throws Exception {
        long dateLong = System.currentTimeMillis();
        String date = new Date(dateLong).toString();
        String enterpriseId = ".1.3.6.4.1.1.1";
        this.finishUp();
        this.m_anticipator.shutdown();
        Event e = XmlRpcNotifierTest.makeBasicEvent(date);
        e.setSnmp(XmlRpcNotifierTest.makeBasicTrapEventSnmp("public", 6, enterpriseId, 2, dateLong, "1"));
        XmlRpcNotifierTest.assertFalse((String)"notifier sendEvent", (boolean)this.m_notifier.sendEvent(e));
    }

    public void testSendTrapIdText() {
        long dateLong = System.currentTimeMillis();
        String date = new Date(dateLong).toString();
        String enterpriseId = ".1.3.6.4.1.1.1";
        Vector<Object> v = new Vector<Object>();
        Hashtable<String, String> t = XmlRpcNotifierTest.makeBasicRpcTrapHashtable(v, date, "public", 6, enterpriseId, 2, dateLong, "1");
        t.put("enterpriseIdText", "foo!");
        this.m_anticipator.anticipateCall("sendSnmpTrapEvent", v);
        Event e = XmlRpcNotifierTest.makeBasicEvent(date);
        Snmp s = XmlRpcNotifierTest.makeBasicTrapEventSnmp("public", 6, enterpriseId, 2, dateLong, "1");
        s.setIdtext("foo!");
        e.setSnmp(s);
        XmlRpcNotifierTest.assertTrue((String)"notifier sendEvent", (boolean)this.m_notifier.sendEvent(e));
        this.finishUp();
    }

    public void testSendTrapEmptySnmp() {
        String date = new Date().toString();
        Vector<Object> v = new Vector<Object>();
        XmlRpcNotifierTest.makeBasicRpcTrapHashtable(v, date, "null", 0, "null", 0, 0L, "null");
        this.m_anticipator.anticipateCall("sendSnmpTrapEvent", v);
        Event e = XmlRpcNotifierTest.makeBasicEvent(date);
        Snmp s = new Snmp();
        e.setSnmp(s);
        XmlRpcNotifierTest.assertTrue((String)"notifier sendEvent", (boolean)this.m_notifier.sendEvent(e));
        this.finishUp();
    }
}

