/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import java.io.Reader;
import java.net.InetAddress;
import org.opennms.netmgt.config.TrapdConfig;
import org.opennms.netmgt.config.TrapdConfigFactory;
import org.opennms.netmgt.dao.db.AbstractTransactionalTemporaryDatabaseSpringContextTests;
import org.opennms.netmgt.mock.EventAnticipator;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpV1TrapBuilder;
import org.opennms.netmgt.trapd.Trapd;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Logmsg;
import org.opennms.test.ConfigurationTestUtils;
import org.opennms.test.DaoTestConfigBean;

public class TrapdTest
extends AbstractTransactionalTemporaryDatabaseSpringContextTests {
    private int m_port = 1162;
    private Trapd m_trapd = new Trapd();

    protected void setUpConfiguration() throws Exception {
        DaoTestConfigBean daoTestConfig = new DaoTestConfigBean();
        daoTestConfig.afterPropertiesSet();
        Reader rdr = ConfigurationTestUtils.getReaderForResourceWithReplacements((Object)((Object)this), (String)"trapd-configuration.xml", (String[][])new String[][]{{"@snmp-trap-port@", Integer.toString(this.m_port)}});
        TrapdConfigFactory.setInstance((TrapdConfig)new TrapdConfigFactory(rdr));
    }

    protected String[] getConfigLocations() {
        return new String[]{"classpath:META-INF/opennms/applicationContext-dao.xml", "classpath:META-INF/opennms/applicationContext-daemon.xml", "classpath:META-INF/opennms/applicationContext-trapDaemon.xml"};
    }

    protected void onSetUpInTransactionIfEnabled() throws Exception {
        this.m_trapd.onStart();
    }

    protected void onTearDownInTransactionIfEnabled() throws Exception {
        this.m_trapd.onStop();
    }

    public Trapd getDaemon() {
        return this.m_trapd;
    }

    public void setDaemon(Trapd daemon) {
        this.m_trapd = daemon;
    }

    public void testSnmpV1TrapSend() throws Exception {
        String localhost = "127.0.0.1";
        InetAddress localAddr = InetAddress.getByName(localhost);
        SnmpV1TrapBuilder pdu = SnmpUtils.getV1TrapBuilder();
        pdu.setEnterprise(SnmpObjId.get((String)".1.3.6.1.4.1.5813"));
        pdu.setGeneric(1);
        pdu.setSpecific(0);
        pdu.setTimeStamp(666L);
        pdu.setAgentAddress(localAddr);
        Event e = new Event();
        e.setUei("uei.opennms.org/default/trap");
        e.setSource("trapd");
        e.setInterface(localhost);
        Logmsg logmsg = new Logmsg();
        logmsg.setDest("logndisplay");
        e.setLogmsg(logmsg);
        EventAnticipator ea = new EventAnticipator();
        ea.anticipateEvent(e);
        pdu.send(localhost, this.m_port, "public");
        pdu.send(localhost, this.m_port, "public");
        pdu.send(localhost, this.m_port, "public");
        pdu.send(localhost, this.m_port, "public");
        TrapdTest.assertEquals((String)"number of anticipated events", (int)1, (int)ea.waitForAnticipated(1000L).size());
        Thread.sleep(2000L);
        TrapdTest.assertEquals((String)"number of unanticipated events", (int)0, (int)ea.unanticipatedEvents().size());
    }
}

