/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.opennms.netmgt.mock.OpenNMSTestCase;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.SnmpValueFactory;
import org.opennms.netmgt.trapd.SyntaxToEvent;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.test.PropertySettingTestSuite;

public class SyntaxToEventTest
extends OpenNMSTestCase {
    public static TestSuite suite() {
        Class<SyntaxToEventTest> testClass = SyntaxToEventTest.class;
        TestSuite suite = new TestSuite(testClass.getName());
        suite.addTest((Test)new PropertySettingTestSuite(testClass, "JoeSnmp Tests", "org.opennms.snmp.strategyClass", "org.opennms.netmgt.snmp.joesnmp.JoeSnmpStrategy"));
        suite.addTest((Test)new PropertySettingTestSuite(testClass, "Snmp4J Tests", "org.opennms.snmp.strategyClass", "org.opennms.netmgt.snmp.snmp4j.Snmp4JStrategy"));
        return suite;
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testProcessSyntax() {
        SnmpValueFactory valueFactory = SnmpUtils.getValueFactory();
        SyntaxToEventTest.assertNotNull((Object)valueFactory);
        byte[] macAddr = new byte[]{0, 0, 0, 0, 0, 0};
        SnmpValue octetString = valueFactory.getOctetString(macAddr);
        Parm parm = SyntaxToEvent.processSyntax((String)"Test", (SnmpValue)octetString);
        SyntaxToEventTest.assertEquals((String)"Test", (String)parm.getParmName());
        SyntaxToEventTest.assertEquals((String)"......", (String)parm.getValue().getContent());
    }
}

